/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.kafka;

import java.io.File;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServerStartable;
import org.apache.commons.io.FileUtils;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.ZookeeperTestEnvironment;
import org.locationtech.geowave.test.kafka.KafkaTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTestEnvironment
implements TestEnvironment {
    private static KafkaTestEnvironment singletonInstance;
    private static final Logger LOGGER;
    private KafkaServerStartable kafkaServer;

    public static synchronized KafkaTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new KafkaTestEnvironment();
        }
        return singletonInstance;
    }

    private KafkaTestEnvironment() {
    }

    @Override
    public void setup() throws Exception {
        if (this.kafkaServer == null) {
            LOGGER.info("Starting up Kafka Server...");
            FileUtils.deleteDirectory((File)KafkaTestUtils.DEFAULT_LOG_DIR);
            boolean success = KafkaTestUtils.DEFAULT_LOG_DIR.mkdir();
            if (!success) {
                LOGGER.warn("Unable to create Kafka log dir [" + KafkaTestUtils.DEFAULT_LOG_DIR.getAbsolutePath() + "]");
            }
            KafkaConfig config = KafkaTestUtils.getKafkaBrokerConfig();
            this.kafkaServer = new KafkaServerStartable(config);
            this.kafkaServer.startup();
            Thread.sleep(3000L);
        }
    }

    @Override
    public void tearDown() throws Exception {
        LOGGER.info("Shutting down Kafka Server...");
        this.kafkaServer.shutdown();
        this.kafkaServer = null;
        FileUtils.forceDeleteOnExit((File)KafkaTestUtils.DEFAULT_LOG_DIR);
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[]{ZookeeperTestEnvironment.getInstance()};
    }

    static {
        LOGGER = LoggerFactory.getLogger(KafkaTestEnvironment.class);
    }
}

