/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.kerberos;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.security.handler.KerberosAuthenticator;
import org.apache.accumulo.server.security.handler.KerberosAuthorizor;
import org.apache.accumulo.server.security.handler.KerberosPermissionHandler;
import org.apache.accumulo.test.functional.NativeMapIT;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.locationtech.geowave.test.kerberos.KerberosTestingUtilSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosTestingUtil
implements KerberosTestingUtilSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger(KerberosTestingUtil.class);
    private TestingKdc kdc;
    protected static final File TEMP_DIR = new File("./target/kerberos_temp");
    protected static final File TEMP_KEYTABS_DIR = new File(TEMP_DIR, "keytabs");
    public static final String TRUE = Boolean.toString(true);
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private ClusterUser rootUser;

    @Override
    public void setup() throws Exception {
        Assert.assertTrue((TEMP_DIR.mkdirs() || TEMP_DIR.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((TEMP_KEYTABS_DIR.mkdirs() || TEMP_KEYTABS_DIR.isDirectory() ? 1 : 0) != 0);
        this.kdc = new TestingKdc(TEMP_DIR, TEMP_KEYTABS_DIR);
        this.kdc.start();
        System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        this.rootUser = this.kdc.getRootUser();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.kdc) {
            this.kdc.stop();
        }
        if (TEMP_DIR.exists()) {
            try {
                Thread.sleep(2000L);
                FileUtils.deleteDirectory((File)TEMP_DIR);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.warn("Unable to delete mini Kerberos temporary directory", (Throwable)e);
            }
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration(false));
    }

    @Override
    public void configureMiniAccumulo(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        cfg.setNativeLibPaths(new String[]{NativeMapIT.nativeMapLocation().getAbsolutePath()});
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, Boolean.TRUE.toString());
        Map siteConfig = cfg.getSiteConfig();
        if (TRUE.equals(siteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            throw new RuntimeException("Cannot use both SSL and SASL/Kerberos");
        }
        if (TRUE.equals(siteConfig.get(Property.INSTANCE_RPC_SASL_ENABLED.getKey()))) {
            return;
        }
        if (null == this.kdc) {
            throw new IllegalStateException("MiniClusterKdc was null");
        }
        LOGGER.info("Enabling Kerberos/SASL for minicluster");
        cfg.setProperty(Property.INSTANCE_RPC_SASL_ENABLED, "true");
        ClusterUser serverUser = this.kdc.getAccumuloServerUser();
        cfg.setProperty(Property.GENERAL_KERBEROS_KEYTAB, serverUser.getKeytab().getAbsolutePath());
        cfg.setProperty(Property.GENERAL_KERBEROS_PRINCIPAL, serverUser.getPrincipal());
        cfg.setProperty(Property.INSTANCE_SECURITY_AUTHENTICATOR, KerberosAuthenticator.class.getName());
        cfg.setProperty(Property.INSTANCE_SECURITY_AUTHORIZOR, KerberosAuthorizor.class.getName());
        cfg.setProperty(Property.INSTANCE_SECURITY_PERMISSION_HANDLER, KerberosPermissionHandler.class.getName());
        cfg.setProperty(Property.TRACE_USER, serverUser.getPrincipal());
        cfg.setProperty(Property.TRACE_TOKEN_TYPE, KerberosToken.CLASS_NAME);
        Map systemProperties = cfg.getSystemProperties();
        systemProperties.put(JAVA_SECURITY_KRB5_CONF, System.getProperty(JAVA_SECURITY_KRB5_CONF, ""));
        systemProperties.put(SUN_SECURITY_KRB5_DEBUG, System.getProperty(SUN_SECURITY_KRB5_DEBUG, "false"));
        cfg.setSystemProperties(systemProperties);
        cfg.setRootUserName(this.kdc.getRootUser().getPrincipal());
        coreSite.set("hadoop.security.authentication", "kerberos");
    }

    @Override
    public ClusterUser getRootUser() {
        return this.rootUser;
    }
}

