/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.services;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.locationtech.geowave.test.GeoWaveITRunner;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.mapreduce.MapReduceTestEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesTestEnvironment
implements TestEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesTestEnvironment.class);
    private static ServicesTestEnvironment singletonInstance = null;
    private static String[] PARENT_CLASSLOADER_LIBRARIES = new String[]{"hbase", "hadoop", "protobuf", "guava", "restlet", "spring"};
    protected static final int JETTY_PORT = 9011;
    protected static final String JETTY_BASE_URL = "http://localhost:9011";
    protected static final int ACCEPT_QUEUE_SIZE = 100;
    protected static final int MAX_IDLE_TIME = (int)TimeUnit.HOURS.toMillis(1L);
    protected static final int SO_LINGER_TIME = -1;
    protected static final int MAX_FORM_CONTENT_SIZE = 0x200000;
    protected static final String GEOSERVER_USER = "admin";
    protected static final String GEOSERVER_PASS = "geoserver";
    protected static final String TEST_WORKSPACE = "geowave_test";
    protected static final String GEOSERVER_WAR_DIR = "target/geoserver";
    protected static final String GEOSERVER_CONTEXT_PATH = "/geoserver";
    protected static final String GEOSERVER_BASE_URL = "http://localhost:9011/geoserver";
    protected static final String GEOSERVER_REST_PATH = "http://localhost:9011/geoserver/rest";
    protected static final String GEOWAVE_WAR_DIR = "target/restservices";
    protected static final String GEOWAVE_CONTEXT_PATH = "/restservices";
    protected static final String GEOWAVE_BASE_URL = "http://localhost:9011/restservices";
    protected static final String GEOWAVE_CONFIG_FILE = "target/restservices/config.properties";
    protected static final String GEOWAVE_WORKSPACE_PATH = "target/geoserver/data/workspaces/geowave_test";
    protected static final String TEST_STYLE_NAME_NO_DIFFERENCE = "SubsamplePoints-2px";
    protected static final String TEST_STYLE_NAME_MINOR_SUBSAMPLE = "SubsamplePoints-10px";
    protected static final String TEST_STYLE_NAME_MAJOR_SUBSAMPLE = "SubsamplePoints-100px";
    protected static final String TEST_STYLE_NAME_DISTRIBUTED_RENDER = "DistributedRender";
    protected static final String TEST_STYLE_PATH = "src/test/resources/sld/";
    protected static final String TEST_GEOSERVER_LOGGING_PATH = "src/test/resources/logging.xml";
    protected static final String TEST_LOG_PROPERTIES_PATH = "src/test/resources/log4j-test.properties";
    protected static final String TEST_GEOSERVER_LOG_PROPERTIES_PATH = "target/geoserver/data/logs/log4j-test.properties";
    protected static final String EXISTING_GEOSERVER_LOGGING_PATH = "target/geoserver/data/logging.xml";
    protected static final String TEST_SLD_NO_DIFFERENCE_FILE = "src/test/resources/sld/SubsamplePoints-2px.sld";
    protected static final String TEST_SLD_MINOR_SUBSAMPLE_FILE = "src/test/resources/sld/SubsamplePoints-10px.sld";
    protected static final String TEST_SLD_MAJOR_SUBSAMPLE_FILE = "src/test/resources/sld/SubsamplePoints-100px.sld";
    protected static final String TEST_SLD_DISTRIBUTED_RENDER_FILE = "src/test/resources/sld/DistributedRender.sld";
    private Server jettyServer;

    public static synchronized ServicesTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ServicesTestEnvironment();
        }
        return singletonInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="Jetty must be started before releasing the lock")
    public void setup() throws Exception {
        Object object = GeoWaveITRunner.MUTEX;
        synchronized (object) {
            this.doSetup();
        }
    }

    private void doSetup() {
        block12: {
            if (this.jettyServer == null) {
                try {
                    System.setProperty("GEOSERVER_XSTREAM_WHITELIST", "org.geoserver.wfs.**;org.geoserver.wms.**");
                    this.jettyServer = new Server();
                    ServerConnector conn = new ServerConnector(this.jettyServer);
                    conn.setPort(9011);
                    conn.setAcceptQueueSize(100);
                    conn.setIdleTimeout((long)MAX_IDLE_TIME);
                    conn.setSoLingerTime(-1);
                    this.jettyServer.setConnectors(new Connector[]{conn});
                    FileUtils.copyFile((File)new File(TEST_GEOSERVER_LOGGING_PATH), (File)new File(EXISTING_GEOSERVER_LOGGING_PATH));
                    FileUtils.copyFile((File)new File(TEST_LOG_PROPERTIES_PATH), (File)new File(TEST_GEOSERVER_LOG_PROPERTIES_PATH));
                    final WebAppContext gsWebapp = new WebAppContext();
                    gsWebapp.setContextPath(GEOSERVER_CONTEXT_PATH);
                    gsWebapp.setResourceBase(GEOSERVER_WAR_DIR);
                    WebAppClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<WebAppClassLoader>(){

                        @Override
                        public WebAppClassLoader run() {
                            try {
                                return new WebAppClassLoader((WebAppClassLoader.Context)gsWebapp);
                            }
                            catch (IOException e) {
                                LOGGER.error("Unable to create new classloader", (Throwable)e);
                                return null;
                            }
                        }
                    });
                    if (classLoader == null) {
                        throw new IOException("Unable to create classloader");
                    }
                    String classpath = System.getProperty("java.class.path").replace(":", ";");
                    String[] individualEntries = classpath.split(";");
                    StringBuffer str = new StringBuffer();
                    for (String e : individualEntries) {
                        boolean addLibraryToWebappContext = true;
                        if (!e.contains("geowave")) {
                            for (String parentLoaderLibrary : PARENT_CLASSLOADER_LIBRARIES) {
                                if (!e.contains(parentLoaderLibrary)) continue;
                                addLibraryToWebappContext = false;
                                break;
                            }
                        }
                        if (!addLibraryToWebappContext) continue;
                        str.append(e).append(";");
                    }
                    classLoader.addClassPath(str.toString());
                    gsWebapp.setClassLoader((ClassLoader)classLoader);
                    gsWebapp.setParentLoaderPriority(false);
                    File configFile = new File(GEOWAVE_CONFIG_FILE);
                    if (configFile.exists() && !configFile.delete()) {
                        LOGGER.warn("Unable to delete config file");
                    }
                    WebAppContext restWebapp = new WebAppContext();
                    restWebapp.setContextPath(GEOWAVE_CONTEXT_PATH);
                    restWebapp.setWar(GEOWAVE_WAR_DIR);
                    restWebapp.setInitParameter("config_file", GEOWAVE_CONFIG_FILE);
                    this.jettyServer.setHandler((Handler)new ContextHandlerCollection(new ContextHandler[]{gsWebapp, restWebapp}));
                    gsWebapp.getServletContext().getContextHandler().setMaxFormContentSize(0x200000);
                    this.jettyServer.start();
                    while (!this.jettyServer.isRunning() && !this.jettyServer.isStarted()) {
                        Thread.sleep(1000L);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error("Could not start the Jetty server: " + e.getMessage(), (Throwable)e);
                    if (!this.jettyServer.isRunning()) break block12;
                    try {
                        this.jettyServer.stop();
                    }
                    catch (Exception e1) {
                        LOGGER.error("Unable to stop the Jetty server", (Throwable)e1);
                    }
                }
            }
        }
    }

    public void restartServices() throws Exception {
        if (this.jettyServer != null) {
            this.jettyServer.stop();
            this.jettyServer = null;
            this.doSetup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        Object object = GeoWaveITRunner.MUTEX;
        synchronized (object) {
            if (!GeoWaveITRunner.DEFER_CLEANUP.get() && this.jettyServer != null) {
                try {
                    this.jettyServer.stop();
                    this.jettyServer = null;
                    if (!new File(GEOWAVE_CONFIG_FILE).delete()) {
                        LOGGER.warn("Unable to delete config file");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unable to stop the Jetty server", (Throwable)e);
                }
            }
        }
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[]{MapReduceTestEnvironment.getInstance()};
    }
}

