/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.spark;

import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.locationtech.geowave.analytic.spark.GeoWaveSparkConf;
import org.locationtech.geowave.test.TestEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkTestEnvironment
implements TestEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkTestEnvironment.class);
    private static SparkTestEnvironment singletonInstance = null;
    protected SparkSession defaultSession = null;

    public static synchronized SparkTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new SparkTestEnvironment();
        }
        return singletonInstance;
    }

    @Override
    public void setup() throws Exception {
        if (this.defaultSession == null) {
            SparkConf addonOptions = new SparkConf();
            addonOptions.setMaster("local[*]");
            addonOptions.setAppName("CoreGeoWaveSparkITs");
            this.defaultSession = GeoWaveSparkConf.createDefaultSession((SparkConf)addonOptions);
            if (this.defaultSession == null) {
                LOGGER.error("Unable to create default spark session for tests");
                return;
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.defaultSession != null) {
            this.defaultSession.close();
            this.defaultSession = null;
        }
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    public SparkSession getDefaultSession() {
        return this.defaultSession;
    }
}

