/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.accumulo.AccumuloStoreFactoryFamily;
import org.locationtech.geowave.datastore.accumulo.cli.MiniAccumuloClusterFactory;
import org.locationtech.geowave.datastore.accumulo.cli.MiniAccumuloUtils;
import org.locationtech.geowave.datastore.accumulo.config.AccumuloRequiredOptions;
import org.locationtech.geowave.test.KerberosTestEnvironment;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.ZookeeperTestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloStoreTestEnvironment
extends StoreTestEnvironment {
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new AccumuloStoreFactoryFamily().getDataStoreFactory();
    private static AccumuloStoreTestEnvironment singletonInstance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(AccumuloStoreTestEnvironment.class);
    private static final boolean KEEP_LOGS = false;
    private static final int NUM_TABLET_SERVERS = 2;
    protected static final String DEFAULT_MINI_ACCUMULO_PASSWORD = "Ge0wave";
    protected static final File TEMP_DIR = new File("./target/accumulo_temp");
    protected String zookeeper;
    protected String accumuloInstance;
    protected String accumuloUser;
    protected String accumuloPassword;
    protected MiniAccumuloCluster miniAccumulo;
    private final List<Process> cleanup = new ArrayList<Process>();

    public static synchronized AccumuloStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new AccumuloStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private AccumuloStoreTestEnvironment() {
    }

    @Override
    public void setup() {
        if (!TestUtils.isSet(this.zookeeper)) {
            this.zookeeper = System.getProperty("zookeeperUrl");
            if (!TestUtils.isSet(this.zookeeper)) {
                this.zookeeper = ZookeeperTestEnvironment.getInstance().getZookeeper();
                LOGGER.debug("Using local zookeeper URL: " + this.zookeeper);
            }
        }
        if (!(TestUtils.isSet(this.accumuloInstance) && TestUtils.isSet(this.accumuloUser) && TestUtils.isSet(this.accumuloPassword))) {
            this.accumuloInstance = System.getProperty("instance");
            this.accumuloUser = System.getProperty("username");
            this.accumuloPassword = System.getProperty("password");
            if (!(TestUtils.isSet(this.accumuloInstance) && TestUtils.isSet(this.accumuloUser) && TestUtils.isSet(this.accumuloPassword))) {
                try {
                    if (!TEMP_DIR.exists() && !TEMP_DIR.mkdirs()) {
                        throw new IOException("Could not create temporary directory");
                    }
                    TEMP_DIR.deleteOnExit();
                    this.accumuloUser = "root";
                    this.accumuloPassword = DEFAULT_MINI_ACCUMULO_PASSWORD;
                    MiniAccumuloConfig config = new MiniAccumuloConfig(TEMP_DIR, DEFAULT_MINI_ACCUMULO_PASSWORD);
                    config.setZooKeeperPort(Integer.parseInt(this.zookeeper.split(":")[1]));
                    config.setNumTservers(2);
                    this.miniAccumulo = MiniAccumuloClusterFactory.newAccumuloCluster((MiniAccumuloConfig)config, AccumuloStoreTestEnvironment.class, (URL[])new URL[0]);
                    this.startMiniAccumulo(config);
                    this.accumuloInstance = this.miniAccumulo.getInstanceName();
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.warn("Unable to start mini accumulo instance", (Throwable)e);
                    LOGGER.info("Check '" + TEMP_DIR.getAbsolutePath() + File.separator + "logs' for more info");
                    if (SystemUtils.IS_OS_WINDOWS) {
                        LOGGER.warn("For windows, make sure that Cygwin is installed and set a CYGPATH environment variable to %CYGWIN_HOME%/bin/cygpath to successfully run a mini accumulo cluster");
                    }
                    Assert.fail((String)("Unable to start mini accumulo instance: '" + e.getLocalizedMessage() + "'"));
                }
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Spotbugs is failing with this bug which is a false positive and ironically an identified bug in spotbugs")
    private void startMiniAccumulo(MiniAccumuloConfig config) throws IOException, InterruptedException {
        LinkedList<String> jvmArgs = new LinkedList<String>();
        jvmArgs.add("-XX:CompressedClassSpaceSize=512m");
        jvmArgs.add("-XX:MaxMetaspaceSize=512m");
        jvmArgs.add("-Xmx512m");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AccumuloStoreTestEnvironment.this.tearDown();
            }
        });
        Configuration coreSite = new Configuration(false);
        Map siteConfig = MiniAccumuloUtils.getSiteConfig((MiniAccumuloConfig)config);
        siteConfig.put(Property.INSTANCE_ZK_HOST.getKey(), this.zookeeper);
        config.setSiteConfig(siteConfig);
        if (KerberosTestEnvironment.useKerberos()) {
            siteConfig.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
            siteConfig.put(Property.INSTANCE_SECRET.getKey(), this.accumuloPassword);
            KerberosTestEnvironment.getInstance().configureMiniAccumulo(config, coreSite);
            File siteFile = new File(MiniAccumuloUtils.getConfDir((MiniAccumuloConfig)config), "accumulo.properties");
            this.writeConfig(siteFile, MiniAccumuloUtils.getSiteConfig((MiniAccumuloConfig)config).entrySet());
            if (coreSite.size() > 0) {
                File csFile = new File(MiniAccumuloUtils.getConfDir((MiniAccumuloConfig)config), "core-site.xml");
                TestUtils.writeConfigToFile(csFile, coreSite);
            }
        }
        LinkedList<String> args = new LinkedList<String>();
        args.add("--instance-name");
        args.add(config.getInstanceName());
        if (!KerberosTestEnvironment.useKerberos()) {
            args.add("--password");
            args.add(config.getRootPassword());
        } else {
            args.add("--user");
            args.add(KerberosTestEnvironment.getInstance().getRootUser().getPrincipal());
        }
        Process initProcess = MiniAccumuloUtils.exec((MiniAccumuloCluster)this.miniAccumulo, Initialize.class, jvmArgs, (String[])args.toArray(new String[0]));
        this.cleanup.add(initProcess);
        int ret = initProcess.waitFor();
        if (ret != 0) {
            File logDir = MiniAccumuloUtils.getLogDir((MiniAccumuloConfig)config);
            if (logDir != null) {
                for (File fileEntry : logDir.listFiles()) {
                    LOGGER.warn("Contents of " + fileEntry.getName());
                    try (Scanner sc = new Scanner(fileEntry, "UTF-8");){
                        while (sc.hasNextLine()) {
                            String s = sc.nextLine();
                            LOGGER.warn(s);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to read log file", (Throwable)e);
                    }
                }
                throw new RuntimeException("Initialize process returned " + ret + ". Check the logs in " + logDir + " for errors.");
            }
            throw new RuntimeException("Initialize process returned " + ret + ". Cannot find log directory.");
        }
        LOGGER.info("Starting MAC against instance " + config.getInstanceName() + " and zookeeper(s)  " + MiniAccumuloUtils.getZooKeepers((MiniAccumuloConfig)config));
        for (int i = 0; i < config.getNumTservers(); ++i) {
            this.cleanup.add(MiniAccumuloUtils.exec((MiniAccumuloCluster)this.miniAccumulo, TabletServer.class, jvmArgs, (String[])new String[0]));
        }
        this.cleanup.add(MiniAccumuloUtils.exec((MiniAccumuloCluster)this.miniAccumulo, Master.class, jvmArgs, (String[])new String[0]));
        this.cleanup.add(MiniAccumuloUtils.exec((MiniAccumuloCluster)this.miniAccumulo, SimpleGarbageCollector.class, jvmArgs, (String[])new String[0]));
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private void writeConfig(File file, Iterable<Map.Entry<String, String>> settings) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);){
            for (Map.Entry<String, String> entry : settings) {
                String value = entry.getValue().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                fileWriter.append(entry.getKey() + "=" + value + "\n");
            }
        }
    }

    @Override
    public void tearDown() {
        this.zookeeper = null;
        this.accumuloInstance = null;
        this.accumuloUser = null;
        this.accumuloPassword = null;
        if (this.miniAccumulo != null) {
            try {
                for (Process p : this.cleanup) {
                    p.destroy();
                    p.waitFor();
                }
                for (Process p : this.cleanup) {
                    p.destroy();
                    p.waitFor();
                }
                this.miniAccumulo = null;
            }
            catch (InterruptedException e) {
                LOGGER.warn("Unable to stop mini accumulo instance", (Throwable)e);
            }
        }
        if (TEMP_DIR != null) {
            try {
                Thread.sleep(2000L);
                FileUtils.deleteDirectory((File)TEMP_DIR);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.warn("Unable to delete mini Accumulo temporary directory", (Throwable)e);
            }
        }
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        AccumuloRequiredOptions accumuloOpts = (AccumuloRequiredOptions)options;
        if (KerberosTestEnvironment.useKerberos()) {
            ClusterUser rootUser = KerberosTestEnvironment.getInstance().getRootUser();
            accumuloOpts.setUser(rootUser.getPrincipal());
            accumuloOpts.setKeytab(rootUser.getKeytab().getAbsolutePath());
            accumuloOpts.setUseSasl(true);
        } else {
            accumuloOpts.setUser(this.accumuloUser);
            accumuloOpts.setPassword(this.accumuloPassword);
        }
        accumuloOpts.setInstance(this.accumuloInstance);
        accumuloOpts.setZookeeper(this.zookeeper);
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.ACCUMULO;
    }

    public String getZookeeper() {
        return this.zookeeper;
    }

    public String getAccumuloInstance() {
        return this.accumuloInstance;
    }

    public String getAccumuloUser() {
        return this.accumuloUser;
    }

    public String getAccumuloPassword() {
        return this.accumuloPassword;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        if (KerberosTestEnvironment.useKerberos()) {
            return new TestEnvironment[]{KerberosTestEnvironment.getInstance(), ZookeeperTestEnvironment.getInstance()};
        }
        return new TestEnvironment[]{ZookeeperTestEnvironment.getInstance()};
    }
}

