/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.cassandra.CassandraStoreFactoryFamily;
import org.locationtech.geowave.datastore.cassandra.cli.CassandraServer;
import org.locationtech.geowave.datastore.cassandra.config.CassandraOptions;
import org.locationtech.geowave.datastore.cassandra.config.CassandraRequiredOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStoreTestEnvironment
extends StoreTestEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraStoreTestEnvironment.class);
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new CassandraStoreFactoryFamily().getDataStoreFactory();
    private static CassandraStoreTestEnvironment singletonInstance = null;
    protected static final File TEMP_DIR = new File(System.getProperty("user.dir") + File.separator + "target", "cassandra_temp");
    protected static final File DATA_DIR = new File(TEMP_DIR.getAbsolutePath() + File.separator + "cassandra", "data");
    protected static final String NODE_DIRECTORY_PREFIX = "cassandra";
    private boolean running = false;
    CassandraServer s;

    public static synchronized CassandraStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new CassandraStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private CassandraStoreTestEnvironment() {
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        CassandraRequiredOptions cassandraOpts = (CassandraRequiredOptions)options;
        cassandraOpts.getAdditionalOptions().setReplicationFactor(1);
        cassandraOpts.getAdditionalOptions().setDurableWrites(false);
        cassandraOpts.getAdditionalOptions().setGcGraceSeconds(0);
        try {
            HashMap<String, String> tableOptions = new HashMap<String, String>();
            tableOptions.put("compaction", new ObjectMapper().writeValueAsString((Object)SchemaBuilder.sizeTieredCompactionStrategy().withMinSSTableSizeInBytes(500000L).withMinThreshold(2).withUncheckedTombstoneCompaction(true).getOptions()));
            tableOptions.put("gc_grace_seconds", new ObjectMapper().writeValueAsString((Object)0));
            cassandraOpts.getAdditionalOptions().setTableOptions(tableOptions);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        cassandraOpts.setContactPoints("127.0.0.1");
        ((CassandraOptions)cassandraOpts.getStoreOptions()).setBatchWriteSize(5);
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    public void setup() {
        if (!this.running) {
            if (TEMP_DIR.exists()) {
                CassandraStoreTestEnvironment.cleanTempDir();
            }
            if (!TEMP_DIR.mkdirs()) {
                LOGGER.warn("Unable to create temporary cassandra directory");
            }
            this.s = new CassandraServer();
            this.s.start();
            this.running = true;
        }
    }

    @Override
    public void tearDown() {
        if (this.running) {
            this.s.stop();
            this.running = false;
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Unable to sleep waiting to delete directory", (Throwable)e);
        }
        CassandraStoreTestEnvironment.cleanTempDir();
    }

    private static void cleanTempDir() {
        try {
            FileUtils.deleteDirectory((File)TEMP_DIR);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to delete temp cassandra directory", (Throwable)e);
        }
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.CASSANDRA;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    @Override
    public int getMaxCellSize() {
        return 65536;
    }
}

