/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.locationtech.geowave.test.annotation.Environments;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.locationtech.geowave.test.annotation.GeoWaveTestStoreImpl;
import org.locationtech.geowave.test.annotation.NamespaceOverride;
import org.locationtech.geowave.test.annotation.OptionsOverride;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoWaveITRunner
extends Suite {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveITRunner.class);
    public static final AtomicBoolean DEFER_CLEANUP = new AtomicBoolean(false);
    public static final Object MUTEX = new Object();
    public static final String STORE_TYPE_ENVIRONMENT_VARIABLE_NAME = "STORE_TYPE";
    public static final String STORE_TYPE_PROPERTY_NAME = "testStoreType";
    public static final String DATASTORE_OPTIONS_ENVIRONMENT_VARIABLE_NAME = "STORE_OPTIONS";
    public static final String DATASTORE_OPTIONS_PROPERTY_NAME = "testStoreOptions";
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final List<Runner> runners = new ArrayList<Runner>();
    private final Set<GeoWaveTestStore.GeoWaveStoreType> storeTypes = new HashSet<GeoWaveTestStore.GeoWaveStoreType>();
    private final TestEnvironment[] testEnvs;

    protected Statement withBeforeClasses(Statement statement) {
        try {
            Method setupMethod = GeoWaveITRunner.class.getDeclaredMethod("setup", new Class[0]);
            setupMethod.setAccessible(true);
            return super.withBeforeClasses((Statement)new RunBefores(statement, Collections.singletonList(new FrameworkMethod(setupMethod)), (Object)this));
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.warn("Unable to find setup method", (Throwable)e);
            return super.withBeforeClasses(statement);
        }
    }

    protected Statement withAfterClasses(Statement statement) {
        try {
            Statement newStatement = super.withAfterClasses(statement);
            Method tearDownMethod = GeoWaveITRunner.class.getDeclaredMethod("tearDown", new Class[0]);
            tearDownMethod.setAccessible(true);
            return new RunAfters(newStatement, Collections.singletonList(new FrameworkMethod(tearDownMethod)), (Object)this);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.warn("Unable to find tearDown method", (Throwable)e);
            return super.withAfterClasses(statement);
        }
    }

    public GeoWaveITRunner(Class<?> klass) throws InitializationError, SecurityException, GeoWaveITException {
        super(klass, NO_RUNNERS);
        this.createRunnersForDataStores();
        this.testEnvs = this.getTestEnvironments();
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private void createRunnersForDataStores() throws InitializationError, SecurityException, GeoWaveITException {
        String[][] profileOptionSets;
        ArrayList<GeoWaveStoreRunnerConfig> configs = new ArrayList<GeoWaveStoreRunnerConfig>();
        String storeTypeProp = System.getenv(STORE_TYPE_ENVIRONMENT_VARIABLE_NAME);
        if (!TestUtils.isSet(storeTypeProp)) {
            storeTypeProp = System.getProperty(STORE_TYPE_PROPERTY_NAME);
        }
        Set<String> dataStoreOptionFields = this.getDataStoreOptionFieldsForTypeAnnotation();
        GeoWaveTestStore.GeoWaveStoreType storeType = TestUtils.isSet(storeTypeProp) ? GeoWaveTestStore.GeoWaveStoreType.valueOf(storeTypeProp) : GeoWaveTestStore.GeoWaveStoreType.ROCKSDB;
        if (this.containsAnnotationForType(storeType)) {
            configs.add(new GeoWaveStoreRunnerConfig(storeType, dataStoreOptionFields));
            this.storeTypes.add(storeType);
        }
        for (String[] profileOptions : profileOptionSets = this.getProfileOptionSets()) {
            for (GeoWaveStoreRunnerConfig config : configs) {
                TestClassRunnerForStoreTypes runner = new TestClassRunnerForStoreTypes(this.getTestClass().getJavaClass(), config.fieldNameStoreTypePair, profileOptions);
                this.runners.add((Runner)runner);
            }
        }
    }

    private String[][] getProfileOptionSets() {
        String optionsStr = System.getenv(DATASTORE_OPTIONS_ENVIRONMENT_VARIABLE_NAME);
        if (!TestUtils.isSet(optionsStr)) {
            optionsStr = System.getProperty(DATASTORE_OPTIONS_PROPERTY_NAME);
        }
        String[][] profileOptions = null;
        if (TestUtils.isSet(optionsStr)) {
            String[] optionSets = optionsStr.split("!");
            profileOptions = new String[optionSets.length][];
            for (int i = 0; i < optionSets.length; ++i) {
                profileOptions[i] = optionSets[i].split(",");
            }
        }
        if (profileOptions == null) {
            profileOptions = new String[1][];
        }
        return profileOptions;
    }

    private boolean containsAnnotationForType(GeoWaveTestStore.GeoWaveStoreType storeType) {
        if (this.typeIsAnnotated()) {
            GeoWaveTestStore store = this.getTestClass().getJavaClass().getAnnotation(GeoWaveTestStore.class);
            for (GeoWaveTestStore.GeoWaveStoreType annotationType : store.value()) {
                if (annotationType != storeType) continue;
                return true;
            }
        } else {
            for (FrameworkField field : this.getTestClass().getAnnotatedFields(GeoWaveTestStore.class)) {
                for (GeoWaveTestStore.GeoWaveStoreType annotationType : field.getField().getAnnotation(GeoWaveTestStore.class).value()) {
                    if (annotationType != storeType) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Set<String> getDataStoreOptionFieldsForTypeAnnotation() throws SecurityException, GeoWaveITException {
        Field[] fields = this.getTestClass().getJavaClass().getDeclaredFields();
        HashSet<String> dataStoreOptionFields = new HashSet<String>();
        for (Field field : fields) {
            if (!field.getType().isAssignableFrom(DataStorePluginOptions.class)) continue;
            dataStoreOptionFields.add(field.getName());
        }
        if (dataStoreOptionFields.isEmpty()) {
            throw new GeoWaveITException("Types annotated with GeoWaveTestStore must have at least one field of type DataStorePluginOptions");
        }
        return dataStoreOptionFields;
    }

    private static List<GeoWaveStoreRunnerConfig> addRunnerConfigsForField(FrameworkField field, List<GeoWaveStoreRunnerConfig> currentConfigs, Set<GeoWaveTestStore.GeoWaveStoreType> storeTypes) throws GeoWaveITException {
        GeoWaveTestStore store = field.getField().getAnnotation(GeoWaveTestStore.class);
        GeoWaveTestStore.GeoWaveStoreType[] types = store.value();
        if (types == null || types.length == 0) {
            throw new GeoWaveITException(MessageFormat.format("{0} must have at least one GeoWaveStoreType", field.getName()));
        }
        ArrayList<GeoWaveStoreRunnerConfig> newConfigs = new ArrayList<GeoWaveStoreRunnerConfig>();
        for (GeoWaveStoreRunnerConfig config : currentConfigs) {
            for (GeoWaveTestStore.GeoWaveStoreType type : types) {
                newConfigs.add(new GeoWaveStoreRunnerConfig(config, field.getName(), type));
                storeTypes.add(type);
            }
        }
        return newConfigs;
    }

    private List<FrameworkField> getStoreAnnotatedFields() {
        return this.getTestClass().getAnnotatedFields(GeoWaveTestStore.class);
    }

    private List<FrameworkMethod> getTestEnvAnnotatedMethods() {
        return this.getTestClass().getAnnotatedMethods(Environments.class);
    }

    private TestEnvironment[] getTestEnvironments() throws NullPointerException {
        HashSet<Object> environments = new HashSet<Object>();
        Environments es = this.getTestClass().getJavaClass().getAnnotation(Environments.class);
        if (es != null) {
            Environments.Environment[] envs = es.value();
            for (Environments.Environment environment : envs) {
                environments.add((Object)environment);
            }
        }
        List<FrameworkMethod> envMethods = this.getTestEnvAnnotatedMethods();
        for (FrameworkMethod m : envMethods) {
            Environments.Environment[] envs;
            for (Environments.Environment env : envs = m.getMethod().getAnnotation(Environments.class).value()) {
                environments.add((Object)env);
            }
        }
        TestEnvironment[] testEnvs = new TestEnvironment[environments.size() + this.storeTypes.size()];
        int i = 0;
        for (GeoWaveTestStore.GeoWaveStoreType geoWaveStoreType : this.storeTypes) {
            testEnvs[i++] = geoWaveStoreType.getTestEnvironment();
        }
        for (Environments.Environment environment : environments) {
            testEnvs[i++] = environment.getTestEnvironment();
        }
        return this.processDependencies(testEnvs);
    }

    private TestEnvironment[] processDependencies(TestEnvironment[] testEnvs) {
        TestEnvironmentDependencyTree dependencyTree = new TestEnvironmentDependencyTree();
        for (TestEnvironment e : testEnvs) {
            dependencyTree.processDependencies(e);
        }
        return dependencyTree.getOrderedTestEnvironments();
    }

    private boolean fieldsAreAnnotated() {
        return !this.getStoreAnnotatedFields().isEmpty();
    }

    private boolean typeIsAnnotated() {
        return this.getTestClass().getJavaClass().isAnnotationPresent(GeoWaveTestStore.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup() throws Exception {
        Object object = MUTEX;
        synchronized (object) {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
            for (TestEnvironment e : this.testEnvs) {
                e.setup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        Object object = MUTEX;
        synchronized (object) {
            if (!DEFER_CLEANUP.get()) {
                List<TestEnvironment> envs = Arrays.asList(this.testEnvs);
                ListIterator<TestEnvironment> it = envs.listIterator(envs.size());
                while (it.hasPrevious()) {
                    it.previous().tearDown();
                }
            }
        }
    }

    private static class TestEnvironmentDependencyTree {
        Map<TestEnvironment, Set<TestEnvironment>> dependenciesMapping = new LinkedHashMap<TestEnvironment, Set<TestEnvironment>>();
        Map<TestEnvironment, Set<TestEnvironment>> requirementsMapping = new LinkedHashMap<TestEnvironment, Set<TestEnvironment>>();
        Set<TestEnvironment> independentEnvironments = new LinkedHashSet<TestEnvironment>();
        Set<TestEnvironment> visitedEnvs = new LinkedHashSet<TestEnvironment>();

        private TestEnvironmentDependencyTree() {
        }

        private void processDependencies(TestEnvironment env) {
            if (!this.visitedEnvs.contains(env)) {
                this.visitedEnvs.add(env);
                if (env.getDependentEnvironments() == null || env.getDependentEnvironments().length == 0) {
                    this.independentEnvironments.add(env);
                } else {
                    for (TestEnvironment requiredEnv : env.getDependentEnvironments()) {
                        Set<TestEnvironment> dependentSet = this.dependenciesMapping.get(requiredEnv);
                        if (dependentSet == null) {
                            dependentSet = new HashSet<TestEnvironment>();
                            this.dependenciesMapping.put(requiredEnv, dependentSet);
                        }
                        dependentSet.add(env);
                        Set<TestEnvironment> requiredSet = this.requirementsMapping.get(env);
                        if (requiredSet == null) {
                            requiredSet = new HashSet<TestEnvironment>();
                            this.requirementsMapping.put(env, requiredSet);
                        }
                        requiredSet.add(requiredEnv);
                        this.processDependencies(requiredEnv);
                    }
                }
            }
        }

        private TestEnvironment[] getOrderedTestEnvironments() {
            TestEnvironment[] retVal = new TestEnvironment[this.visitedEnvs.size()];
            int i = 0;
            HashSet<TestEnvironment> testsAddedToArray = new HashSet<TestEnvironment>();
            for (TestEnvironment e : this.independentEnvironments) {
                retVal[i++] = e;
                testsAddedToArray.add(e);
            }
            for (TestEnvironment entry : this.requirementsMapping.keySet()) {
                this.traverseRequirements(entry, retVal, i++, testsAddedToArray);
            }
            return retVal;
        }

        private int traverseRequirements(TestEnvironment env, TestEnvironment[] currentOrderedArray, int startIndex, Set<TestEnvironment> testsAddedToArray) {
            int count = 0;
            Set<TestEnvironment> requirements = this.requirementsMapping.get(env);
            for (TestEnvironment req : requirements) {
                if (testsAddedToArray.contains(req)) continue;
                count = this.traverseRequirements(req, currentOrderedArray, startIndex + count, testsAddedToArray);
            }
            currentOrderedArray[startIndex + count++] = env;
            testsAddedToArray.add(env);
            return count;
        }
    }

    private static class GeoWaveITException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public GeoWaveITException(String message) {
            super(message);
        }
    }

    private static class GeoWaveStoreRunnerConfig {
        private final Map<String, GeoWaveTestStore.GeoWaveStoreType> fieldNameStoreTypePair;

        public GeoWaveStoreRunnerConfig() {
            this.fieldNameStoreTypePair = new HashMap<String, GeoWaveTestStore.GeoWaveStoreType>();
        }

        public GeoWaveStoreRunnerConfig(GeoWaveTestStore.GeoWaveStoreType storeType, Set<String> fieldNames) {
            this.fieldNameStoreTypePair = new HashMap<String, GeoWaveTestStore.GeoWaveStoreType>();
            for (String fieldName : fieldNames) {
                this.fieldNameStoreTypePair.put(fieldName, storeType);
            }
        }

        public GeoWaveStoreRunnerConfig(GeoWaveStoreRunnerConfig previousConfig, String name, GeoWaveTestStore.GeoWaveStoreType type) {
            this.fieldNameStoreTypePair = previousConfig == null || previousConfig.fieldNameStoreTypePair == null ? new HashMap<String, GeoWaveTestStore.GeoWaveStoreType>() : new HashMap<String, GeoWaveTestStore.GeoWaveStoreType>(previousConfig.fieldNameStoreTypePair);
            this.fieldNameStoreTypePair.put(name, type);
        }
    }

    private class TestClassRunnerForStoreTypes
    extends BlockJUnit4ClassRunner {
        private final Map<String, GeoWaveTestStore.GeoWaveStoreType> fieldNameStoreTypePair;
        private final String nameSuffix;
        private final String[] profileOptions;

        private TestClassRunnerForStoreTypes(Class<?> type, Map<String, GeoWaveTestStore.GeoWaveStoreType> fieldNameStoreTypePair, String[] profileOptions) throws InitializationError {
            super(type);
            this.fieldNameStoreTypePair = fieldNameStoreTypePair;
            this.profileOptions = profileOptions;
            StringBuilder nameBldr = new StringBuilder();
            for (Map.Entry<String, GeoWaveTestStore.GeoWaveStoreType> e : fieldNameStoreTypePair.entrySet()) {
                nameBldr.append(" (").append(e.getKey()).append("=").append(e.getValue().toString()).append(")");
            }
            if (profileOptions != null && profileOptions.length > 0) {
                nameBldr.append("; options=").append("\"" + String.join((CharSequence)",", profileOptions) + "\"");
            }
            this.nameSuffix = nameBldr.toString();
        }

        public Object createTest() throws Exception {
            return this.createTestUsingFieldInjection();
        }

        private Object createTestUsingFieldInjection() throws IllegalAccessException, SecurityException, NoSuchFieldException, GeoWaveITException, InstantiationException {
            HashSet<ImmutablePair> fieldsAndStorePairs = new HashSet<ImmutablePair>();
            if (GeoWaveITRunner.this.typeIsAnnotated()) {
                GeoWaveTestStore store = this.getTestClass().getJavaClass().getAnnotation(GeoWaveTestStore.class);
                for (String string : this.fieldNameStoreTypePair.keySet()) {
                    Field field = this.getTestClass().getJavaClass().getDeclaredField(string);
                    GeoWaveTestStoreImpl storeWithOverrides = new GeoWaveTestStoreImpl(store);
                    if (field.isAnnotationPresent(NamespaceOverride.class)) {
                        storeWithOverrides.setNamespace(field.getAnnotation(NamespaceOverride.class).value());
                    } else if (field.isAnnotationPresent(OptionsOverride.class)) {
                        storeWithOverrides.setOptions(field.getAnnotation(OptionsOverride.class).value());
                    }
                    fieldsAndStorePairs.add(new ImmutablePair((Object)field, (Object)storeWithOverrides));
                }
            } else {
                List annotatedFields = GeoWaveITRunner.this.getStoreAnnotatedFields();
                if (annotatedFields.size() != this.fieldNameStoreTypePair.size()) {
                    throw new GeoWaveITException("Wrong number of stores and @GeoWaveTestStore fields. @GeoWaveTestStore fields counted: " + annotatedFields.size() + ", available parameters: " + this.fieldNameStoreTypePair.size() + ".");
                }
                for (FrameworkField frameworkField : annotatedFields) {
                    fieldsAndStorePairs.add(new ImmutablePair((Object)frameworkField.getField(), (Object)frameworkField.getField().getAnnotation(GeoWaveTestStore.class)));
                }
            }
            Object testClassInstance = this.getTestClass().getJavaClass().newInstance();
            for (Pair pair : fieldsAndStorePairs) {
                GeoWaveTestStore.GeoWaveStoreType type = this.fieldNameStoreTypePair.get(((Field)pair.getLeft()).getName());
                ((Field)pair.getLeft()).setAccessible(true);
                GeoWaveTestStore store = (GeoWaveTestStore)pair.getRight();
                ((Field)pair.getLeft()).set(testClassInstance, type.getTestEnvironment().getDataStoreOptions(store, this.profileOptions));
            }
            return testClassInstance;
        }

        protected String getName() {
            return super.getName() + this.nameSuffix;
        }

        protected String testName(FrameworkMethod method) {
            return method.getName() + " - " + this.getName();
        }

        protected void validateFields(List<Throwable> errors) {
            super.validateFields(errors);
            if (GeoWaveITRunner.this.typeIsAnnotated()) {
                if (GeoWaveITRunner.this.fieldsAreAnnotated()) {
                    errors.add(new GeoWaveITException("Only type or fields can be annotated with @GeoWaveTestStore, not both"));
                }
                try {
                    GeoWaveITRunner.this.getDataStoreOptionFieldsForTypeAnnotation();
                }
                catch (Exception e) {
                    errors.add(e);
                }
            } else if (GeoWaveITRunner.this.fieldsAreAnnotated()) {
                List annotatedFields = GeoWaveITRunner.this.getStoreAnnotatedFields();
                for (FrameworkField field : annotatedFields) {
                    if (field.getType().isAssignableFrom(DataStorePluginOptions.class)) continue;
                    errors.add(new GeoWaveITException("'" + field.getName() + "' must be of type '" + DataStorePluginOptions.class.getName() + "'"));
                }
            }
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }
    }
}

