/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.apache.accumulo.server.security.handler.KerberosAuthenticator;
import org.apache.accumulo.server.security.handler.KerberosAuthorizor;
import org.apache.accumulo.server.security.handler.KerberosPermissionHandler;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.locationtech.geowave.datastore.accumulo.cli.MiniAccumuloUtils;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosTestEnvironment
implements TestEnvironment {
    private static KerberosTestEnvironment singletonInstance = null;
    private static final String TEST_KERBEROS_ENVIRONMENT_VARIABLE_NAME = "TEST_KERBEROS";
    private static final String TEST_KERBEROS_PROPERTY_NAME = "testKerberos";
    private static final Logger LOGGER = LoggerFactory.getLogger(KerberosTestEnvironment.class);
    private TestingKdc kdc;
    protected static final File TEMP_DIR = new File("./target/kerberos_temp");
    protected static final File TEMP_KEYTABS_DIR = new File(TEMP_DIR, "keytabs");
    public static final String TRUE = Boolean.toString(true);
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private ClusterUser rootUser;
    private boolean running = false;

    public static synchronized KerberosTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new KerberosTestEnvironment();
        }
        return singletonInstance;
    }

    private KerberosTestEnvironment() {
    }

    public boolean isRunning() {
        return this.running;
    }

    public static boolean useKerberos() {
        String kerberosStr = System.getenv(TEST_KERBEROS_ENVIRONMENT_VARIABLE_NAME);
        if (!TestUtils.isSet(kerberosStr)) {
            kerberosStr = System.getProperty(TEST_KERBEROS_PROPERTY_NAME);
        }
        return TestUtils.isSet(kerberosStr) && "true".equalsIgnoreCase(kerberosStr);
    }

    @Override
    public void setup() throws Exception {
        Assert.assertTrue((TEMP_DIR.mkdirs() || TEMP_DIR.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((TEMP_KEYTABS_DIR.mkdirs() || TEMP_KEYTABS_DIR.isDirectory() ? 1 : 0) != 0);
        this.kdc = new TestingKdc(TEMP_DIR, TEMP_KEYTABS_DIR);
        this.kdc.start();
        System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        this.rootUser = this.kdc.getRootUser();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.running = true;
    }

    @Override
    public void tearDown() throws Exception {
        if (this.kdc != null) {
            this.kdc.stop();
            this.running = false;
        }
        if (TEMP_DIR.exists()) {
            try {
                Thread.sleep(2000L);
                FileUtils.deleteDirectory((File)TEMP_DIR);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.warn("Unable to delete mini Kerberos temporary directory", (Throwable)e);
            }
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration(false));
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    public void configureMiniAccumulo(MiniAccumuloConfig cfg, Configuration coreSite) {
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.TSERV_NATIVEMAP_ENABLED, (String)Boolean.FALSE.toString());
        Map siteConfig = cfg.getSiteConfig();
        if (TRUE.equals(siteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            throw new RuntimeException("Cannot use both SSL and SASL/Kerberos");
        }
        if (TRUE.equals(siteConfig.get(Property.INSTANCE_RPC_SASL_ENABLED.getKey()))) {
            return;
        }
        if (this.kdc == null) {
            throw new IllegalStateException("MiniClusterKdc was null");
        }
        LOGGER.info("Enabling Kerberos/SASL for minicluster");
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.INSTANCE_RPC_SASL_ENABLED, (String)"true");
        ClusterUser serverUser = this.kdc.getAccumuloServerUser();
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.GENERAL_KERBEROS_KEYTAB, (String)serverUser.getKeytab().getAbsolutePath());
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.GENERAL_KERBEROS_PRINCIPAL, (String)serverUser.getPrincipal());
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.INSTANCE_SECURITY_AUTHENTICATOR, (String)KerberosAuthenticator.class.getName());
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.INSTANCE_SECURITY_AUTHORIZOR, (String)KerberosAuthorizor.class.getName());
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.INSTANCE_SECURITY_PERMISSION_HANDLER, (String)KerberosPermissionHandler.class.getName());
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.TRACE_USER, (String)serverUser.getPrincipal());
        MiniAccumuloUtils.setProperty((MiniAccumuloConfig)cfg, (Property)Property.TRACE_TOKEN_TYPE, (String)KerberosToken.CLASS_NAME);
        Map systemProperties = MiniAccumuloUtils.getSystemProperties((MiniAccumuloConfig)cfg);
        systemProperties.put(JAVA_SECURITY_KRB5_CONF, System.getProperty(JAVA_SECURITY_KRB5_CONF, ""));
        systemProperties.put(SUN_SECURITY_KRB5_DEBUG, System.getProperty(SUN_SECURITY_KRB5_DEBUG, "false"));
        MiniAccumuloUtils.setSystemProperties((MiniAccumuloConfig)cfg, (Map)systemProperties);
        MiniAccumuloUtils.setRootUserName((MiniAccumuloConfig)cfg, (String)this.kdc.getRootUser().getPrincipal());
        MiniAccumuloUtils.setClientProperty((MiniAccumuloConfig)cfg, (Object)MiniAccumuloUtils.getClientProperty((String)"SASL_ENABLED"), (String)"true");
        coreSite.set("hadoop.security.authentication", "kerberos");
    }

    public ClusterUser getRootUser() {
        return this.rootUser;
    }
}

