/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import org.apache.kudu.test.cluster.FakeDNS;
import org.locationtech.geowave.core.store.GenericStoreFactory;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.datastore.kudu.KuduStoreFactoryFamily;
import org.locationtech.geowave.datastore.kudu.cli.KuduLocal;
import org.locationtech.geowave.datastore.kudu.config.KuduRequiredOptions;
import org.locationtech.geowave.test.StoreTestEnvironment;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.annotation.GeoWaveTestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduStoreTestEnvironment
extends StoreTestEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuduStoreTestEnvironment.class);
    private static final GenericStoreFactory<DataStore> STORE_FACTORY = new KuduStoreFactoryFamily().getDataStoreFactory();
    private static KuduStoreTestEnvironment singletonInstance = null;
    private final KuduLocal kuduLocal = new KuduLocal(null, 1);

    public static synchronized KuduStoreTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new KuduStoreTestEnvironment();
        }
        return singletonInstance;
    }

    private KuduStoreTestEnvironment() {
    }

    @Override
    public void setup() throws Exception {
        FakeDNS.getInstance().install();
        if (!this.kuduLocal.start()) {
            LOGGER.error("Kudu database startup failed");
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.kuduLocal.stop();
        this.kuduLocal.destroyDB();
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    @Override
    protected GenericStoreFactory<DataStore> getDataStoreFactory() {
        return STORE_FACTORY;
    }

    @Override
    protected GeoWaveTestStore.GeoWaveStoreType getStoreType() {
        return GeoWaveTestStore.GeoWaveStoreType.KUDU;
    }

    @Override
    protected void initOptions(StoreFactoryOptions options) {
        KuduRequiredOptions kuduOptions = (KuduRequiredOptions)options;
        kuduOptions.setKuduMaster(this.kuduLocal.getMasterAddressesAsString());
    }

    @Override
    public int getMaxCellSize() {
        return 65536;
    }
}

