/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProviders;
import org.locationtech.geowave.datastore.hbase.cli.ZookeeperMiniCluster;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.TestUtils;

public class ZookeeperTestEnvironment
implements TestEnvironment {
    private static ZookeeperTestEnvironment singletonInstance = null;
    protected String zookeeper;
    private ZookeeperMiniCluster zookeeperMiniCluster;
    public static final String ZK_PROPERTY_NAME = "zookeeperUrl";
    public static final String DEFAULT_ZK_TEMP_DIR = "./target/zk_temp";

    public static synchronized ZookeeperTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ZookeeperTestEnvironment();
        }
        return singletonInstance;
    }

    private ZookeeperTestEnvironment() {
    }

    @Override
    public void setup() throws Exception {
        SaslClientAuthenticationProviders.getInstance((Configuration)new Configuration());
        if (!TestUtils.isSet(this.zookeeper)) {
            this.zookeeper = System.getProperty(ZK_PROPERTY_NAME);
            if (!TestUtils.isSet(this.zookeeper)) {
                this.zookeeperMiniCluster = ZookeeperMiniCluster.getInstance((String)"./target/hbase/lib", (String)DEFAULT_ZK_TEMP_DIR);
                this.zookeeperMiniCluster.setup();
                this.zookeeper = this.zookeeperMiniCluster.getZookeeper();
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.zookeeperMiniCluster != null) {
            this.zookeeperMiniCluster.tearDown();
        }
        this.zookeeper = null;
    }

    public String getZookeeper() {
        return this.zookeeper;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }
}

