/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.test.kafka;

import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.locationtech.geowave.test.TestEnvironment;
import org.locationtech.geowave.test.kafka.KafkaTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTestEnvironment
implements TestEnvironment {
    private static KafkaTestEnvironment singletonInstance;
    private static final Logger LOGGER;
    private EmbeddedKafkaCluster kafkaServer;
    private String bootstrapServers;

    public static synchronized KafkaTestEnvironment getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new KafkaTestEnvironment();
        }
        return singletonInstance;
    }

    private KafkaTestEnvironment() {
    }

    @Override
    public void setup() throws Exception {
        if (this.kafkaServer == null) {
            LOGGER.info("Starting up Kafka Server...");
            FileUtils.deleteDirectory((File)KafkaTestUtils.DEFAULT_LOG_DIR);
            boolean success = KafkaTestUtils.DEFAULT_LOG_DIR.mkdir();
            if (!success) {
                LOGGER.warn("Unable to create Kafka log dir [" + KafkaTestUtils.DEFAULT_LOG_DIR.getAbsolutePath() + "]");
            }
            String localhost = "localhost";
            try {
                localhost = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.warn("unable to get canonical hostname for localhost", (Throwable)e);
            }
            Properties config = KafkaTestUtils.getKafkaBrokerConfig(localhost);
            this.kafkaServer = new EmbeddedKafkaCluster(1, config);
            this.bootstrapServers = localhost + ":9092";
            this.kafkaServer.start();
        }
    }

    @Override
    public void tearDown() throws Exception {
        LOGGER.info("Shutting down Kafka Server...");
        if (this.kafkaServer != null) {
            Method m = this.kafkaServer.getClass().getDeclaredMethod("after", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this.kafkaServer, new Object[0]);
            this.kafkaServer = null;
        }
        FileUtils.forceDeleteOnExit((File)KafkaTestUtils.DEFAULT_LOG_DIR);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public TestEnvironment[] getDependentEnvironments() {
        return new TestEnvironment[0];
    }

    static {
        LOGGER = LoggerFactory.getLogger(KafkaTestEnvironment.class);
    }
}

