/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.sfcurve.hilbert;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.uzaygezen.core.BacktrackingQueryBuilder;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.CompactHilbertCurve;
import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.FilterCombiner;
import com.google.uzaygezen.core.FilteredIndexRange;
import com.google.uzaygezen.core.IndexCalculator;
import com.google.uzaygezen.core.LongContent;
import com.google.uzaygezen.core.PlainFilterCombiner;
import com.google.uzaygezen.core.Query;
import com.google.uzaygezen.core.RegionInspector;
import com.google.uzaygezen.core.SimpleRegionInspector;
import com.google.uzaygezen.core.SpaceVisitor;
import com.google.uzaygezen.core.ZoomingNavigator;
import com.google.uzaygezen.core.ZoomingSpaceVisitorAdapter;
import com.google.uzaygezen.core.ranges.LongRange;
import com.google.uzaygezen.core.ranges.LongRangeHome;
import com.google.uzaygezen.core.ranges.RangeHome;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.sfcurve.IndexRange;
import org.locationtech.sfcurve.IndexRange$;
import org.locationtech.sfcurve.RangeComputeHints;
import org.locationtech.sfcurve.SpaceFillingCurve2D;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001-\u0011a\u0002S5mE\u0016\u0014HoQ;sm\u0016\u0014DI\u0003\u0002\u0004\t\u00059\u0001.\u001b7cKJ$(BA\u0003\u0007\u0003\u001d\u0019hmY;sm\u0016T!a\u0002\u0005\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\t%\u0011Q\u0003\u0002\u0002\u0014'B\f7-\u001a$jY2LgnZ\"veZ,'\u0007\u0012\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005Q!/Z:pYV$\u0018n\u001c8\u0011\u00055I\u0012B\u0001\u000e\u000f\u0005\rIe\u000e\u001e\u0005\u00069\u0001!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005y\u0001\u0003CA\u0010\u0001\u001b\u0005\u0011\u0001\"B\f\u001c\u0001\u0004A\u0002b\u0002\u0012\u0001\u0005\u0004%\taI\u0001\naJ,7-[:j_:,\u0012\u0001\n\t\u0003\u001b\u0015J!A\n\b\u0003\t1{gn\u001a\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u0015A\u0014XmY5tS>t\u0007\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\u0002\u0007\rD7-F\u0001-!\tic'D\u0001/\u0015\ty\u0003'\u0001\u0003d_J,'BA\u00193\u0003%)(0Y=hKj,gN\u0003\u00024i\u00051qm\\8hY\u0016T\u0011!N\u0001\u0004G>l\u0017BA\u001c/\u0005M\u0019u.\u001c9bGRD\u0015\u000e\u001c2feR\u001cUO\u001d<f\u0011\u0019I\u0004\u0001)A\u0005Y\u0005!1\r[2!\u0011\u0015Y\u0004\u0001\"\u0002=\u0003Y9W\r\u001e(pe6\fG.\u001b>fI2{gnZ5uk\u0012,GC\u0001\u0013>\u0011\u0015q$\b1\u0001@\u0003\u0005A\bCA\u0007A\u0013\t\teB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0007\u0002!)\u0001R\u0001\u0016O\u0016$hj\u001c:nC2L'0\u001a3MCRLG/\u001e3f)\t!S\tC\u0003G\u0005\u0002\u0007q(A\u0001z\u0011\u0015A\u0005\u0001\"\u0002J\u0003U\u0019X\r\u001e(pe6\fG.\u001b>fI2\u000bG/\u001b;vI\u0016$\"a\u0010&\t\u000b-;\u0005\u0019\u0001\u0013\u0002\u00131\fGOT8s[\u0006d\u0007\"B'\u0001\t\u000bq\u0015AF:fi:{'/\\1mSj,G\rT8oO&$X\u000fZ3\u0015\u0005}z\u0005\"\u0002)M\u0001\u0004!\u0013!\u00037p]:{'/\\1m\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003\u001d!x.\u00138eKb$2\u0001\n+V\u0011\u0015q\u0014\u000b1\u0001@\u0011\u00151\u0015\u000b1\u0001@\u0011\u00159\u0006\u0001\"\u0001Y\u0003\u001d!x\u000eU8j]R$\"!\u0017/\u0011\t5QvhP\u0005\u00037:\u0011a\u0001V;qY\u0016\u0014\u0004\"B/W\u0001\u0004!\u0013!A5\t\u000b}\u0003A\u0011\u00011\u0002\u0011Q|'+\u00198hKN$b!\u00199siZD\bc\u00012k[:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003M*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005%t\u0011a\u00029bG.\fw-Z\u0005\u0003W2\u00141aU3r\u0015\tIg\u0002\u0005\u0002\u0014]&\u0011q\u000e\u0002\u0002\u000b\u0013:$W\r\u001f*b]\u001e,\u0007\"B9_\u0001\u0004y\u0014\u0001\u0002=nS:DQa\u001d0A\u0002}\nA!_7j]\")QO\u0018a\u0001\u007f\u0005!\u00010\\1y\u0011\u00159h\f1\u0001@\u0003\u0011IX.\u0019=\t\u000fet\u0006\u0013!a\u0001u\u0006)\u0001.\u001b8ugB\u0019Qb_?\n\u0005qt!AB(qi&|g\u000e\u0005\u0002\u0014}&\u0011q\u0010\u0002\u0002\u0012%\u0006tw-Z\"p[B,H/\u001a%j]R\u001c\b\"CA\u0002\u0001E\u0005I\u0011IA\u0003\u0003I!xNU1oO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\u001d!f\u0001>\u0002\n-\u0012\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00169\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI\"a\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class HilbertCurve2D
implements SpaceFillingCurve2D {
    private final int resolution;
    private final long precision;
    private final CompactHilbertCurve chc;

    public long precision() {
        return this.precision;
    }

    public CompactHilbertCurve chc() {
        return this.chc;
    }

    public final long getNormalizedLongitude(double x) {
        return (long)((x + (double)180) * (double)(this.precision() - 1L) / 360.0);
    }

    public final long getNormalizedLatitude(double y) {
        return (long)((y + (double)90) * (double)(this.precision() - 1L) / 180.0);
    }

    public final double setNormalizedLatitude(long latNormal) {
        if (latNormal >= 0L && latNormal <= this.precision()) {
            return (double)latNormal * 180.0 / (double)(this.precision() - 1L);
        }
        throw new NumberFormatException("Normalized latitude must be greater than 0 and less than the maximum precision");
    }

    public final double setNormalizedLongitude(long lonNormal) {
        if (lonNormal >= 0L && lonNormal <= this.precision()) {
            return (double)lonNormal * 360.0 / (double)(this.precision() - 1L);
        }
        throw new NumberFormatException("Normalized longitude must be greater than 0 and less than the maximum precision");
    }

    public long toIndex(double x, double y) {
        long normX = this.getNormalizedLongitude(x);
        long normY = this.getNormalizedLatitude(y);
        BitVector[] p = (BitVector[])((Object[])new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution)), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution))});
        p[0].copyFrom(normX);
        p[1].copyFrom(normY);
        BitVector hilbert = (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution * 2));
        this.chc().index(p, 0, hilbert);
        return hilbert.toLong();
    }

    public Tuple2<Object, Object> toPoint(long i) {
        BitVector h = (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution * 2));
        h.copyFrom(i);
        BitVector[] p = (BitVector[])((Object[])new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution)), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution))});
        this.chc().indexInverse(h, p);
        double x = this.setNormalizedLongitude(p[0].toLong()) - (double)180;
        double y = this.setNormalizedLatitude(p[1].toLong()) - (double)90;
        return new Tuple2.mcDD.sp(x, y);
    }

    public Seq<IndexRange> toRanges(double xmin, double ymin, double xmax, double ymax, Option<RangeComputeHints> hints) {
        CompactHilbertCurve chc = new CompactHilbertCurve((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.resolution, this.resolution}), ClassTag$.MODULE$.Int()));
        ArrayList<LongRange> region = new ArrayList<LongRange>();
        long minNormalizedLongitude = this.getNormalizedLongitude(xmin);
        long minNormalizedLatitude = this.getNormalizedLatitude(ymin);
        long maxNormalizedLongitude = this.getNormalizedLongitude(xmax);
        long maxNormalizedLatitude = this.getNormalizedLatitude(ymax);
        region.add(LongRange.of((long)minNormalizedLongitude, (long)maxNormalizedLongitude));
        region.add(LongRange.of((long)minNormalizedLatitude, (long)maxNormalizedLatitude));
        LongContent zero = new LongContent(0L);
        Function LongRangeIDFunction = Functions.identity();
        SimpleRegionInspector inspector = SimpleRegionInspector.create((List)ImmutableList.of(region), (Content)new LongContent(1L), (Function)LongRangeIDFunction, (RangeHome)LongRangeHome.INSTANCE, (Content)zero);
        PlainFilterCombiner combiner = new PlainFilterCombiner((Object)LongRange.of((long)0L, (long)1L));
        BacktrackingQueryBuilder queryBuilder = BacktrackingQueryBuilder.create((RegionInspector)inspector, (FilterCombiner)combiner, (int)Integer.MAX_VALUE, (boolean)true, (RangeHome)LongRangeHome.INSTANCE, (Content)zero);
        chc.accept((ZoomingNavigator)new ZoomingSpaceVisitorAdapter((IndexCalculator)chc, (SpaceVisitor)queryBuilder));
        Query query = queryBuilder.get();
        List ranges = query.getFilteredIndexRanges();
        Nil$ result = Nil$.MODULE$;
        for (FilteredIndexRange l : ranges) {
            LongRange range = (LongRange)l.getIndexRange();
            long start = BoxesRunTime.unboxToLong((Object)range.getStart());
            long end = BoxesRunTime.unboxToLong((Object)range.getEnd());
            boolean contained = l.isPotentialOverSelectivity();
            IndexRange indexRange = IndexRange$.MODULE$.apply(start, end, contained);
            result = result.$colon$colon((Object)indexRange);
        }
        return result;
    }

    public Option<RangeComputeHints> toRanges$default$5() {
        return None$.MODULE$;
    }

    public HilbertCurve2D(int resolution) {
        this.resolution = resolution;
        SpaceFillingCurve2D.class.$init$((SpaceFillingCurve2D)this);
        this.precision = (long)package$.MODULE$.pow(2.0, (double)resolution);
        this.chc = new CompactHilbertCurve(new int[]{resolution, resolution});
    }
}

