/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.sfcurve.hilbert;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.uzaygezen.core.BacktrackingQueryBuilder;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.CompactHilbertCurve;
import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.FilterCombiner;
import com.google.uzaygezen.core.FilteredIndexRange;
import com.google.uzaygezen.core.IndexCalculator;
import com.google.uzaygezen.core.LongContent;
import com.google.uzaygezen.core.PlainFilterCombiner;
import com.google.uzaygezen.core.RegionInspector;
import com.google.uzaygezen.core.SimpleRegionInspector;
import com.google.uzaygezen.core.SpaceVisitor;
import com.google.uzaygezen.core.ZoomingNavigator;
import com.google.uzaygezen.core.ZoomingSpaceVisitorAdapter;
import com.google.uzaygezen.core.ranges.LongRange;
import com.google.uzaygezen.core.ranges.LongRangeHome;
import com.google.uzaygezen.core.ranges.RangeHome;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.sfcurve.IndexRange;
import org.locationtech.sfcurve.IndexRange$;
import org.locationtech.sfcurve.RangeComputeHints;
import org.locationtech.sfcurve.SpaceFillingCurve2D;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\b\u0011\u0001eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006Q\u0001!\t!\u000b\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0011\u0019\u0011\u0004\u0001)A\u0005_!91\u0007\u0001b\u0001\n\u0003!\u0004BB!\u0001A\u0003%Q\u0007C\u0003C\u0001\u0011\u00151\tC\u0003J\u0001\u0011\u0015!\nC\u0003N\u0001\u0011\u0015a\nC\u0003R\u0001\u0011\u0015!\u000bC\u0003V\u0001\u0011\u0005a\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0005\u0002\u0004\u0001\t\n\u0011\"\u0001\u0002\u0006\tq\u0001*\u001b7cKJ$8)\u001e:wKJ\"%BA\t\u0013\u0003\u001dA\u0017\u000e\u001c2feRT!a\u0005\u000b\u0002\u000fM47-\u001e:wK*\u0011QCF\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002/\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u0013\u0013\t\u0019#CA\nTa\u0006\u001cWMR5mY&twmQ;sm\u0016\u0014D)\u0001\u0006sKN|G.\u001e;j_:\u0004\"a\u0007\u0014\n\u0005\u001db\"aA%oi\u00061A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\t\t\u000b\u0011\u0012\u0001\u0019A\u0013\u0002\u0013A\u0014XmY5tS>tW#A\u0018\u0011\u0005m\u0001\u0014BA\u0019\u001d\u0005\u0011auN\\4\u0002\u0015A\u0014XmY5tS>t\u0007%A\u0002dQ\u000e,\u0012!\u000e\t\u0003m}j\u0011a\u000e\u0006\u0003qe\nAaY8sK*\u0011!hO\u0001\nkj\f\u0017pZ3{K:T!\u0001P\u001f\u0002\r\u001d|wn\u001a7f\u0015\u0005q\u0014aA2p[&\u0011\u0001i\u000e\u0002\u0014\u0007>l\u0007/Y2u\u0011&d'-\u001a:u\u0007V\u0014h/Z\u0001\u0005G\"\u001c\u0007%\u0001\fhKRtuN]7bY&TX\r\u001a'p]\u001eLG/\u001e3f)\tyC\tC\u0003F\u000f\u0001\u0007a)A\u0001y!\tYr)\u0003\u0002I9\t1Ai\\;cY\u0016\fQcZ3u\u001d>\u0014X.\u00197ju\u0016$G*\u0019;jiV$W\r\u0006\u00020\u0017\")A\n\u0003a\u0001\r\u0006\t\u00110A\u000btKRtuN]7bY&TX\r\u001a'bi&$X\u000fZ3\u0015\u0005\u0019{\u0005\"\u0002)\n\u0001\u0004y\u0013!\u00037bi:{'/\\1m\u0003Y\u0019X\r\u001e(pe6\fG.\u001b>fI2{gnZ5uk\u0012,GC\u0001$T\u0011\u0015!&\u00021\u00010\u0003%awN\u001c(pe6\fG.A\u0004u_&sG-\u001a=\u0015\u0007=:\u0006\fC\u0003F\u0017\u0001\u0007a\tC\u0003M\u0017\u0001\u0007a)A\u0004u_B{\u0017N\u001c;\u0015\u0005ms\u0006\u0003B\u000e]\r\u001aK!!\u0018\u000f\u0003\rQ+\b\u000f\\33\u0011\u0015yF\u00021\u00010\u0003\u0005I\u0017\u0001\u0003;p%\u0006tw-Z:\u0015\r\t\f8/^<z!\r\u00197N\u001c\b\u0003I&t!!\u001a5\u000e\u0003\u0019T!a\u001a\r\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012B\u00016\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0007M+\u0017O\u0003\u0002k9A\u0011\u0011e\\\u0005\u0003aJ\u0011!\"\u00138eKb\u0014\u0016M\\4f\u0011\u0015\u0011X\u00021\u0001G\u0003\u0011AX.\u001b8\t\u000bQl\u0001\u0019\u0001$\u0002\tel\u0017N\u001c\u0005\u0006m6\u0001\rAR\u0001\u0005q6\f\u0007\u0010C\u0003y\u001b\u0001\u0007a)\u0001\u0003z[\u0006D\bb\u0002>\u000e!\u0003\u0005\ra_\u0001\u0006Q&tGo\u001d\t\u00047qt\u0018BA?\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011e`\u0005\u0004\u0003\u0003\u0011\"!\u0005*b]\u001e,7i\\7qkR,\u0007*\u001b8ug\u0006\u0011Bo\u001c*b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t9AK\u0002|\u0003\u0013Y#!a\u0003\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+a\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011DA\b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class HilbertCurve2D
implements SpaceFillingCurve2D {
    private final int resolution;
    private final long precision;
    private final CompactHilbertCurve chc;

    public long precision() {
        return this.precision;
    }

    public CompactHilbertCurve chc() {
        return this.chc;
    }

    public final long getNormalizedLongitude(double x) {
        return (long)((x + (double)180) * (double)(this.precision() - 1L) / 360.0);
    }

    public final long getNormalizedLatitude(double y) {
        return (long)((y + (double)90) * (double)(this.precision() - 1L) / 180.0);
    }

    public final double setNormalizedLatitude(long latNormal) {
        if (latNormal < 0L || latNormal > this.precision()) {
            throw new NumberFormatException("Normalized latitude must be greater than 0 and less than the maximum precision");
        }
        return (double)latNormal * 180.0 / (double)(this.precision() - 1L);
    }

    public final double setNormalizedLongitude(long lonNormal) {
        if (lonNormal < 0L || lonNormal > this.precision()) {
            throw new NumberFormatException("Normalized longitude must be greater than 0 and less than the maximum precision");
        }
        return (double)lonNormal * 360.0 / (double)(this.precision() - 1L);
    }

    public long toIndex(double x, double y) {
        long normX = this.getNormalizedLongitude(x);
        long normY = this.getNormalizedLatitude(y);
        BitVector[] p = (BitVector[])((Object[])new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution)), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution))});
        p[0].copyFrom(normX);
        p[1].copyFrom(normY);
        BitVector hilbert = (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution * 2));
        this.chc().index(p, 0, hilbert);
        return hilbert.toLong();
    }

    public Tuple2<Object, Object> toPoint(long i) {
        BitVector h = (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution * 2));
        h.copyFrom(i);
        BitVector[] p = (BitVector[])((Object[])new BitVector[]{(BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution)), (BitVector)BitVectorFactories.OPTIMAL.apply((Object)Predef$.MODULE$.int2Integer(this.resolution))});
        this.chc().indexInverse(h, p);
        double x = this.setNormalizedLongitude(p[0].toLong()) - (double)180;
        double y = this.setNormalizedLatitude(p[1].toLong()) - (double)90;
        return new Tuple2.mcDD.sp(x, y);
    }

    public Seq<IndexRange> toRanges(double xmin, double ymin, double xmax, double ymax, Option<RangeComputeHints> hints) {
        CompactHilbertCurve chc = new CompactHilbertCurve((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.resolution, this.resolution}), ClassTag$.MODULE$.Int()));
        ArrayList<LongRange> region = new ArrayList<LongRange>();
        long minNormalizedLongitude = this.getNormalizedLongitude(xmin);
        long minNormalizedLatitude = this.getNormalizedLatitude(ymin);
        long maxNormalizedLongitude = this.getNormalizedLongitude(xmax);
        long maxNormalizedLatitude = this.getNormalizedLatitude(ymax);
        region.add(LongRange.of((long)minNormalizedLongitude, (long)maxNormalizedLongitude));
        region.add(LongRange.of((long)minNormalizedLatitude, (long)maxNormalizedLatitude));
        LongContent zero = new LongContent(0L);
        Function LongRangeIDFunction = Functions.identity();
        SimpleRegionInspector inspector = SimpleRegionInspector.create((List)ImmutableList.of(region), (Content)new LongContent(1L), (Function)LongRangeIDFunction, (RangeHome)LongRangeHome.INSTANCE, (Content)zero);
        PlainFilterCombiner combiner = new PlainFilterCombiner((Object)LongRange.of((long)0L, (long)1L));
        BacktrackingQueryBuilder queryBuilder = BacktrackingQueryBuilder.create((RegionInspector)inspector, (FilterCombiner)combiner, (int)Integer.MAX_VALUE, (boolean)true, (RangeHome)LongRangeHome.INSTANCE, (Content)zero);
        chc.accept((ZoomingNavigator)new ZoomingSpaceVisitorAdapter((IndexCalculator)chc, (SpaceVisitor)queryBuilder));
        List ranges = queryBuilder.get().getFilteredIndexRanges();
        Nil$ result = Nil$.MODULE$;
        for (FilteredIndexRange l : ranges) {
            LongRange range = (LongRange)l.getIndexRange();
            long start = BoxesRunTime.unboxToLong((Object)range.getStart());
            long end = BoxesRunTime.unboxToLong((Object)range.getEnd());
            boolean contained = l.isPotentialOverSelectivity();
            IndexRange indexRange = IndexRange$.MODULE$.apply(start, end, contained);
            result = result.$colon$colon((Object)indexRange);
        }
        return result;
    }

    public Option<RangeComputeHints> toRanges$default$5() {
        return None$.MODULE$;
    }

    public HilbertCurve2D(int resolution) {
        this.resolution = resolution;
        this.precision = (long)package$.MODULE$.pow(2.0, (double)resolution);
        this.chc = new CompactHilbertCurve(new int[]{resolution, resolution});
    }
}

