/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.config.api;

import org.lockss.config.AuConfiguration;
import org.lockss.ws.entities.RequestAuControlResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface AusApi {

    AusApiDelegate getDelegate();

    @Operation(summary = "Delete the configuration of an AU", description = "Delete the configuration of an AU given the AU identifier", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The deleted configuration of the specified AU", content = @Content(mediaType = "application/json", schema = @Schema(implementation = AuConfiguration.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aus/{auid}",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<AuConfiguration> deleteAuConfig(@Parameter(in = ParameterIn.PATH, description = "The identifier of the AU for which the configuration is\\ \\ to be deleted", required=true, schema=@Schema()) @PathVariable("auid") String auid
) {
        return getDelegate().deleteAuConfig(auid);
    }


    @Operation(summary = "Get the configurations of all AUs", description = "Get the configuration of all AUs", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The configuration of all AUs", content = @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = AuConfiguration.class)))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aus",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<AuConfiguration>> getAllAuConfig() {
        return getDelegate().getAllAuConfig();
    }


    @Operation(summary = "Get the configuration of an AU", description = "Get the configuration of an AU given the AU identifier", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The configuration of the specified AU", content = @Content(mediaType = "application/json", schema = @Schema(implementation = AuConfiguration.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aus/{auid}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<AuConfiguration> getAuConfig(@Parameter(in = ParameterIn.PATH, description = "The identifier of the AU for which the configuration is\\ \\ requested", required=true, schema=@Schema()) @PathVariable("auid") String auid
) {
        return getDelegate().getAuConfig(auid);
    }


    @Operation(summary = "Store the configuration of an AU", description = "Store the configuration of an AU given the AU identifier", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "OK"),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aus/{auid}",
        consumes = { "application/json" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<Void> putAuConfig(@Parameter(in = ParameterIn.PATH, description = "The identifier of the AU for this configuration.", required=true, schema=@Schema()) @PathVariable("auid") String auid
, @Parameter(in = ParameterIn.DEFAULT, description = "The Archival Unit configuration to be stored", required=true, schema=@Schema()) @Valid @RequestBody AuConfiguration body
) {
        return getDelegate().putAuConfig(auid, body);
    }


    @Operation(summary = "Disable AU metadata extraction", description = "Disable the metadata extraction for an AU given its identifier", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Information about the AU for which metadata extraction has been disabled", content = @Content(mediaType = "application/json", schema = @Schema(implementation = RequestAuControlResult.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aus/{auid}/mddisable",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<RequestAuControlResult> putAusMdDisable(@Parameter(in = ParameterIn.PATH, description = "The identifier of the Archival Units for which metadata extraction is to be disabled", required=true, schema=@Schema()) @PathVariable("auid") String auid
) {
        return getDelegate().putAusMdDisable(auid);
    }


    @Operation(summary = "Enable AU metadata extraction", description = "Enable the metadata extraction for an AU given its identifier", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Information about the AU for which metadata extraction has been enabled", content = @Content(mediaType = "application/json", schema = @Schema(implementation = RequestAuControlResult.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aus/{auid}/mdenable",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<RequestAuControlResult> putAusMdEnable(@Parameter(in = ParameterIn.PATH, description = "The identifier of the Archival Units for which metadata extraction is to be enabled", required=true, schema=@Schema()) @PathVariable("auid") String auid
) {
        return getDelegate().putAusMdEnable(auid);
    }

}

