/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.config.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface AususpecturlsApi {

    AususpecturlsApiDelegate getDelegate();

    @Operation(summary = "Get the suspect URL versions of an AU", description = "Get the suspect URL versions of an AU given the AU identifier", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The suspect URL versions of the specified AU", content = @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aususpecturls/{auid}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<String> getAuSuspectUrlVersions(@Parameter(in = ParameterIn.PATH, description = "The identifier of the AU for which the suspect URL versions are requested", required=true, schema=@Schema()) @PathVariable("auid") String auid
) {
        return getDelegate().getAuSuspectUrlVersions(auid);
    }


    @Operation(summary = "Update the suspect URL versions of an AU", description = "Update the suspect URL versions of an AU given the AU identifier", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "aus" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "OK"),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/aususpecturls/{auid}",
        consumes = { "application/json" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<Void> putAuSuspectUrlVersions(@Parameter(in = ParameterIn.PATH, description = "The identifier of the AU for which the suspect URL versions are to be updated", required=true, schema=@Schema()) @PathVariable("auid") String auid
, @Parameter(in = ParameterIn.DEFAULT, description = "The parts of the Archival Unit suspect URL versions to be updated", required=true, schema=@Schema()) @Valid @RequestBody String body
, @Parameter(in = ParameterIn.HEADER, description = "The LOCKSS-specific request cookie header" ,schema=@Schema()) @RequestHeader(value="X-Lockss-Request-Cookie", required=false) String xLockssRequestCookie
) {
        return getDelegate().putAuSuspectUrlVersions(auid, body, xLockssRequestCookie);
    }

}

