/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.config.api;

import java.time.OffsetDateTime;
import org.lockss.ws.entities.PlatformConfigurationWsResult;
import org.springframework.core.io.Resource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface ConfigApi {

    ConfigApiDelegate getDelegate();

    @Operation(summary = "Get the timestamp when the configuration was last updated", description = "Get the timestamp when the configuration was last updated", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "config" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The timestamp when the configuration was last updated", content = @Content(mediaType = "application/json", schema = @Schema(implementation = OffsetDateTime.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/config/lastupdatetime",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<OffsetDateTime> getLastUpdateTime() {
        return getDelegate().getLastUpdateTime();
    }


    @Operation(summary = "Get the URLs from which the configuration was loaded", description = "Get the URLs from which the configuration was actually loaded, reflecting any failover to local copies", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "config" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The URLs from which the configuration was loaded", content = @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = String.class)))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/config/loadedurls",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<String>> getLoadedUrlList() {
        return getDelegate().getLoadedUrlList();
    }


    @Operation(summary = "Get the platform configuration", description = "Get the platform configuration", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "config" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The platform configuration", content = @Content(mediaType = "application/json", schema = @Schema(implementation = PlatformConfigurationWsResult.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/config/platform",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<PlatformConfigurationWsResult> getPlatformConfig() {
        return getDelegate().getPlatformConfig();
    }


    @Operation(summary = "Get the named configuration file", description = "Get the configuration file stored for a given name", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "config" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The named configuration file", content = @Content(mediaType = "multipart/form-data", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/config/file/{sectionName}",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getSectionConfig(@Parameter(in = ParameterIn.PATH, description = "The name of the section for which the configuration file is requested", required=true, schema=@Schema()) @PathVariable("sectionName") String sectionName
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Match", required=false) String ifMatch
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Modified-Since", required=false) String ifModifiedSince
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-None-Match", required=false) String ifNoneMatch
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Unmodified-Since", required=false) String ifUnmodifiedSince
) {
        return getDelegate().getSectionConfig(sectionName, ifMatch, ifModifiedSince, ifNoneMatch, ifUnmodifiedSince);
    }


    @Operation(summary = "Get the configuration file for a URL", description = "Get the configuration file stored for a given URL", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "config" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The configuration file for the URL", content = @Content(mediaType = "multipart/form-data", schema = @Schema(implementation = Resource.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/config/url",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getUrlConfig(@NotNull @Parameter(in = ParameterIn.QUERY, description = "The URL for which the configuration is requested" ,required=true,schema=@Schema()) @Valid @RequestParam(value = "url", required = true) String url
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Match", required=false) String ifMatch
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Modified-Since", required=false) String ifModifiedSince
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-None-Match", required=false) String ifNoneMatch
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Unmodified-Since", required=false) String ifUnmodifiedSince
) {
        return getDelegate().getUrlConfig(url, ifMatch, ifModifiedSince, ifNoneMatch, ifUnmodifiedSince);
    }


    @Operation(summary = "Store the named configuration file", description = "Store the configuration file for a given name", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "config" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "OK"),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/config/file/{sectionName}",
        consumes = { "multipart/form-data" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<Void> putConfig(@Parameter(in = ParameterIn.PATH, description = "The name of the section for which the configuration file is to be stored", required=true, schema=@Schema()) @PathVariable("sectionName") String sectionName
, @Parameter(description = "") @Valid @RequestPart(value="configFile", required=true) MultipartFile configFile
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Match", required=false) String ifMatch
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Modified-Since", required=false) String ifModifiedSince
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-None-Match", required=false) String ifNoneMatch
, @Parameter(in = ParameterIn.HEADER, description = "The If-Match header" ,schema=@Schema()) @RequestHeader(value="If-Unmodified-Since", required=false) String ifUnmodifiedSince
) {
        return getDelegate().putConfig(sectionName, configFile, ifMatch, ifModifiedSince, ifNoneMatch, ifUnmodifiedSince);
    }


    @Operation(summary = "Request a configuration reload", description = "Request that the stored configuration is reloaded", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "config" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "OK"),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.") })
    @RequestMapping(value = "/config/reload",
        method = RequestMethod.PUT)
    default ResponseEntity<Void> putConfigReload() {
        return getDelegate().putConfigReload();
    }

}

