/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.config.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface UsersApi {

    UsersApiDelegate getDelegate();

    @Operation(summary = "Adds user accounts to the system", description = "Adds user accounts to the system", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "users" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Successfully added user accounts", content = @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))),
        
        @ApiResponse(responseCode = "401", description = "Unauthorized"),
        
        @ApiResponse(responseCode = "500", description = "Internal Server Error") })
    @RequestMapping(value = "/users",
        produces = { "application/json" }, 
        consumes = { "application/json" }, 
        method = RequestMethod.POST)
    default ResponseEntity<String> addUserAccounts(@Parameter(in = ParameterIn.DEFAULT, description = "An array of user accounts to be stored", required=true, schema=@Schema()) @Valid @RequestBody String body
) {
        return getDelegate().addUserAccounts(body);
    }


    @Operation(summary = "Get user account details", description = "Get user account details", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "users" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "A JSON serialization containing details of the user account", content = @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))),
        
        @ApiResponse(responseCode = "400", description = "Bad Request"),
        
        @ApiResponse(responseCode = "401", description = "Unauthorized"),
        
        @ApiResponse(responseCode = "404", description = "Not Found"),
        
        @ApiResponse(responseCode = "500", description = "Internal Server Error") })
    @RequestMapping(value = "/users/{username}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<String> getUserAccount(@Parameter(in = ParameterIn.PATH, description = "Username", required=true, schema=@Schema()) @PathVariable("username") String username
) {
        return getDelegate().getUserAccount(username);
    }


    @Operation(summary = "Remove a user account from the system", description = "Remove a user account from the system", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "users" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Removed user account"),
        
        @ApiResponse(responseCode = "401", description = "Unauthorized"),
        
        @ApiResponse(responseCode = "404", description = "Not Found"),
        
        @ApiResponse(responseCode = "500", description = "Internal Server Error") })
    @RequestMapping(value = "/users/{username}",
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> removeUserAccount(@Parameter(in = ParameterIn.PATH, description = "Username", required=true, schema=@Schema()) @PathVariable("username") String username
) {
        return getDelegate().removeUserAccount(username);
    }


    @Operation(summary = "Update properties of an existing user account", description = "Update properties of an existing user account", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "users" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Updated user account", content = @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))),
        
        @ApiResponse(responseCode = "400", description = "Bad Request"),
        
        @ApiResponse(responseCode = "401", description = "Unauthorized"),
        
        @ApiResponse(responseCode = "404", description = "Not Found"),
        
        @ApiResponse(responseCode = "500", description = "Internal Server Error") })
    @RequestMapping(value = "/users/{username}",
        produces = { "application/json" }, 
        consumes = { "application/json" }, 
        method = RequestMethod.PATCH)
    default ResponseEntity<String> updateUserAccount(@Parameter(in = ParameterIn.PATH, description = "Username", required=true, schema=@Schema()) @PathVariable("username") String username
, @Parameter(in = ParameterIn.DEFAULT, description = "The user account details to be updated", required=true, schema=@Schema()) @Valid @RequestBody String body
, @Parameter(in = ParameterIn.HEADER, description = "The LOCKSS-specific request cookie header" ,schema=@Schema()) @RequestHeader(value="X-Lockss-Request-Cookie", required=false) String xLockssRequestCookie
) {
        return getDelegate().updateUserAccount(username, body, xLockssRequestCookie);
    }

}

