package org.lockss.laaws.config.api;

import org.lockss.ws.entities.AuWsResult;
import org.lockss.ws.entities.ContentConfigurationResult;
import org.lockss.ws.entities.PluginWsResult;
import org.lockss.ws.entities.TdbAuWsResult;
import org.lockss.ws.entities.TdbPublisherWsResult;
import org.lockss.ws.entities.TdbTitleWsResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link WsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */

public interface WsApiDelegate {

    Logger log = LoggerFactory.getLogger(WsApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    /**
     * @see WsApi#deleteAusDelete
     */
    default ResponseEntity<List<ContentConfigurationResult>> deleteAusDelete( List<String>  body) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#getAuqueries
     */
    default ResponseEntity<List<AuWsResult>> getAuqueries( String  auQuery) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\"\n}, {\n  \"auId\" : \"auId\"\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#getPlugins
     */
    default ResponseEntity<List<PluginWsResult>> getPlugins( String  pluginQuery) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"registry\" : \"registry\",\n  \"pluginId\" : \"pluginId\",\n  \"name\" : \"name\",\n  \"definition\" : {\n    \"key\" : \"definition\"\n  },\n  \"type\" : \"type\",\n  \"auCount\" : 0,\n  \"version\" : \"version\",\n  \"url\" : \"url\",\n  \"publishingPlatform\" : \"publishingPlatform\"\n}, {\n  \"registry\" : \"registry\",\n  \"pluginId\" : \"pluginId\",\n  \"name\" : \"name\",\n  \"definition\" : {\n    \"key\" : \"definition\"\n  },\n  \"type\" : \"type\",\n  \"auCount\" : 0,\n  \"version\" : \"version\",\n  \"url\" : \"url\",\n  \"publishingPlatform\" : \"publishingPlatform\"\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#getTdbAus
     */
    default ResponseEntity<List<TdbAuWsResult>> getTdbAus( String  tdbAuQuery) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"pluginName\" : \"pluginName\",\n  \"tdbTitle\" : {\n    \"tdbPublisher\" : {\n      \"name\" : \"name\"\n    },\n    \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n    \"issns\" : [ \"issns\", \"issns\" ],\n    \"issn\" : \"issn\",\n    \"name\" : \"name\",\n    \"proprietaryid\" : \"proprietaryid\",\n    \"issnl\" : \"issnl\",\n    \"eissn\" : \"eissn\",\n    \"id\" : \"id\",\n    \"publicationtype\" : \"publicationtype\",\n    \"printissn\" : \"printissn\"\n  },\n  \"name\" : \"name\",\n  \"active\" : true,\n  \"params\" : {\n    \"key\" : \"params\"\n  },\n  \"down\" : true,\n  \"attrs\" : {\n    \"key\" : \"attrs\"\n  },\n  \"props\" : {\n    \"key\" : \"props\"\n  }\n}, {\n  \"auId\" : \"auId\",\n  \"pluginName\" : \"pluginName\",\n  \"tdbTitle\" : {\n    \"tdbPublisher\" : {\n      \"name\" : \"name\"\n    },\n    \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n    \"issns\" : [ \"issns\", \"issns\" ],\n    \"issn\" : \"issn\",\n    \"name\" : \"name\",\n    \"proprietaryid\" : \"proprietaryid\",\n    \"issnl\" : \"issnl\",\n    \"eissn\" : \"eissn\",\n    \"id\" : \"id\",\n    \"publicationtype\" : \"publicationtype\",\n    \"printissn\" : \"printissn\"\n  },\n  \"name\" : \"name\",\n  \"active\" : true,\n  \"params\" : {\n    \"key\" : \"params\"\n  },\n  \"down\" : true,\n  \"attrs\" : {\n    \"key\" : \"attrs\"\n  },\n  \"props\" : {\n    \"key\" : \"props\"\n  }\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#getTdbPublishers
     */
    default ResponseEntity<List<TdbPublisherWsResult>> getTdbPublishers( String  tdbPublisherQuery) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"name\" : \"name\"\n}, {\n  \"name\" : \"name\"\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#getTdbTitles
     */
    default ResponseEntity<List<TdbTitleWsResult>> getTdbTitles( String  tdbTitleQuery) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"tdbPublisher\" : {\n    \"name\" : \"name\"\n  },\n  \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n  \"issns\" : [ \"issns\", \"issns\" ],\n  \"issn\" : \"issn\",\n  \"name\" : \"name\",\n  \"proprietaryid\" : \"proprietaryid\",\n  \"issnl\" : \"issnl\",\n  \"eissn\" : \"eissn\",\n  \"id\" : \"id\",\n  \"publicationtype\" : \"publicationtype\",\n  \"printissn\" : \"printissn\"\n}, {\n  \"tdbPublisher\" : {\n    \"name\" : \"name\"\n  },\n  \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n  \"issns\" : [ \"issns\", \"issns\" ],\n  \"issn\" : \"issn\",\n  \"name\" : \"name\",\n  \"proprietaryid\" : \"proprietaryid\",\n  \"issnl\" : \"issnl\",\n  \"eissn\" : \"eissn\",\n  \"id\" : \"id\",\n  \"publicationtype\" : \"publicationtype\",\n  \"printissn\" : \"printissn\"\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#postAus
     */
    default ResponseEntity<List<ContentConfigurationResult>> postAus( List<String>  body) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#putAusDeactivate
     */
    default ResponseEntity<List<ContentConfigurationResult>> putAusDeactivate( List<String>  body) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see WsApi#putAusReactivate
     */
    default ResponseEntity<List<ContentConfigurationResult>> putAusReactivate( List<String>  body) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
