/*

 Copyright (c) 2017-2020 Board of Trustees of Leland Stanford Jr. University,
 all rights reserved.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 STANFORD UNIVERSITY BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 Except as contained in this notice, the name of Stanford University shall not
 be used in advertising or otherwise to promote the sale, use or other dealings
 in this Software without prior written authorization from Stanford University.

 */
package org.lockss.laaws.config.client;

import java.nio.charset.Charset;
import java.util.Base64;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import org.lockss.util.rest.RestUtil;
import org.springframework.http.HttpHeaders;

/**
 * A base client for all of the LAAWS-Config web service operations.
 */
public class BaseClient {
  private static final String userName = "lockss-u";
  private static final String password = "lockss-p";

  protected static final String baseUri = "http://localhost:24620";

  /**
   * Provides a RestTemplate that does not throw exceptions when the received
   * status code is not 2xx.
   * 
   * @return a RestTemplate that does not throw exceptions when the received
   *         status code is not 2xx.
   */
  protected static RestTemplate getRestTemplate() {
    RestTemplate template = RestUtil.getRestTemplate();

    return template;
  }

  /**
   * Provides the basic HTTP headers to be used in a request.
   * 
   * @return a HttpHeaders with the Basic Authorization and Content Type
   *         headers.
   */
  protected static HttpHeaders getHttpHeaders() {
    HttpHeaders headers = new HttpHeaders();
    headers.setContentType(MediaType.APPLICATION_JSON);

    String credentials = userName + ":" + password;
    String authHeaderValue = "Basic " + Base64.getEncoder().encodeToString(
	credentials.getBytes(Charset.forName("US-ASCII")));
    headers.set("Authorization", authHeaderValue);

    return headers;
  }
}
