package org.lockss.laaws.config.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * AuidsBody
 */
@Validated



public class AuidsBody   {
  @JsonProperty("pluginId")
  private String pluginId = null;

  @JsonProperty("handle")
  private String handle = null;

  @JsonProperty("auConfig")
  private Object auConfig = null;

  public AuidsBody pluginId(String pluginId) {
    this.pluginId = pluginId;
    return this;
  }

  /**
   * the plugin id
   * @return pluginId
   **/
  @Schema(description = "the plugin id")
  
    public String getPluginId() {
    return pluginId;
  }

  public void setPluginId(String pluginId) {
    this.pluginId = pluginId;
  }

  public AuidsBody handle(String handle) {
    this.handle = handle;
    return this;
  }

  /**
   * the handle of a NamedArchivalUnit
   * @return handle
   **/
  @Schema(description = "the handle of a NamedArchivalUnit")
  
    public String getHandle() {
    return handle;
  }

  public void setHandle(String handle) {
    this.handle = handle;
  }

  public AuidsBody auConfig(Object auConfig) {
    this.auConfig = auConfig;
    return this;
  }

  /**
   * The configuration information for this au (as a json map).
   * @return auConfig
   **/
  @Schema(description = "The configuration information for this au (as a json map).")
  
    public Object getAuConfig() {
    return auConfig;
  }

  public void setAuConfig(Object auConfig) {
    this.auConfig = auConfig;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuidsBody auidsBody = (AuidsBody) o;
    return Objects.equals(this.pluginId, auidsBody.pluginId) &&
        Objects.equals(this.handle, auidsBody.handle) &&
        Objects.equals(this.auConfig, auidsBody.auConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pluginId, handle, auConfig);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuidsBody {\n");
    
    sb.append("    pluginId: ").append(toIndentedString(pluginId)).append("\n");
    sb.append("    handle: ").append(toIndentedString(handle)).append("\n");
    sb.append("    auConfig: ").append(toIndentedString(auConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
