package org.lockss.laaws.config.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * FileSectionNameBody
 */
@Validated



public class FileSectionNameBody   {
  @JsonProperty("configFile")
  private Resource configFile = null;

  public FileSectionNameBody configFile(Resource configFile) {
    this.configFile = configFile;
    return this;
  }

  /**
   * The configuration file to be stored
   * @return configFile
   **/
  @Schema(required = true, description = "The configuration file to be stored")
      @NotNull

    @Valid
    public Resource getConfigFile() {
    return configFile;
  }

  public void setConfigFile(Resource configFile) {
    this.configFile = configFile;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileSectionNameBody fileSectionNameBody = (FileSectionNameBody) o;
    return Objects.equals(this.configFile, fileSectionNameBody.configFile);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configFile);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileSectionNameBody {\n");
    
    sb.append("    configFile: ").append(toIndentedString(configFile)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
