/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config;

import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.app.ManagerDescs;
import org.lockss.app.ServiceDescr;
import org.lockss.spring.base.BaseSpringBootApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class ConfigApplication
extends BaseSpringBootApplication
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(ConfigApplication.class);
    private static final LockssApp.ManagerDesc[] myManagerDescs = new LockssApp.ManagerDesc[]{ManagerDescs.ACCOUNT_MANAGER_DESC, ManagerDescs.CONFIG_DB_MANAGER_DESC, ManagerDescs.PLUGIN_MANAGER_DESC, ManagerDescs.STATE_MANAGER_DESC, ManagerDescs.IDENTITY_MANAGER_DESC, ManagerDescs.CRAWL_MANAGER_DESC, ManagerDescs.REPOSITORY_MANAGER_DESC, ManagerDescs.METADATA_DB_MANAGER_DESC, ManagerDescs.METADATA_MANAGER_DESC, ManagerDescs.REMOTE_API_DESC, ManagerDescs.COUNTER_REPORTS_MANAGER_DESC, ManagerDescs.SUBSCRIPTION_MANAGER_DESC, ManagerDescs.SERVLET_MANAGER_DESC, ManagerDescs.ROUTER_MANAGER_DESC, ManagerDescs.PLATFORM_CONFIG_STATUS_DESC, ManagerDescs.CONFIG_STATUS_DESC, ManagerDescs.ARCHIVAL_UNIT_STATUS_DESC, ManagerDescs.OVERVIEW_STATUS_DESC};

    public static void main(String[] args) {
        logger.info("Starting the application");
        ConfigApplication.configure();
        SpringApplication.run(ConfigApplication.class, (String[])args);
    }

    public void run(String ... args) {
        if (args != null && args.length > 0) {
            logger.info("Starting the LOCKSS Configuration Service");
            LockssApp.AppSpec spec = new LockssApp.AppSpec().setService(ServiceDescr.SVC_CONFIG).setArgs(args).addAppConfig("org.lockss.jms.broker.start", "true").addAppConfig("org.lockss.config.jms.enableSend", "true").addAppConfig("org.lockss.startPlugins", "true").addAppDefault("org.lockss.plugin.startAllAus", "true").setSpringApplicatonContext(this.getApplicationContext()).setAppManagers(myManagerDescs);
            LockssApp.startStatic(LockssDaemon.class, (LockssApp.AppSpec)spec);
        }
    }
}

