/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.lockss.laaws.config.api.AuidsApiDelegate;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface AuidsApi {
    public AuidsApiDelegate getDelegate();

    @Operation(summary="Calculate an AUID for a hypothetical AU", description="Calculate an AUID for a hypothetical AU, given either a plugin ID and an auConfig map (for traditional AUs), or a handle and an optional plugin ID for NamedAUs", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Map containing the resulting AUID", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/auids"}, produces={"application/json", "text/plain"}, consumes={"application/x-www-form-urlencoded"}, method={RequestMethod.POST})
    default public ResponseEntity<String> calculateAuid(@Parameter(in=ParameterIn.DEFAULT, description="", schema=@Schema) @RequestParam(value="pluginId", required=false) String pluginId, @Parameter(in=ParameterIn.DEFAULT, description="", schema=@Schema) @RequestParam(value="handle", required=false) String handle, @Parameter(in=ParameterIn.DEFAULT, description="", schema=@Schema) @RequestParam(value="auConfig", required=false) Object auConfig) {
        return this.getDelegate().calculateAuid(pluginId, handle, auConfig);
    }
}

