/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.lockss.config.AuConfiguration;
import org.lockss.laaws.config.api.AusApi;
import org.lockss.ws.entities.RequestAuControlResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public interface AusApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(AusApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<AuConfiguration> deleteAuConfig(String auid) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((AuConfiguration)this.getObjectMapper().get().readValue("{\n  \"auId\" : \"auId\",\n  \"auConfig\" : {\n    \"key\" : \"auConfig\"\n  }\n}", AuConfiguration.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<AuConfiguration>> getAllAuConfig() {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"auConfig\" : {\n    \"key\" : \"auConfig\"\n  }\n}, {\n  \"auId\" : \"auId\",\n  \"auConfig\" : {\n    \"key\" : \"auConfig\"\n  }\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<AuConfiguration> getAuConfig(String auid) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((AuConfiguration)this.getObjectMapper().get().readValue("{\n  \"auId\" : \"auId\",\n  \"auConfig\" : {\n    \"key\" : \"auConfig\"\n  }\n}", AuConfiguration.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Void> putAuConfig(String auid, AuConfiguration body) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<RequestAuControlResult> putAusMdDisable(String auid) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((RequestAuControlResult)this.getObjectMapper().get().readValue("{\n  \"success\" : true,\n  \"errorMessage\" : \"errorMessage\",\n  \"id\" : \"id\"\n}", RequestAuControlResult.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<RequestAuControlResult> putAusMdEnable(String auid) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((RequestAuControlResult)this.getObjectMapper().get().readValue("{\n  \"success\" : true,\n  \"errorMessage\" : \"errorMessage\",\n  \"id\" : \"id\"\n}", RequestAuControlResult.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AusApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

