/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import org.lockss.laaws.config.api.AustatesApiDelegate;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
public interface AustatesApi {
    public AustatesApiDelegate getDelegate();

    @Operation(summary="Get the state of an AU", description="Get the state of an AU given the AU identifier", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The state of the specified AU", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/austates/{auid}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<String> getAuState(@Parameter(in=ParameterIn.PATH, description="The identifier of the AU for which the state is requested", required=true, schema=@Schema) @PathVariable(value="auid") String auid) {
        return this.getDelegate().getAuState(auid);
    }

    @Operation(summary="Update the state of an AU", description="Update the state of an AU given the AU identifier", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/austates/{auid}"}, consumes={"application/json"}, method={RequestMethod.PATCH})
    default public ResponseEntity<Void> patchAuState(@Parameter(in=ParameterIn.PATH, description="The identifier of the AU for which the state is to be updated", required=true, schema=@Schema) @PathVariable(value="auid") String auid, @Parameter(in=ParameterIn.DEFAULT, description="The parts of the Archival Unit state to be updated", required=true, schema=@Schema) @Valid @RequestBody String body, @Parameter(in=ParameterIn.HEADER, description="The LOCKSS-specific request cookie header", schema=@Schema) @RequestHeader(value="X-Lockss-Request-Cookie", required=false) String xLockssRequestCookie) {
        return this.getDelegate().patchAuState(auid, body, xLockssRequestCookie);
    }
}

