/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.lockss.laaws.config.api.AusubstancesApiDelegate;
import org.lockss.ws.entities.CheckSubstanceResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
public interface AusubstancesApi {
    public AusubstancesApiDelegate getDelegate();

    @Operation(summary="Update the substance of an AU", description="Update the substance of an AU given the AU identifier", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The substance check of the specified AU", content={@Content(mediaType="application/json", schema=@Schema(implementation=CheckSubstanceResult.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ausubstances/{auid}"}, produces={"application/json"}, method={RequestMethod.PUT})
    default public ResponseEntity<CheckSubstanceResult> putAuSubstanceCheck(@Parameter(in=ParameterIn.PATH, description="The identifier of the AU for which the substance check is requested", required=true, schema=@Schema) @PathVariable(value="auid") String auid) {
        return this.getDelegate().putAuSubstanceCheck(auid);
    }
}

