/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.lockss.laaws.config.api.WsApiDelegate;
import org.lockss.ws.entities.AuWsResult;
import org.lockss.ws.entities.ContentConfigurationResult;
import org.lockss.ws.entities.PluginWsResult;
import org.lockss.ws.entities.TdbAuWsResult;
import org.lockss.ws.entities.TdbPublisherWsResult;
import org.lockss.ws.entities.TdbTitleWsResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface WsApi {
    public WsApiDelegate getDelegate();

    @Operation(summary="Delete AUs", description="Delete a group of AUs given their identifiers", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the deleted AUs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ContentConfigurationResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/aus/delete"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<List<ContentConfigurationResult>> deleteAusDelete(@Parameter(in=ParameterIn.DEFAULT, description="The identifiers of the Archival Units to be deleted", required=true, schema=@Schema) @Valid @RequestBody List<String> body) {
        return this.getDelegate().deleteAusDelete(body);
    }

    @Operation(summary="Query for archival unit properties", description="Query for archival units that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested archival units", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AuWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/auqueries"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<AuWsResult>> getAuqueries(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the archival units to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="auQuery", required=true) String auQuery) {
        return this.getDelegate().getAuqueries(auQuery);
    }

    @Operation(summary="Query for plugin properties", description="Query for plugins that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"plugins"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested plugins", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PluginWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/plugins"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<PluginWsResult>> getPlugins(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the plugins to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="pluginQuery", required=true) String pluginQuery) {
        return this.getDelegate().getPlugins(pluginQuery);
    }

    @Operation(summary="Query the TDB for AUs", description="Query the TDB for AUs that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"tdb"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested TDB AUs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TdbAuWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/tdbaus"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<TdbAuWsResult>> getTdbAus(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the TDB AUs to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="tdbAuQuery", required=true) String tdbAuQuery) {
        return this.getDelegate().getTdbAus(tdbAuQuery);
    }

    @Operation(summary="Query the TDB for Publishers", description="Query the TDB for Publishers that meet a set of specifie conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"tdb"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested TDB Publishers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TdbPublisherWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/tdbpublishers"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<TdbPublisherWsResult>> getTdbPublishers(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the TDB Publishers to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="tdbPublisherQuery", required=true) String tdbPublisherQuery) {
        return this.getDelegate().getTdbPublishers(tdbPublisherQuery);
    }

    @Operation(summary="Query the TDB for Titles", description="Query the TDB for Titles that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"tdb"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested TDB Titles", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TdbTitleWsResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/tdbtitles"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<TdbTitleWsResult>> getTdbTitles(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the TDB Titles to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="tdbTitleQuery", required=true) String tdbTitleQuery) {
        return this.getDelegate().getTdbTitles(tdbTitleQuery);
    }

    @Operation(summary="Add AUs", description="Add a group of AUs given their identifiers", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the added AUs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ContentConfigurationResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/aus/add"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<List<ContentConfigurationResult>> postAus(@Parameter(in=ParameterIn.DEFAULT, description="The identifiers of the Archival Units to be added", required=true, schema=@Schema) @Valid @RequestBody List<String> body) {
        return this.getDelegate().postAus(body);
    }

    @Operation(summary="Deactivate AUs", description="Deactivate a group of AUs given their identifiers", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the deactivated AUs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ContentConfigurationResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/aus/deactivate"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    default public ResponseEntity<List<ContentConfigurationResult>> putAusDeactivate(@Parameter(in=ParameterIn.DEFAULT, description="The identifiers of the Archival Units to be deactivated", required=true, schema=@Schema) @Valid @RequestBody List<String> body) {
        return this.getDelegate().putAusDeactivate(body);
    }

    @Operation(summary="Reactivate AUs", description="Reactivate a group of AUs given their identifiers", security={@SecurityRequirement(name="basicAuth")}, tags={"aus"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the reactivated AUs", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ContentConfigurationResult.class)))}), @ApiResponse(responseCode="200", description="The resulting error payload.")})
    @RequestMapping(value={"/ws/aus/reactivate"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    default public ResponseEntity<List<ContentConfigurationResult>> putAusReactivate(@Parameter(in=ParameterIn.DEFAULT, description="The identifiers of the Archival Units to be reactivated", required=true, schema=@Schema) @Valid @RequestBody List<String> body) {
        return this.getDelegate().putAusReactivate(body);
    }
}

