/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.lockss.laaws.config.api.WsApi;
import org.lockss.ws.entities.AuWsResult;
import org.lockss.ws.entities.ContentConfigurationResult;
import org.lockss.ws.entities.PluginWsResult;
import org.lockss.ws.entities.TdbAuWsResult;
import org.lockss.ws.entities.TdbPublisherWsResult;
import org.lockss.ws.entities.TdbTitleWsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public interface WsApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(WsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<List<ContentConfigurationResult>> deleteAusDelete(List<String> body) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<AuWsResult>> getAuqueries(String auQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\"\n}, {\n  \"auId\" : \"auId\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<PluginWsResult>> getPlugins(String pluginQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"registry\" : \"registry\",\n  \"pluginId\" : \"pluginId\",\n  \"name\" : \"name\",\n  \"definition\" : {\n    \"key\" : \"definition\"\n  },\n  \"type\" : \"type\",\n  \"auCount\" : 0,\n  \"version\" : \"version\",\n  \"url\" : \"url\",\n  \"publishingPlatform\" : \"publishingPlatform\"\n}, {\n  \"registry\" : \"registry\",\n  \"pluginId\" : \"pluginId\",\n  \"name\" : \"name\",\n  \"definition\" : {\n    \"key\" : \"definition\"\n  },\n  \"type\" : \"type\",\n  \"auCount\" : 0,\n  \"version\" : \"version\",\n  \"url\" : \"url\",\n  \"publishingPlatform\" : \"publishingPlatform\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<TdbAuWsResult>> getTdbAus(String tdbAuQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"pluginName\" : \"pluginName\",\n  \"tdbTitle\" : {\n    \"tdbPublisher\" : {\n      \"name\" : \"name\"\n    },\n    \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n    \"issns\" : [ \"issns\", \"issns\" ],\n    \"issn\" : \"issn\",\n    \"name\" : \"name\",\n    \"proprietaryid\" : \"proprietaryid\",\n    \"issnl\" : \"issnl\",\n    \"eissn\" : \"eissn\",\n    \"id\" : \"id\",\n    \"publicationtype\" : \"publicationtype\",\n    \"printissn\" : \"printissn\"\n  },\n  \"name\" : \"name\",\n  \"active\" : true,\n  \"params\" : {\n    \"key\" : \"params\"\n  },\n  \"down\" : true,\n  \"attrs\" : {\n    \"key\" : \"attrs\"\n  },\n  \"props\" : {\n    \"key\" : \"props\"\n  }\n}, {\n  \"auId\" : \"auId\",\n  \"pluginName\" : \"pluginName\",\n  \"tdbTitle\" : {\n    \"tdbPublisher\" : {\n      \"name\" : \"name\"\n    },\n    \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n    \"issns\" : [ \"issns\", \"issns\" ],\n    \"issn\" : \"issn\",\n    \"name\" : \"name\",\n    \"proprietaryid\" : \"proprietaryid\",\n    \"issnl\" : \"issnl\",\n    \"eissn\" : \"eissn\",\n    \"id\" : \"id\",\n    \"publicationtype\" : \"publicationtype\",\n    \"printissn\" : \"printissn\"\n  },\n  \"name\" : \"name\",\n  \"active\" : true,\n  \"params\" : {\n    \"key\" : \"params\"\n  },\n  \"down\" : true,\n  \"attrs\" : {\n    \"key\" : \"attrs\"\n  },\n  \"props\" : {\n    \"key\" : \"props\"\n  }\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<TdbPublisherWsResult>> getTdbPublishers(String tdbPublisherQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"name\" : \"name\"\n}, {\n  \"name\" : \"name\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<TdbTitleWsResult>> getTdbTitles(String tdbTitleQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"tdbPublisher\" : {\n    \"name\" : \"name\"\n  },\n  \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n  \"issns\" : [ \"issns\", \"issns\" ],\n  \"issn\" : \"issn\",\n  \"name\" : \"name\",\n  \"proprietaryid\" : \"proprietaryid\",\n  \"issnl\" : \"issnl\",\n  \"eissn\" : \"eissn\",\n  \"id\" : \"id\",\n  \"publicationtype\" : \"publicationtype\",\n  \"printissn\" : \"printissn\"\n}, {\n  \"tdbPublisher\" : {\n    \"name\" : \"name\"\n  },\n  \"proprietaryids\" : [ \"proprietaryids\", \"proprietaryids\" ],\n  \"issns\" : [ \"issns\", \"issns\" ],\n  \"issn\" : \"issn\",\n  \"name\" : \"name\",\n  \"proprietaryid\" : \"proprietaryid\",\n  \"issnl\" : \"issnl\",\n  \"eissn\" : \"eissn\",\n  \"id\" : \"id\",\n  \"publicationtype\" : \"publicationtype\",\n  \"printissn\" : \"printissn\"\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<ContentConfigurationResult>> postAus(List<String> body) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<ContentConfigurationResult>> putAusDeactivate(List<String> body) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<List<ContentConfigurationResult>> putAusReactivate(List<String> body) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((List)this.getObjectMapper().get().readValue("[ {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n}, {\n  \"auId\" : \"auId\",\n  \"name\" : \"name\",\n  \"message\" : \"message\",\n  \"isSuccess\" : true\n} ]", List.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

