/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.lockss.laaws.config.client.BaseClient;
import org.lockss.laaws.config.model.ConfigModSpec;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PutConfigSnidClient
extends BaseClient {
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("args[" + i + "] = " + args[i]);
        }
        if (args.length < 1) {
            System.err.println("ERROR: Missing command line arguments with the name of the section to have its configuration modified and its configuration modification specification.");
        }
        if (args.length < 2) {
            System.err.println("ERROR: Missing command line arguments with the configuration modification specification.");
        }
        String header = args[1];
        System.out.println("header = " + header);
        for (int i = 2; i < args.length; ++i) {
            System.out.println("arg[" + i + "] = " + args[i]);
        }
        HashMap<String, String> updates = new HashMap<String, String>();
        ArrayList<String> deletes = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            int sepLoc = args[i].trim().indexOf("=");
            if (sepLoc > 0 && sepLoc < args[i].length() - 1) {
                updates.put(args[i].substring(0, sepLoc), args[i].substring(sepLoc + 1));
                continue;
            }
            deletes.add(args[i]);
        }
        System.out.println("updates = " + updates);
        System.out.println("deletes = " + deletes);
        if (updates.size() > 0 || deletes.size() > 0) {
            ConfigModSpec modSpec = new ConfigModSpec();
            modSpec.setHeader(header);
            modSpec.setUpdates(updates);
            modSpec.setDeletes(deletes);
            String template = "http://localhost:24620/config/{snid}";
            UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)template).build().expand(Collections.singletonMap("snid", args[0].toLowerCase()));
            URI uri = UriComponentsBuilder.newInstance().uriComponents(uriComponents).build().encode().toUri();
            System.out.println("uri = " + uri);
            ResponseEntity response = PutConfigSnidClient.getRestTemplate().exchange(uri, HttpMethod.PUT, new HttpEntity((Object)modSpec, (MultiValueMap)PutConfigSnidClient.getHttpHeaders()), Void.class);
            int status = response.getStatusCodeValue();
            System.out.println("status = " + status);
        } else {
            System.err.println("ERROR: Missing command line argument(s) with configuration parameter(s) to be updated or deleted.");
        }
    }
}

