/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.config.AuConfiguration;
import org.lockss.config.ConfigManager;
import org.lockss.daemon.CrawlWindow;
import org.lockss.daemon.TitleConfig;
import org.lockss.laaws.config.impl.AuWsSource;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.CachedUrlSet;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.state.AuState;
import org.lockss.state.StateManager;
import org.lockss.util.Logger;
import org.lockss.util.StringUtil;
import org.lockss.ws.entities.AuStatus;
import org.lockss.ws.entities.AuWsResult;

public class AuHelper {
    static String SOURCE_FQCN = AuWsSource.class.getCanonicalName();
    static String RESULT_FQCN = AuWsResult.class.getCanonicalName();
    static String AU_ID = "auId";
    static String NAME = "name";
    static String VOLUME = "volume";
    static String PLUGIN_NAME = "pluginName";
    static String TDB_YEAR = "tdbYear";
    static String ACCESS_TYPE = "accessType";
    static String CONTENT_SIZE = "contentSize";
    static String DISK_USAGE = "diskUsage";
    static String REPOSITORY_PATH = "repositoryPath";
    static String RECENT_POLL_AGREEMENT = "recentPollAgreement";
    static String HIGHEST_POLL_AGREEMENT = "highestPollAgreement";
    static String PUBLISHING_PLATFORM = "publishingPlatform";
    static String TDB_PUBLISHER = "tdbPublisher";
    static String AVAILABLE_FROM_PUBLISHER = "availableFromPublisher";
    static String SUBSTANCE_STATE = "substanceState";
    static String CREATION_TIME = "creationTime";
    static String CRAWL_PROXY = "crawlProxy";
    static String CRAWL_WINDOW = "crawlWindow";
    static String CRAWL_POOL = "crawlPool";
    static String LAST_COMPLETED_CRAWL = "lastCompletedCrawl";
    static String LAST_CRAWL = "lastCrawl";
    static String LAST_CRAWL_RESULT = "lastCrawlResult";
    static String LAST_COMPLETED_DEEP_CRAWL = "lastCompletedDeepCrawl";
    static String LAST_DEEP_CRAWL = "lastDeepCrawl";
    static String LAST_DEEP_CRAWL_RESULT = "lastDeepCrawlResult";
    static String LAST_COMPLETED_DEEP_CRAWL_DEPTH = "lastCompletedDeepCrawlDepth";
    static String LAST_METADATA_INDEX = "lastMetadataIndex";
    static String LAST_COMPLETED_POLL = "lastCompletedPoll";
    static String LAST_POLL = "lastPoll";
    static String LAST_POLL_RESULT = "lastPollResult";
    static String CURRENTLY_CRAWLING = "currentlyCrawling";
    static String CURRENTLY_POLLING = "currentlyPolling";
    static String SUBSCRIPTION_STATUS = "subscriptionStatus";
    static String AU_CONFIGURATION = "auConfiguration";
    static String NEW_CONTENT_CRAWL_URLS = "newContentCrawlUrls";
    static String URL_STEMS = "urlStems";
    static String IS_BULK_CONTENT = "isBulkContent";
    static String PEER_AGREEMENTS = "peerAgreements";
    static String URLS = "urls";
    static String ACCESS_URLS = "accessUrls";
    static String SUBSTANCE_URLS = "substanceUrls";
    static String ARTICLE_URLS = "articleUrls";
    static String JOURNAL_TITLE = "journalTitle";
    static String TDB_PROVIDER = "tdbProvider";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(AU_ID);
            this.add(NAME);
            this.add(VOLUME);
            this.add(PLUGIN_NAME);
            this.add(TDB_YEAR);
            this.add(ACCESS_TYPE);
            this.add(CONTENT_SIZE);
            this.add(DISK_USAGE);
            this.add(REPOSITORY_PATH);
            this.add(RECENT_POLL_AGREEMENT);
            this.add(HIGHEST_POLL_AGREEMENT);
            this.add(PUBLISHING_PLATFORM);
            this.add(TDB_PUBLISHER);
            this.add(AVAILABLE_FROM_PUBLISHER);
            this.add(SUBSTANCE_STATE);
            this.add(CREATION_TIME);
            this.add(CRAWL_PROXY);
            this.add(CRAWL_WINDOW);
            this.add(CRAWL_POOL);
            this.add(LAST_COMPLETED_CRAWL);
            this.add(LAST_CRAWL);
            this.add(LAST_CRAWL_RESULT);
            this.add(LAST_COMPLETED_DEEP_CRAWL);
            this.add(LAST_DEEP_CRAWL);
            this.add(LAST_DEEP_CRAWL_RESULT);
            this.add(LAST_COMPLETED_DEEP_CRAWL_DEPTH);
            this.add(LAST_METADATA_INDEX);
            this.add(LAST_COMPLETED_POLL);
            this.add(LAST_POLL);
            this.add(LAST_POLL_RESULT);
            this.add(CURRENTLY_CRAWLING);
            this.add(CURRENTLY_POLLING);
            this.add(SUBSCRIPTION_STATUS);
            this.add(AU_CONFIGURATION);
            this.add(NEW_CONTENT_CRAWL_URLS);
            this.add(URL_STEMS);
            this.add(IS_BULK_CONTENT);
            this.add(PEER_AGREEMENTS);
            this.add(URLS);
            this.add(ACCESS_URLS);
            this.add(SUBSTANCE_URLS);
            this.add(ARTICLE_URLS);
            this.add(JOURNAL_TITLE);
            this.add(TDB_PROVIDER);
        }
    };
    private static Logger log = Logger.getLogger();

    AuStatus getAuStatus(String auId) {
        String provider;
        long lastPollStart;
        String crawlPool;
        String publisher;
        long du;
        long contentSize;
        String DEBUG_HEADER = "getAuStatus(): ";
        LockssDaemon theDaemon = LockssDaemon.getLockssDaemon();
        PluginManager pluginMgr = theDaemon.getPluginManager();
        ArchivalUnit au = pluginMgr.getAuFromIdIfExists(auId);
        if (au == null) {
            throw new IllegalArgumentException("No Archival Unit with provided identifier = " + auId);
        }
        AuStatus result = new AuStatus();
        result.setVolume(au.getName());
        TitleConfig tc = au.getTitleConfig();
        if (tc != null) {
            result.setJournalTitle(tc.getJournalTitle());
        }
        Plugin plugin = au.getPlugin();
        result.setPluginName(plugin.getPluginName());
        result.setYear(AuUtil.getTitleAttribute((ArchivalUnit)au, (String)"year"));
        AuState state = ((StateManager)theDaemon.getManagerByType(StateManager.class)).getAuState(au);
        AuState.AccessType atype = state.getAccessType();
        if (atype != null) {
            result.setAccessType(atype.toString());
        }
        if ((contentSize = AuUtil.getAuContentSize((ArchivalUnit)au, (boolean)false)) != -1L) {
            result.setContentSize(Long.valueOf(contentSize));
        }
        if ((du = AuUtil.getAuDiskUsage((ArchivalUnit)au, (boolean)false)) != -1L) {
            result.setDiskUsage(Long.valueOf(du));
        }
        CachedUrlSet auCus = au.getAuCachedUrlSet();
        if (state.getV3Agreement() < 0.0) {
            if (state.getLastCrawlTime() < 0L) {
                result.setStatus("Waiting for Crawl");
            } else {
                result.setStatus("Waiting for Poll");
            }
        } else {
            result.setStatus(this.doubleToPercent(state.getHighestV3Agreement()) + "% Agreement");
            if (state.getHighestV3Agreement() != state.getV3Agreement()) {
                result.setRecentPollAgreement(Double.valueOf(state.getV3Agreement()));
            }
        }
        String publishingPlatform = plugin.getPublishingPlatform();
        if (!StringUtil.isNullString((String)publishingPlatform)) {
            result.setPublishingPlatform(publishingPlatform);
        }
        if (!StringUtil.isNullString((String)(publisher = AuUtil.getTitleAttribute((ArchivalUnit)au, (String)"publisher")))) {
            result.setPublisher(publisher);
        }
        result.setAvailableFromPublisher(Boolean.valueOf(!AuUtil.isPubDown((ArchivalUnit)au)));
        result.setSubstanceState(state.getSubstanceState().toString());
        result.setCreationTime(Long.valueOf(state.getAuCreationTime()));
        AuUtil.AuProxyInfo aupinfo = AuUtil.getAuProxyInfo((ArchivalUnit)au);
        if (aupinfo.isInvalidAuOverride()) {
            result.setCrawlProxy("Invalid AU proxy spec: " + aupinfo.getAuSpec());
        } else if (aupinfo.isAuOverride()) {
            String disp = aupinfo.getHost() == null ? "Direct connection" : aupinfo.getHost() + ":" + aupinfo.getPort();
            result.setCrawlProxy(disp);
        }
        CrawlWindow window = au.getCrawlWindow();
        if (window != null) {
            Object wmsg = window.toString();
            if (((String)wmsg).length() > 140) {
                wmsg = "(not displayable)";
            }
            if (!window.canCrawl()) {
                wmsg = "Currently closed: " + (String)wmsg;
            }
            result.setCrawlWindow((String)wmsg);
        }
        if ((crawlPool = au.getFetchRateLimiterKey()) == null) {
            crawlPool = "(none)";
        }
        result.setCrawlPool(crawlPool);
        result.setLastCompletedCrawl(Long.valueOf(state.getLastCrawlTime()));
        result.setLastCompletedDeepCrawl(Long.valueOf(state.getLastDeepCrawlTime()));
        long lastCrawlAttempt = state.getLastCrawlAttempt();
        long lastDeepCrawlAttempt = state.getLastDeepCrawlAttempt();
        if (lastCrawlAttempt > 0L) {
            result.setLastCrawl(Long.valueOf(lastCrawlAttempt));
            result.setLastCrawlResult(state.getLastCrawlResultMsg());
        }
        if (lastDeepCrawlAttempt > 0L) {
            result.setLastDeepCrawl(Long.valueOf(lastDeepCrawlAttempt));
            result.setLastDeepCrawlResult(state.getLastDeepCrawlResultMsg());
            result.setLastCompletedDeepCrawlDepth(Integer.valueOf(state.getLastDeepCrawlDepth()));
        }
        result.setLastMetadataIndex(Long.valueOf(state.getLastMetadataIndex()));
        long lastTopLevelPollTime = state.getLastTopLevelPollTime();
        if (lastTopLevelPollTime > 0L) {
            result.setLastCompletedPoll(Long.valueOf(lastTopLevelPollTime));
        }
        if ((lastPollStart = state.getLastPollStart()) > 0L) {
            result.setLastPoll(Long.valueOf(lastPollStart));
            String pollResult = state.getLastPollResultMsg();
            if (!StringUtil.isNullString((String)pollResult)) {
                result.setLastPollResult(state.getLastPollResultMsg());
            }
        }
        result.setCurrentlyCrawling(Boolean.valueOf(theDaemon.getCrawlManager().getStatusSource().getStatus().isRunningNCCrawl(au)));
        if (theDaemon.isDetectClockssSubscription()) {
            result.setSubscriptionStatus(AuUtil.getAuState((ArchivalUnit)au).getClockssSubscriptionStatusString());
        }
        if (!StringUtil.isNullString((String)(provider = AuUtil.getTitleAttribute((ArchivalUnit)au, (String)"provider")))) {
            result.setProvider(provider);
        }
        if (log.isDebug2()) {
            log.debug2("getAuStatus(): result = " + result);
        }
        return result;
    }

    List<AuWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        try {
            Collection allAuConfigs = ConfigManager.getConfigManager().retrieveAllArchivalUnitConfiguration();
            if (log.isDebug3()) {
                log.debug3("createUniverse(): allAuConfigs = " + allAuConfigs);
            }
            ArrayList<AuWsSource> universe = new ArrayList<AuWsSource>(allAuConfigs.size());
            for (AuConfiguration auConfig : allAuConfigs) {
                String auId = auConfig.getAuId();
                if (log.isDebug3()) {
                    log.debug3("createUniverse(): auId = " + auId);
                }
                ArchivalUnit au = LockssDaemon.getLockssDaemon().getPluginManager().getAuFromId(auId);
                if (log.isDebug3()) {
                    log.debug3("createUniverse(): au = " + au);
                }
                universe.add(new AuWsSource(au));
            }
            if (log.isDebug2()) {
                log.debug2("createUniverse(): universe.size() = " + universe.size());
            }
            return universe;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String nonDefaultToString(Collection<AuWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (AuWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String doubleToPercent(double d) {
        int i = (int)(d * 10000.0);
        double pc = (double)i / 100.0;
        return new DecimalFormat("0.00").format(pc);
    }

    private String nonDefaultToString(AuWsResult result) {
        StringBuilder builder = new StringBuilder("AuWsResult [");
        boolean isFirst = true;
        if (result.getAuId() != null) {
            builder.append("auId=").append(result.getAuId());
            isFirst = false;
        }
        if (result.getName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("name=").append(result.getName());
        }
        if (result.getVolume() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("volume=").append(result.getVolume());
        }
        if (result.getPluginName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pluginName=").append(result.getPluginName());
        }
        if (result.getTdbYear() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tdbYear=").append(result.getTdbYear());
        }
        if (result.getAccessType() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("accessType=").append(result.getAccessType());
        }
        if (result.getContentSize() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("contentSize=").append(result.getContentSize());
        }
        if (result.getDiskUsage() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("diskUsage=").append(result.getDiskUsage());
        }
        if (result.getRepositoryPath() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("repositoryPath=").append(result.getRepositoryPath());
        }
        if (result.getRecentPollAgreement() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("recentPollAgreement=").append(result.getRecentPollAgreement());
        }
        if (result.getHighestPollAgreement() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("highestPollAgreement=").append(result.getHighestPollAgreement());
        }
        if (result.getPublishingPlatform() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("publishingPlatform=").append(result.getPublishingPlatform());
        }
        if (result.getTdbPublisher() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tdbPublisher=").append(result.getTdbPublisher());
        }
        if (result.getAvailableFromPublisher() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("availableFromPublisher=").append(result.getAvailableFromPublisher());
        }
        if (result.getSubstanceState() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("substanceState=").append(result.getSubstanceState());
        }
        if (result.getCreationTime() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("creationTime=").append(result.getCreationTime());
        }
        if (result.getCrawlProxy() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("crawlProxy=").append(result.getCrawlProxy());
        }
        if (result.getCrawlWindow() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("crawlWindow=").append(result.getCrawlWindow());
        }
        if (result.getCrawlPool() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("crawlPool=").append(result.getCrawlPool());
        }
        if (result.getLastCompletedCrawl() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastCompletedCrawl=").append(result.getLastCompletedCrawl());
        }
        if (result.getLastCrawl() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastCrawl=").append(result.getLastCrawl());
        }
        if (result.getLastCrawlResult() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastCrawlResult=").append(result.getLastCrawlResult());
        }
        if (result.getLastCompletedDeepCrawl() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastCompletedDeepCrawl=").append(result.getLastCompletedDeepCrawl());
        }
        if (result.getLastDeepCrawl() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastDeepCrawl=").append(result.getLastDeepCrawl());
        }
        if (result.getLastDeepCrawlResult() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastDeepCrawlResult=").append(result.getLastDeepCrawlResult());
        }
        if (result.getLastCompletedDeepCrawlDepth() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastCompletedDeepCrawlDepth=").append(result.getLastCompletedDeepCrawlDepth());
        }
        if (result.getLastMetadataIndex() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastMetadataIndex=").append(result.getLastMetadataIndex());
        }
        if (result.getLastCompletedPoll() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastCompletedPoll=").append(result.getLastCompletedPoll());
        }
        if (result.getLastPoll() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastPoll=").append(result.getLastPoll());
        }
        if (result.getLastPollResult() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("lastPollResult=").append(result.getLastPollResult());
        }
        if (result.getCurrentlyCrawling() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("currentlyCrawling=").append(result.getCurrentlyCrawling());
        }
        if (result.getCurrentlyPolling() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("currentlyPolling=").append(result.getCurrentlyPolling());
        }
        if (result.getSubscriptionStatus() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("subscriptionStatus=").append(result.getSubscriptionStatus());
        }
        if (result.getAuConfiguration() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("auConfiguration=").append(result.getAuConfiguration());
        }
        if (result.getNewContentCrawlUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("newContentCrawlUrls=").append(result.getNewContentCrawlUrls());
        }
        if (result.getUrlStems() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("urlStems=").append(result.getUrlStems());
        }
        if (result.getIsBulkContent() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("isBulkContent=").append(result.getIsBulkContent());
        }
        if (result.getPeerAgreements() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("peerAgreements=").append(result.getPeerAgreements());
        }
        if (result.getUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("urls=").append(result.getUrls());
        }
        if (result.getSubstanceUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("substanceUrls=").append(result.getSubstanceUrls());
        }
        if (result.getArticleUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("articleUrls=").append(result.getArticleUrls());
        }
        if (result.getJournalTitle() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("journalTitle=").append(result.getJournalTitle());
        }
        if (result.getTdbProvider() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tdbProvider=").append(result.getTdbProvider());
        }
        return builder.append("]").toString();
    }
}

