/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.regex.Perl5Pattern;
import org.lockss.app.LockssDaemon;
import org.lockss.config.CurrentConfig;
import org.lockss.crawler.CrawlManagerStatus;
import org.lockss.daemon.CachedUrlSetSpec;
import org.lockss.daemon.ConfigParamDescr;
import org.lockss.daemon.CrawlWindow;
import org.lockss.daemon.RangeCachedUrlSetSpec;
import org.lockss.daemon.TitleConfig;
import org.lockss.extractor.MetadataTarget;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.ArticleFiles;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.CachedUrl;
import org.lockss.plugin.CachedUrlSet;
import org.lockss.plugin.CachedUrlSetNode;
import org.lockss.plugin.CuIterator;
import org.lockss.plugin.Plugin;
import org.lockss.poller.ReputationTransfers;
import org.lockss.protocol.AgreementType;
import org.lockss.protocol.IdentityManager;
import org.lockss.protocol.PeerAgreement;
import org.lockss.protocol.PeerIdentity;
import org.lockss.state.AuState;
import org.lockss.state.StateManager;
import org.lockss.state.SubstanceChecker;
import org.lockss.util.Logger;
import org.lockss.util.PatternFloatMap;
import org.lockss.util.StringUtil;
import org.lockss.util.TypedEntryMap;
import org.lockss.ws.entities.AgreementTypeWsResult;
import org.lockss.ws.entities.AuConfigurationWsResult;
import org.lockss.ws.entities.AuWsResult;
import org.lockss.ws.entities.PeerAgreementWsResult;
import org.lockss.ws.entities.PeerAgreementsWsResult;
import org.lockss.ws.entities.UrlWsResult;

public class AuWsSource
extends AuWsResult {
    private static Logger log = Logger.getLogger();
    private ArchivalUnit au;
    private boolean auIdPopulated = false;
    private boolean namePopulated = false;
    private boolean volumePopulated = false;
    private boolean pluginNamePopulated = false;
    private boolean tdbYearPopulated = false;
    private boolean accessTypePopulated = false;
    private boolean contentSizePopulated = false;
    private boolean diskUsagePopulated = false;
    private boolean repositoryPathPopulated = false;
    private boolean recentPollAgreementPopulated = false;
    private boolean highestPollAgreementPopulated = false;
    private boolean publishingPlatformPopulated = false;
    private boolean tdbPublisherPopulated = false;
    private boolean availableFromPublisherPopulated = false;
    private boolean substanceStatePopulated = false;
    private boolean creationTimePopulated = false;
    private boolean crawlProxyPopulated = false;
    private boolean crawlWindowPopulated = false;
    private boolean crawlPoolPopulated = false;
    private boolean lastCompletedCrawlPopulated = false;
    private boolean lastCrawlPopulated = false;
    private boolean lastCrawlResultPopulated = false;
    private boolean lastDeepCrawlPopulated = false;
    private boolean lastCompletedDeepCrawlPopulated = false;
    private boolean lastDeepCrawlResultPopulated = false;
    private boolean lastCompletedDeepCrawlDepthPopulated = false;
    private boolean lastMetadataIndexPopulated = false;
    private boolean lastCompletedPollPopulated = false;
    private boolean lastPollPopulated = false;
    private boolean lastPollResultPopulated = false;
    private boolean currentlyCrawlingPopulated = false;
    private boolean currentlyPollingPopulated = false;
    private boolean subscriptionStatusPopulated = false;
    private boolean auConfigurationPopulated = false;
    private boolean newContentCrawlUrlsPopulated = false;
    private boolean urlStemsPopulated = false;
    private boolean isBulkContentPopulated = false;
    private boolean peerAgreementsPopulated = false;
    private boolean urlsPopulated = false;
    private boolean accessUrlsPopulated = false;
    private boolean substanceUrlsPopulated = false;
    private boolean articleUrlsPopulated = false;
    private boolean journalTitlePopulated;
    private boolean tdbProviderPopulated = false;
    private LockssDaemon theDaemon = null;
    private Plugin plugin = null;
    private StateManager stateMgr = null;
    private AuState state = null;
    private CachedUrlSet auCachedUrlSet = null;
    private PatternFloatMap resultWeightMap = null;
    private boolean includePollWeight = false;

    public AuWsSource(ArchivalUnit au) {
        this.au = au;
    }

    public String getAuId() {
        if (!this.auIdPopulated) {
            this.setAuId(this.au.getAuId());
            this.auIdPopulated = true;
        }
        return super.getAuId();
    }

    public String getName() {
        if (!this.namePopulated) {
            this.setName(this.au.getName());
            this.namePopulated = true;
        }
        return super.getName();
    }

    public String getVolume() {
        if (!this.volumePopulated) {
            this.setVolume(this.au.getName());
            this.volumePopulated = true;
        }
        return super.getVolume();
    }

    public String getPluginName() {
        if (!this.pluginNamePopulated) {
            this.setPluginName(this.getPlugin().getPluginId());
            this.pluginNamePopulated = true;
        }
        return super.getPluginName();
    }

    public String getTdbYear() {
        if (!this.tdbYearPopulated) {
            this.setTdbYear(AuUtil.getTitleAttribute((ArchivalUnit)this.au, (String)"year"));
            this.tdbYearPopulated = true;
        }
        return super.getTdbYear();
    }

    public String getAccessType() {
        if (!this.accessTypePopulated) {
            AuState.AccessType atype = this.getState().getAccessType();
            if (atype != null) {
                this.setAccessType(atype.toString());
            }
            this.accessTypePopulated = true;
        }
        return super.getAccessType();
    }

    public Long getContentSize() {
        if (!this.contentSizePopulated) {
            long auContentSize = AuUtil.getAuContentSize((ArchivalUnit)this.au, (boolean)true);
            if (auContentSize != -1L) {
                this.setContentSize(auContentSize);
            }
            this.contentSizePopulated = true;
        }
        return super.getContentSize();
    }

    public Long getDiskUsage() {
        if (!this.diskUsagePopulated) {
            long auDiskUsage = AuUtil.getAuDiskUsage((ArchivalUnit)this.au, (boolean)true);
            if (auDiskUsage != -1L) {
                this.setDiskUsage(auDiskUsage);
            }
            this.diskUsagePopulated = true;
        }
        return super.getDiskUsage();
    }

    public String getRepositoryPath() {
        if (!this.repositoryPathPopulated) {
            this.setRepositoryPath("XXXREPO");
            this.repositoryPathPopulated = true;
        }
        return super.getRepositoryPath();
    }

    public Double getRecentPollAgreement() {
        if (!this.recentPollAgreementPopulated) {
            if (AuUtil.getProtocolVersion((ArchivalUnit)this.au) == 3 && this.getState().getV3Agreement() >= 0.0) {
                this.setRecentPollAgreement(this.state.getV3Agreement());
            }
            this.recentPollAgreementPopulated = true;
        }
        return super.getRecentPollAgreement();
    }

    public Double getHighestPollAgreement() {
        if (!this.highestPollAgreementPopulated) {
            if (AuUtil.getProtocolVersion((ArchivalUnit)this.au) == 3 && this.getState().getHighestV3Agreement() >= 0.0) {
                this.setHighestPollAgreement(this.state.getHighestV3Agreement());
            }
            this.highestPollAgreementPopulated = true;
        }
        return super.getHighestPollAgreement();
    }

    public String getPublishingPlatform() {
        if (!this.publishingPlatformPopulated) {
            String platform = this.getPlugin().getPublishingPlatform();
            if (!StringUtil.isNullString((String)platform)) {
                this.setPublishingPlatform(platform);
            }
            this.publishingPlatformPopulated = true;
        }
        return super.getPublishingPlatform();
    }

    public String getTdbPublisher() {
        if (!this.tdbPublisherPopulated) {
            String publisherName = AuUtil.getTitleAttribute((ArchivalUnit)this.au, (String)"publisher");
            if (!StringUtil.isNullString((String)publisherName)) {
                this.setTdbPublisher(publisherName);
            }
            this.tdbPublisherPopulated = true;
        }
        return super.getTdbPublisher();
    }

    public Boolean getAvailableFromPublisher() {
        if (!this.availableFromPublisherPopulated) {
            this.setAvailableFromPublisher(!AuUtil.isPubDown((ArchivalUnit)this.au));
            this.availableFromPublisherPopulated = true;
        }
        return super.getAvailableFromPublisher();
    }

    public String getSubstanceState() {
        if (!this.substanceStatePopulated) {
            this.setSubstanceState(this.getState().getSubstanceState().toString());
            this.substanceStatePopulated = true;
        }
        return super.getSubstanceState();
    }

    public Long getCreationTime() {
        if (!this.creationTimePopulated) {
            this.setCreationTime(this.getState().getAuCreationTime());
            this.creationTimePopulated = true;
        }
        return super.getCreationTime();
    }

    public String getCrawlProxy() {
        if (!this.crawlProxyPopulated) {
            AuUtil.AuProxyInfo aupinfo = AuUtil.getAuProxyInfo((ArchivalUnit)this.au);
            if (aupinfo.isInvalidAuOverride()) {
                this.setCrawlProxy("Invalid AU proxy spec: " + aupinfo.getAuSpec());
            } else if (aupinfo.isAuOverride()) {
                this.setCrawlProxy((String)(aupinfo.getHost() == null ? "Direct connection" : aupinfo.getHost() + ":" + aupinfo.getPort()));
            }
            this.crawlProxyPopulated = true;
        }
        return super.getCrawlProxy();
    }

    public String getCrawlWindow() {
        if (!this.crawlWindowPopulated) {
            CrawlWindow window = this.au.getCrawlWindow();
            if (window != null) {
                Object wmsg = window.toString();
                if (((String)wmsg).length() > 140) {
                    wmsg = "(not displayable)";
                }
                if (!window.canCrawl()) {
                    wmsg = "Currently closed: " + (String)wmsg;
                }
                this.setCrawlWindow((String)wmsg);
            }
            this.crawlWindowPopulated = true;
        }
        return super.getCrawlWindow();
    }

    public String getCrawlPool() {
        if (!this.crawlPoolPopulated) {
            String frlk = this.au.getFetchRateLimiterKey();
            if (frlk == null) {
                this.setCrawlPool("(none)");
            } else {
                this.setCrawlPool(frlk);
            }
            this.crawlPoolPopulated = true;
        }
        return super.getCrawlPool();
    }

    public Long getLastCompletedCrawl() {
        if (!this.lastCompletedCrawlPopulated) {
            this.setLastCompletedCrawl(this.getState().getLastCrawlTime());
            this.lastCompletedCrawlPopulated = true;
        }
        return super.getLastCompletedCrawl();
    }

    public Long getLastCrawl() {
        if (!this.lastCrawlPopulated) {
            long lastCrawlAttempt = this.getState().getLastCrawlAttempt();
            if (lastCrawlAttempt > 0L) {
                this.setLastCrawl(lastCrawlAttempt);
            }
            this.lastCrawlPopulated = true;
        }
        return super.getLastCrawl();
    }

    public String getLastCrawlResult() {
        if (!this.lastCrawlResultPopulated) {
            long lastCrawlAttempt = this.getState().getLastCrawlAttempt();
            if (lastCrawlAttempt > 0L) {
                this.setLastCrawlResult(this.state.getLastCrawlResultMsg());
            }
            this.lastCrawlResultPopulated = true;
        }
        return super.getLastCrawlResult();
    }

    public Long getLastDeepCrawl() {
        if (!this.lastDeepCrawlPopulated) {
            long lastDeepCrawl = this.getState().getLastDeepCrawlAttempt();
            if (lastDeepCrawl > 0L) {
                this.setLastDeepCrawl(lastDeepCrawl);
            }
            this.lastDeepCrawlPopulated = true;
        }
        return super.getLastDeepCrawl();
    }

    public Long getLastCompletedDeepCrawl() {
        if (!this.lastCompletedDeepCrawlPopulated) {
            long lastCompletedDeepCrawl = this.getState().getLastDeepCrawlTime();
            if (lastCompletedDeepCrawl > 0L) {
                this.setLastCompletedDeepCrawl(lastCompletedDeepCrawl);
            }
            this.lastCompletedDeepCrawlPopulated = true;
        }
        return super.getLastCompletedDeepCrawl();
    }

    public String getLastDeepCrawlResult() {
        if (!this.lastDeepCrawlResultPopulated) {
            long lastDeepCrawlAttempt = this.getState().getLastDeepCrawlAttempt();
            if (lastDeepCrawlAttempt > 0L) {
                this.setLastDeepCrawlResult(this.state.getLastDeepCrawlResultMsg());
            }
            this.lastDeepCrawlResultPopulated = true;
        }
        return super.getLastDeepCrawlResult();
    }

    public Integer getLastCompletedDeepCrawlDepth() {
        if (!this.lastCompletedDeepCrawlDepthPopulated) {
            int lastCompletedDeepCrawlDepth = this.getState().getLastDeepCrawlDepth();
            if (lastCompletedDeepCrawlDepth > 0) {
                this.setLastCompletedDeepCrawlDepth(lastCompletedDeepCrawlDepth);
            }
            this.lastCompletedDeepCrawlDepthPopulated = true;
        }
        return super.getLastCompletedDeepCrawlDepth();
    }

    public Long getLastMetadataIndex() {
        if (!this.lastMetadataIndexPopulated) {
            long lastMetadataIndex = this.getState().getLastMetadataIndex();
            if (lastMetadataIndex > 0L) {
                this.setLastMetadataIndex(lastMetadataIndex);
            }
            this.lastMetadataIndexPopulated = true;
        }
        return super.getLastMetadataIndex();
    }

    public Long getLastCompletedPoll() {
        if (!this.lastCompletedPollPopulated) {
            long lastTopLevelPollTime = this.getState().getLastTopLevelPollTime();
            if (lastTopLevelPollTime > 0L) {
                this.setLastCompletedPoll(lastTopLevelPollTime);
            }
            this.lastCompletedPollPopulated = true;
        }
        return super.getLastCompletedPoll();
    }

    public Long getLastPoll() {
        if (!this.lastPollPopulated) {
            long lastPollStart = this.getState().getLastPollStart();
            if (lastPollStart > 0L) {
                this.setLastPoll(lastPollStart);
            }
            this.lastPollPopulated = true;
        }
        return super.getLastPoll();
    }

    public String getLastPollResult() {
        if (!this.lastPollResultPopulated) {
            String pollResult;
            long lastPollStart = this.getState().getLastPollStart();
            if (lastPollStart > 0L && !StringUtil.isNullString((String)(pollResult = this.state.getLastPollResultMsg()))) {
                this.setLastPollResult(this.state.getLastPollResultMsg());
            }
            this.lastPollResultPopulated = true;
        }
        return super.getLastPollResult();
    }

    public Boolean getCurrentlyCrawling() {
        if (!this.currentlyCrawlingPopulated) {
            CrawlManagerStatus cms = this.getTheDaemon().getCrawlManager().getStatusSource().getStatus();
            if (cms != null) {
                this.setCurrentlyCrawling(cms.isRunningNCCrawl(this.au));
            }
            this.currentlyCrawlingPopulated = true;
        }
        return super.getCurrentlyCrawling();
    }

    public Boolean getCurrentlyPolling() {
        if (!this.currentlyPollingPopulated) {
            this.currentlyPollingPopulated = true;
        }
        return super.getCurrentlyPolling();
    }

    public String getSubscriptionStatus() {
        if (!this.subscriptionStatusPopulated) {
            if (this.getTheDaemon().isDetectClockssSubscription()) {
                this.setSubscriptionStatus(AuUtil.getAuState((ArchivalUnit)this.au).getClockssSubscriptionStatusString());
            }
            this.subscriptionStatusPopulated = true;
        }
        return super.getSubscriptionStatus();
    }

    public AuConfigurationWsResult getAuConfiguration() {
        if (!this.auConfigurationPopulated) {
            TypedEntryMap auProperties = this.au.getProperties();
            if (auProperties.size() > 0) {
                AuConfigurationWsResult result = new AuConfigurationWsResult();
                HashMap<String, String> defParams = new HashMap<String, String>();
                result.setDefParams(defParams);
                HashMap<String, String> nonDefParams = new HashMap<String, String>();
                result.setNonDefParams(nonDefParams);
                for (Map.Entry entry : auProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    ConfigParamDescr descr = this.getPlugin().findAuConfigDescr(key);
                    if (descr == null || !this.au.getConfiguration().containsKey(key)) continue;
                    if (descr.isDefinitional()) {
                        defParams.put(key, this.valString(val, descr));
                        continue;
                    }
                    nonDefParams.put(key, this.valString(val, descr));
                }
                this.setAuConfiguration(result);
            }
            this.auConfigurationPopulated = true;
        }
        return super.getAuConfiguration();
    }

    String valString(Object val, ConfigParamDescr descr) {
        if (val == null) {
            return null;
        }
        if (val instanceof Perl5Pattern) {
            return ((Perl5Pattern)val).getPattern();
        }
        if (descr == null) {
            return val.toString();
        }
        switch (descr.getType()) {
            case 10: {
                if (!(val instanceof List)) break;
                List l = (List)val;
                return l.get(0) + ":******";
            }
            default: {
                return val.toString();
            }
        }
        return val.toString();
    }

    public List<String> getNewContentCrawlUrls() {
        if (!this.newContentCrawlUrlsPopulated) {
            this.setNewContentCrawlUrls(new ArrayList(this.au.getStartUrls()));
            this.newContentCrawlUrlsPopulated = true;
        }
        return super.getNewContentCrawlUrls();
    }

    public List<String> getUrlStems() {
        if (!this.urlStemsPopulated) {
            this.setUrlStems((List)this.au.getUrlStems());
            this.urlStemsPopulated = true;
        }
        return super.getUrlStems();
    }

    public Boolean getIsBulkContent() {
        if (!this.isBulkContentPopulated) {
            this.setIsBulkContent(this.au.isBulkContent());
            this.isBulkContentPopulated = true;
        }
        return super.getIsBulkContent();
    }

    public List<PeerAgreementsWsResult> getPeerAgreements() {
        if (!this.peerAgreementsPopulated) {
            PeerAgreement agreement;
            IdentityManager idManager = this.getTheDaemon().getIdentityManager();
            ReputationTransfers repXfer = null;
            if (CurrentConfig.getBooleanParam((String)"org.lockss.auStatus.peerArgeementsUseReputationTransfers", (boolean)true)) {
                repXfer = new ReputationTransfers(idManager);
            }
            HashMap<String, HashMap<AgreementType, PeerAgreement>> allAgreementsByPeer = new HashMap<String, HashMap<AgreementType, PeerAgreement>>();
            for (AgreementType type : AgreementType.values()) {
                Map agreementsByPeer = idManager.getAgreements(this.au, type);
                for (PeerIdentity pid : agreementsByPeer.keySet()) {
                    HashMap<AgreementType, PeerAgreement> typeMap;
                    agreement = (PeerAgreement)agreementsByPeer.get(pid);
                    if (agreement == null || !((double)agreement.getHighestPercentAgreement() >= 0.0)) continue;
                    if (repXfer != null) {
                        pid = repXfer.getPeerInheritingReputation(pid);
                    }
                    if ((typeMap = (HashMap<AgreementType, PeerAgreement>)allAgreementsByPeer.get(pid.getIdString())) == null) {
                        typeMap = new HashMap<AgreementType, PeerAgreement>();
                        allAgreementsByPeer.put(pid.getIdString(), typeMap);
                    }
                    typeMap.put(type, agreement.mergeWith((PeerAgreement)typeMap.get(type)));
                }
            }
            ArrayList<PeerAgreementsWsResult> results = new ArrayList<PeerAgreementsWsResult>();
            for (String pidid : allAgreementsByPeer.keySet()) {
                HashMap<AgreementTypeWsResult, PeerAgreementWsResult> resultAgreements = new HashMap<AgreementTypeWsResult, PeerAgreementWsResult>();
                for (AgreementType type : ((Map)allAgreementsByPeer.get(pidid)).keySet()) {
                    AgreementTypeWsResult resultType = AgreementTypeWsResult.values()[type.ordinal()];
                    agreement = (PeerAgreement)((Map)allAgreementsByPeer.get(pidid)).get(type);
                    PeerAgreementWsResult resultAgreement = new PeerAgreementWsResult(Float.valueOf(agreement.getPercentAgreement()), Long.valueOf(agreement.getPercentAgreementTime()), Float.valueOf(agreement.getHighestPercentAgreement()), Long.valueOf(agreement.getHighestPercentAgreementTime()));
                    resultAgreements.put(resultType, resultAgreement);
                }
                PeerAgreementsWsResult result = new PeerAgreementsWsResult();
                result.setPeerId(pidid);
                result.setAgreements(resultAgreements);
                results.add(result);
            }
            this.setPeerAgreements(results);
            this.peerAgreementsPopulated = true;
        }
        return super.getPeerAgreements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UrlWsResult> getUrls() {
        if (!this.urlsPopulated) {
            ArrayList<UrlWsResult> results = new ArrayList<UrlWsResult>();
            try {
                this.resultWeightMap = this.au.makeUrlPollResultWeightMap();
                this.includePollWeight = true;
            }
            catch (ArchivalUnit.ConfigurationException e) {
                log.warning("Error building urlResultWeightMap, disabling", (Throwable)e);
            }
            for (CachedUrlSetNode cusn : this.getAuCachedUrlSet().getCuIterable()) {
                CachedUrl cu = null;
                CachedUrlSet cus = cusn.getType() == 0 ? (CachedUrlSet)cusn : this.au.makeCachedUrlSet((CachedUrlSetSpec)new RangeCachedUrlSetSpec(cusn.getUrl()));
                String url = cus.getUrl();
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                try {
                    UrlWsResult urlResult;
                    block10: {
                        urlResult = new UrlWsResult();
                        urlResult.setUrl(url);
                        cu = this.au.makeCachedUrl(url);
                        urlResult.setVersionCount(Integer.valueOf(cu.getCuVersions().length));
                        try {
                            urlResult.setCurrentVersionSize(Long.valueOf(cu.getContentSize()));
                        }
                        catch (UnsupportedOperationException uoe) {
                            if (!log.isDebug()) break block10;
                            log.debug("getUrls(): Ignored content size for no-content URL '" + url + "'");
                        }
                    }
                    if (this.includePollWeight) {
                        urlResult.setPollWeight(Float.valueOf(this.getUrlResultWeight(url)));
                    }
                    results.add(urlResult);
                }
                catch (Throwable throwable) {
                    AuUtil.safeRelease(cu);
                    throw throwable;
                }
                AuUtil.safeRelease((CachedUrl)cu);
            }
            this.setUrls(results);
            this.urlsPopulated = true;
        }
        return super.getUrls();
    }

    protected float getUrlResultWeight(String url) {
        if (this.resultWeightMap == null || this.resultWeightMap.isEmpty()) {
            return 1.0f;
        }
        return this.resultWeightMap.getMatch(url, 1.0f).floatValue();
    }

    public Collection<String> getAccessUrls() {
        if (!this.accessUrlsPopulated) {
            this.setAccessUrls(this.au.getAccessUrls());
            this.accessUrlsPopulated = true;
        }
        return super.getAccessUrls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSubstanceUrls() {
        if (!this.substanceUrlsPopulated) {
            ArrayList<String> results = new ArrayList<String>();
            if (AuUtil.hasSubstancePatterns((ArchivalUnit)this.au)) {
                int logException = 3;
                CuIterator iterator = this.getAuCachedUrlSet().getCuIterator();
                CachedUrl cu = null;
                SubstanceChecker subChecker = new SubstanceChecker(this.au);
                while (iterator.hasNext()) {
                    try {
                        String url;
                        cu = (CachedUrl)iterator.next();
                        if (!cu.hasContent() || !subChecker.isSubstanceUrl(url = cu.getUrl())) continue;
                        results.add(url);
                    }
                    catch (Exception e) {
                        if (logException-- <= 0) continue;
                        log.warning("getSubstanceUrls() threw for cu " + cu, (Throwable)e);
                    }
                    finally {
                        AuUtil.safeRelease((CachedUrl)cu);
                    }
                }
            }
            this.setSubstanceUrls(results);
            this.substanceUrlsPopulated = true;
        }
        return super.getSubstanceUrls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getArticleUrls() {
        if (!this.articleUrlsPopulated) {
            ArrayList<String> results = new ArrayList<String>();
            int logEmpty = 3;
            int logException = 3;
            int logMissing = 3;
            Iterator iter = this.au.getArticleIterator(MetadataTarget.Article());
            while (iter.hasNext()) {
                ArticleFiles af = (ArticleFiles)iter.next();
                if (af.isEmpty()) {
                    if (logEmpty-- <= 0) continue;
                    log.error("ArticleIterator generated empty ArticleFiles");
                    continue;
                }
                CachedUrl cu = null;
                try {
                    cu = af.getFullTextCu();
                    if (cu != null) {
                        results.add(cu.getUrl());
                        continue;
                    }
                    if (logMissing-- <= 0) continue;
                    log.error("ArticleIterator generated ArticleFiles with no full text CU: " + af);
                }
                catch (Exception e) {
                    if (logException-- <= 0) continue;
                    log.warning("getArticleUrls() threw", (Throwable)e);
                }
                finally {
                    AuUtil.safeRelease((CachedUrl)cu);
                }
            }
            this.setArticleUrls(results);
            this.articleUrlsPopulated = true;
        }
        return super.getArticleUrls();
    }

    public String getJournalTitle() {
        if (!this.journalTitlePopulated) {
            TitleConfig tc = this.au.getTitleConfig();
            if (tc != null) {
                this.setJournalTitle(tc.getJournalTitle());
            }
            this.journalTitlePopulated = true;
        }
        return super.getJournalTitle();
    }

    public String getTdbProvider() {
        if (!this.tdbProviderPopulated) {
            String providerName = AuUtil.getTitleAttribute((ArchivalUnit)this.au, (String)"provider");
            if (!StringUtil.isNullString((String)providerName)) {
                this.setTdbProvider(providerName);
            }
            this.tdbProviderPopulated = true;
        }
        return super.getTdbProvider();
    }

    private LockssDaemon getTheDaemon() {
        if (this.theDaemon == null) {
            this.theDaemon = LockssDaemon.getLockssDaemon();
        }
        return this.theDaemon;
    }

    private Plugin getPlugin() {
        if (this.plugin == null) {
            this.plugin = this.au.getPlugin();
        }
        return this.plugin;
    }

    private StateManager getStateManager() {
        if (this.stateMgr == null) {
            this.stateMgr = (StateManager)this.getTheDaemon().getManagerByType(StateManager.class);
        }
        return this.stateMgr;
    }

    private AuState getState() {
        if (this.state == null) {
            this.state = this.getStateManager().getAuState(this.au);
        }
        return this.state;
    }

    private CachedUrlSet getAuCachedUrlSet() {
        if (this.auCachedUrlSet == null) {
            this.auCachedUrlSet = this.au.getAuCachedUrlSet();
        }
        return this.auCachedUrlSet;
    }
}

