/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.laaws.config.api.AuidsApiDelegate;
import org.lockss.log.L4JLogger;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.spring.auth.AuthUtil;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.MapUtil;
import org.lockss.util.PropUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AuidsApiServiceImpl
extends BaseSpringApiServiceImpl
implements AuidsApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();

    public ResponseEntity calculateAuid(String pluginId, String handle, Object auConfig) {
        Map auMap;
        log.debug2("pluginId: {}", (Object)pluginId);
        log.debug2("handle: {}", (Object)handle);
        log.debug2("auConfig: {}", auConfig);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"anyRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (handle != null) {
            if (auConfig != null) {
                return this.stringResponse("Must not supply both auConfig and handle", HttpStatus.BAD_REQUEST);
            }
            if (pluginId == null) {
                pluginId = "org.lockss.plugin.NamedPlugin";
            }
            try {
                String auid = PluginManager.generateAuId((String)pluginId, (Properties)PropUtil.fromArgs((String)"handle", (String)handle));
                return this.calcAuidResult(auid);
            }
            catch (IllegalArgumentException e) {
                return this.stringResponse("Illegal AU config: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
        }
        if (auConfig == null || pluginId == null) {
            return this.stringResponse("Must supply handle, or auConfig and pluginId", HttpStatus.BAD_REQUEST);
        }
        try {
            auMap = AuUtil.jsonToMap((String)((String)auConfig));
        }
        catch (IOException e) {
            log.debug2("Couldn't parse auConfig: {}", auConfig, (Object)e);
            return this.stringResponse("Illegal map formet: " + auConfig + ": " + e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        PluginManager pluginMgr = this.getPluginManager();
        String plugKey = PluginManager.pluginKeyFromId((String)pluginId);
        if (!pluginMgr.ensurePluginLoaded(plugKey)) {
            return this.stringResponse("Plugin not found: " + pluginId, HttpStatus.NOT_FOUND);
        }
        Properties p = new Properties();
        p.putAll((Map<?, ?>)auMap);
        try {
            String auid = PluginManager.generateAuId((Plugin)pluginMgr.getPlugin(plugKey), (Configuration)ConfigManager.fromProperties((Properties)p));
            return this.calcAuidResult(auid);
        }
        catch (IllegalArgumentException e) {
            return this.stringResponse("Illegal AU config: " + e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    ResponseEntity calcAuidResult(String auid) {
        return this.jsonResponse(MapUtil.map((Object[])new Object[]{"auid", auid}), HttpStatus.OK);
    }
}

