/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Map;
import org.lockss.account.UserAccount;
import org.lockss.app.LockssDaemon;
import org.lockss.config.AuConfiguration;
import org.lockss.config.ConfigManager;
import org.lockss.laaws.config.api.AusApiDelegate;
import org.lockss.log.L4JLogger;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.PluginManager;
import org.lockss.servlet.DebugPanel;
import org.lockss.spring.auth.AuthUtil;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.StringUtil;
import org.lockss.ws.entities.RequestAuControlResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AusApiServiceImpl
extends BaseSpringApiServiceImpl
implements AusApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    static final String MISSING_AU_ID_ERROR_MESSAGE = "Missing auId";
    static final String NO_SUCH_AU_ERROR_MESSAGE = "No such Archival Unit";
    static final String DISABLED_METADATA_PROCESSING_ERROR_MESSAGE = "Metadata processing is not enabled";
    static final String ACTION_DISABLE_METADATA_INDEXING = "Disable Indexing";
    static final String DISABLE_METADATA_INDEXING_ERROR_MESSAGE = "Cannot disable AU metadata indexing";
    static final String ACTION_ENABLE_METADATA_INDEXING = "Enable Indexing";
    static final String ENABLE_METADATA_INDEXING_ERROR_MESSAGE = "Cannot enable AU metadata indexing";
    static final String PARAM_INDEXING_ENABLED = "org.lockss.metadataManager.indexing_enabled";
    static final boolean DEFAULT_INDEXING_ENABLED = false;

    public ResponseEntity deleteAuConfig(String auid) {
        if (log.isDebugEnabled()) {
            log.debug("auid = " + auid);
        }
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            if (auid == null || auid.isEmpty()) {
                String message = "Invalid auid = '" + auid + "'";
                log.error(message);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            PluginManager pluginManager = this.getPluginManager();
            AuConfiguration result = pluginManager.getStoredAuConfiguration(auid);
            if (log.isDebugEnabled()) {
                log.debug("result = " + result);
            }
            pluginManager.deleteAuConfiguration(auid);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No Archival Unit found for auid = '" + auid + "'";
            log.error(message);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot deleteAuConfig() for auid = '" + auid + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getAllAuConfig() {
        if (log.isDebugEnabled()) {
            log.debug("Invoked");
        }
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            Collection result = this.getConfigManager().retrieveAllArchivalUnitConfiguration();
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot getAllAuConfig()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getAuConfig(String auid) {
        if (log.isDebugEnabled()) {
            log.debug("auid = " + auid);
        }
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            if (auid == null || auid.isEmpty()) {
                String message = "Invalid auid = '" + auid + "'";
                log.error(message);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            AuConfiguration result = this.getPluginManager().getStoredAuConfiguration(auid);
            if (log.isDebugEnabled()) {
                log.debug("result = " + result);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No Archival Unit found for auid = '" + auid + "'";
            log.error(message);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot getAuConfig() for auid = '" + auid + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity putAuConfig(String auidArg, AuConfiguration auConfiguration) {
        if (log.isDebugEnabled()) {
            log.debug("auConfiguration = " + auConfiguration);
        }
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        String auId = null;
        try {
            auId = auConfiguration.getAuId();
            if (auId == null || auId.isEmpty() || !auId.equals(auidArg)) {
                String message = "Invalid auId = '" + auId + "'";
                log.error(message);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            Map auConfig = auConfiguration.getAuConfig();
            if (auConfig == null || auConfig.isEmpty()) {
                String message = "Configuration to be stored is not allowed to be null or empty";
                log.error(message);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            this.getPluginManager().updateAuConfigFromExternalSource(auConfiguration);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No Archival Unit found for auid = '" + auId + "'";
            log.error(message);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot putAuConfig()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity putAusMdEnable(String auId) {
        log.debug2("auId = {}", (Object)auId);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            this.audit(ACTION_ENABLE_METADATA_INDEXING, auId);
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        RequestAuControlResult result = null;
        try {
            if (!ConfigManager.getCurrentConfig().getBoolean(PARAM_INDEXING_ENABLED, false)) {
                result = new RequestAuControlResult(auId, false, DISABLED_METADATA_PROCESSING_ERROR_MESSAGE);
                log.debug2("result = {}", (Object)result);
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.CONFLICT);
            }
            if (StringUtil.isNullString((String)auId)) {
                result = new RequestAuControlResult(auId, false, MISSING_AU_ID_ERROR_MESSAGE);
                log.debug2("result = {}", (Object)result);
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            ArchivalUnit au = LockssDaemon.getLockssDaemon().getPluginManager().getAuFromId(auId);
            log.trace("au = {}", (Object)au);
            if (au == null) {
                result = new RequestAuControlResult(auId, false, NO_SUCH_AU_ERROR_MESSAGE);
                log.debug2("result = {}", (Object)result);
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            try {
                result = new RequestAuControlResult(auId, true, null);
            }
            catch (Exception e) {
                result = new RequestAuControlResult(auId, false, "Cannot enable AU metadata indexing: " + e.getMessage());
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot putAusReactivate()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity putAusMdDisable(String auId) {
        log.debug2("auId = {}", (Object)auId);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            this.audit(ACTION_DISABLE_METADATA_INDEXING, auId);
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        RequestAuControlResult result = null;
        try {
            if (!ConfigManager.getCurrentConfig().getBoolean(PARAM_INDEXING_ENABLED, false)) {
                result = new RequestAuControlResult(auId, false, DISABLED_METADATA_PROCESSING_ERROR_MESSAGE);
                log.debug2("result = {}", (Object)result);
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.CONFLICT);
            }
            if (StringUtil.isNullString((String)auId)) {
                result = new RequestAuControlResult(auId, false, MISSING_AU_ID_ERROR_MESSAGE);
                log.debug2("result = {}", (Object)result);
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            ArchivalUnit au = LockssDaemon.getLockssDaemon().getPluginManager().getAuFromId(auId);
            log.trace("au = {}", (Object)au);
            if (au == null) {
                result = new RequestAuControlResult(auId, false, NO_SUCH_AU_ERROR_MESSAGE);
                log.debug2("result = {}", (Object)result);
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            try {
                result = new RequestAuControlResult(auId, true, null);
            }
            catch (Exception e) {
                result = new RequestAuControlResult(auId, false, "Cannot disable AU metadata indexing: " + e.getMessage());
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot putAusReactivate()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private ConfigManager getConfigManager() {
        return ConfigManager.getConfigManager();
    }

    private void audit(String action, String auId) throws AccessControlException {
        log.debug2("action = {}", (Object)action);
        log.debug2("auId = {}", (Object)auId);
        String userName = SecurityContextHolder.getContext().getAuthentication().getName();
        log.trace("userName = {}", (Object)userName);
        UserAccount userAccount = null;
        try {
            userAccount = LockssDaemon.getLockssDaemon().getAccountManager().getUser(userName);
            log.trace("userAccount = {}", (Object)userAccount);
        }
        catch (Exception e) {
            log.error("userName = {}", (Object)userName);
            log.error("LockssDaemon.getLockssDaemon().getAccountManager().getUser(" + userName + ")", (Throwable)e);
            throw new AccessControlException("Unable to get user '" + userName + "'");
        }
        if (userAccount != null && !DebugPanel.noAuditActions.contains(action)) {
            userAccount.auditableEvent("Called AusApi web service operation '" + action + "' AU ID: " + auId);
        }
    }
}

