/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import org.lockss.laaws.config.api.AustatusesApiDelegate;
import org.lockss.laaws.config.impl.AuHelper;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.StringUtil;
import org.lockss.ws.entities.AuStatus;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AustatusesApiServiceImpl
extends BaseSpringApiServiceImpl
implements AustatusesApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();

    public ResponseEntity getAuStatus(String auId) {
        log.debug2("auId = {}", (Object)auId);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        if (StringUtil.isNullString((String)auId)) {
            String message = "Cannot getAuStatus() for auId = '" + auId + "': Invalid Archival Unit identifier.";
            log.error(message);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        try {
            AuStatus result = new AuHelper().getAuStatus(auId);
            log.debug2("result = " + result);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot getAuStatus() for auId = '" + auId + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

