/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.security.AccessControlException;
import org.lockss.account.UserAccount;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.config.api.AusubstancesApiDelegate;
import org.lockss.log.L4JLogger;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.servlet.DebugPanel;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.state.AuState;
import org.lockss.state.SubstanceChecker;
import org.lockss.util.StringUtil;
import org.lockss.ws.entities.CheckSubstanceResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AusubstancesApiServiceImpl
extends BaseSpringApiServiceImpl
implements AusubstancesApiDelegate {
    static final String MISSING_AU_ID_ERROR_MESSAGE = "Missing auId";
    static final String NO_SUBSTANCE_ERROR_MESSAGE = "No substance patterns defined for plugin";
    static final String NO_SUCH_AU_ERROR_MESSAGE = "No such Archival Unit";
    static final String UNEXPECTED_SUBSTANCE_CHECKER_ERROR_MESSAGE = "Error in SubstanceChecker; see log";
    private static L4JLogger log = L4JLogger.getLogger();

    @Override
    public ResponseEntity<CheckSubstanceResult> putAuSubstanceCheck(String auId) {
        log.debug2("auId = {}", (Object)auId);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        if (StringUtil.isNullString((String)auId)) {
            return new ResponseEntity((Object)new CheckSubstanceResult(auId, null, null, MISSING_AU_ID_ERROR_MESSAGE), (HttpStatusCode)HttpStatus.OK);
        }
        try {
            ArchivalUnit au = LockssDaemon.getLockssDaemon().getPluginManager().getAuFromId(auId);
            log.trace("au = {}", (Object)au);
            if (au == null) {
                return new ResponseEntity((Object)new CheckSubstanceResult(auId, null, null, NO_SUCH_AU_ERROR_MESSAGE), (HttpStatusCode)HttpStatus.OK);
            }
            SubstanceChecker subChecker = new SubstanceChecker(au);
            if (!subChecker.isEnabled()) {
                return new ResponseEntity((Object)new CheckSubstanceResult(auId, null, null, NO_SUBSTANCE_ERROR_MESSAGE), (HttpStatusCode)HttpStatus.OK);
            }
            AuState auState = AuUtil.getAuState((ArchivalUnit)au);
            log.trace("auState = {}", (Object)auState);
            SubstanceChecker.State oldState = null;
            if (auState != null) {
                oldState = auState.getSubstanceState();
                log.trace("oldState = {}", (Object)oldState);
            }
            SubstanceChecker.State newState = subChecker.findSubstance();
            log.trace("newState = {}", (Object)newState);
            String errorMessage = null;
            if (newState != null) {
                switch (newState) {
                    case Unknown: {
                        log.error("Shouldn't happen: SubstanceChecker returned Unknown");
                        errorMessage = UNEXPECTED_SUBSTANCE_CHECKER_ERROR_MESSAGE;
                        break;
                    }
                    case Yes: {
                        if (auState == null) break;
                        auState.setSubstanceState(SubstanceChecker.State.Yes);
                        break;
                    }
                    case No: {
                        if (auState == null) break;
                        auState.setSubstanceState(SubstanceChecker.State.No);
                    }
                }
            } else {
                log.error("Shouldn't happen: SubstanceChecker returned null");
                errorMessage = UNEXPECTED_SUBSTANCE_CHECKER_ERROR_MESSAGE;
            }
            CheckSubstanceResult result = new CheckSubstanceResult(auId, this.convertToWsState(oldState), this.convertToWsState(newState), errorMessage);
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot getAuSubstanceCheck() for auId = '" + auId + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void audit(String action, String auId) throws AccessControlException {
        log.debug2("action = {}", (Object)action);
        log.debug2("auId = {}", (Object)auId);
        String userName = SecurityContextHolder.getContext().getAuthentication().getName();
        log.trace("userName = {}", (Object)userName);
        UserAccount userAccount = null;
        try {
            userAccount = LockssDaemon.getLockssDaemon().getAccountManager().getUser(userName);
            log.trace("userAccount = {}", (Object)userAccount);
        }
        catch (Exception e) {
            log.error("userName = {}", (Object)userName);
            log.error("LockssDaemon.getLockssDaemon().getAccountManager().getUser(" + userName + ")", (Throwable)e);
            throw new AccessControlException("Unable to get user '" + userName + "'");
        }
        if (userAccount != null && !DebugPanel.noAuditActions.contains(action)) {
            userAccount.auditableEvent("Called AusApi web service operation '" + action + "' AU ID: " + auId);
        }
    }

    private CheckSubstanceResult.State convertToWsState(SubstanceChecker.State state) {
        if (state != null) {
            switch (state) {
                case Unknown: {
                    return CheckSubstanceResult.State.Unknown;
                }
                case Yes: {
                    return CheckSubstanceResult.State.Yes;
                }
                case No: {
                    return CheckSubstanceResult.State.No;
                }
            }
        }
        return null;
    }
}

