/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.io.IOException;
import java.security.AccessControlException;
import org.lockss.laaws.config.api.AususpecturlsApiDelegate;
import org.lockss.log.L4JLogger;
import org.lockss.plugin.AuUtil;
import org.lockss.spring.auth.AuthUtil;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.JsonUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AususpecturlsApiServiceImpl
extends BaseSpringApiServiceImpl
implements AususpecturlsApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();

    @Override
    public ResponseEntity<String> getAuSuspectUrlVersions(String auid) {
        log.debug2("auid = {}", (Object)auid);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            ResponseEntity<String> errorResponseEntity = this.validateAuid(auid);
            if (errorResponseEntity != null) {
                return errorResponseEntity;
            }
            String result = this.getStateManager().getAuSuspectUrlVersions(auid).toJson();
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get the suspect URL versions for auid = '" + auid + "'";
            log.error(message, (Throwable)iae);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, iae);
        }
        catch (Exception e) {
            String message = "Cannot get the suspect URL versions for auid = '" + auid + "'";
            log.error(message, (Throwable)e);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    public ResponseEntity putAuSuspectUrlVersions(String auid, String auSuspectUrlVersions, String xLockssRequestCookie) {
        log.debug2("auid = {}", (Object)auid);
        log.debug2("auSuspectUrlVersions = {}", (Object)auSuspectUrlVersions);
        log.debug2("xLockssRequestCookie = {}", (Object)xLockssRequestCookie);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return this.getErrorResponseEntity(HttpStatus.FORBIDDEN, null, ace);
        }
        try {
            ResponseEntity<String> errorResponseEntity = this.validateAuidAndAuSuspectUrlVersions(auid, auSuspectUrlVersions);
            if (errorResponseEntity != null) {
                return errorResponseEntity;
            }
            this.getStateManager().updateAuSuspectUrlVersionsFromJson(auid, auSuspectUrlVersions, xLockssRequestCookie);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot update the suspect URL versions for auid = '" + auid + "'";
            log.error(message, (Throwable)iae);
            log.error("auSuspectUrlVersions = {}", (Object)auSuspectUrlVersions);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, iae);
        }
        catch (Exception e) {
            String message = "Cannot update the suspect URL versions for auid = '" + auid + "'";
            log.error(message, (Throwable)e);
            log.error("auSuspectUrlVersions = {}", (Object)auSuspectUrlVersions);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, e);
        }
    }

    private ResponseEntity<String> validateAuid(String auid) {
        if (auid == null || auid.isEmpty()) {
            String message = "Invalid auId = '" + auid + "'";
            log.error(message);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, null);
        }
        return null;
    }

    private ResponseEntity<String> validateAuidAndAuSuspectUrlVersions(String auid, String auSuspectUrlVersions) throws IOException {
        ResponseEntity<String> errorResponseEntity = this.validateAuid(auid);
        if (errorResponseEntity != null) {
            return errorResponseEntity;
        }
        if (auSuspectUrlVersions == null || auSuspectUrlVersions.isEmpty()) {
            String message = "Invalid auSuspectUrlVersions = '" + auSuspectUrlVersions + "'";
            log.error(message);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, null);
        }
        String auIdInAuSuspectUrlVersions = AuUtil.auSuspectUrlVersionsFromJson((String)auSuspectUrlVersions).getAuid();
        if (auIdInAuSuspectUrlVersions != null && !auIdInAuSuspectUrlVersions.isEmpty() && !auIdInAuSuspectUrlVersions.equals(auid)) {
            String message = "Incompatible auId in auSuspectUrlVersions = '" + auSuspectUrlVersions + "'";
            log.error(message);
            log.error("auid = {}", (Object)auid);
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, message, null);
        }
        return null;
    }

    private ResponseEntity<String> getErrorResponseEntity(HttpStatus status, String message, Exception e) {
        Object errorMessage = message;
        if (e != null) {
            errorMessage = errorMessage == null ? e.getMessage() : (String)errorMessage + " - " + e.getMessage();
        }
        return new ResponseEntity((Object)JsonUtil.toJsonError((int)status.value(), (String)errorMessage), (HttpStatusCode)status);
    }
}

