/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.MalformedParametersException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.util.Supplier;
import org.lockss.app.LockssDaemon;
import org.lockss.config.ConfigFileReadWriteResult;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.config.HttpRequestPreconditions;
import org.lockss.config.RestConfigClient;
import org.lockss.laaws.config.api.ConfigApiDelegate;
import org.lockss.log.L4JLogger;
import org.lockss.spring.auth.AuthUtil;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.error.LockssRestServiceException;
import org.lockss.util.AccessType;
import org.lockss.util.BuildInfo;
import org.lockss.util.DaemonVersion;
import org.lockss.util.PlatformVersion;
import org.lockss.util.StringUtil;
import org.lockss.util.os.PlatformUtil;
import org.lockss.util.rest.repo.util.NamedInputStreamResource;
import org.lockss.util.time.TimeBase;
import org.lockss.ws.entities.DaemonVersionWsResult;
import org.lockss.ws.entities.JavaVersionWsResult;
import org.lockss.ws.entities.PlatformConfigurationWsResult;
import org.lockss.ws.entities.PlatformWsResult;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConfigApiServiceImpl
extends BaseSpringApiServiceImpl
implements ConfigApiDelegate {
    static final String SECTION_NAME_CLUSTER = "cluster";
    static final String SECTION_NAME_USER_CONFIG = "user-config";
    static final String SECTION_NAME_PROPSLOCKSS = "props_lockss";
    static final String SECTION_NAME_UI_IP_ACCESS = "ui_ip_access";
    static final String SECTION_NAME_PROXY_IP_ACCESS = "proxy_ip_access";
    static final String SECTION_NAME_PLUGIN = "plugin";
    static final String SECTION_NAME_AU = "au";
    static final String SECTION_NAME_TITLE_DB = "titledb";
    static final String SECTION_NAME_ICP_SERVER = "icp_server";
    static final String SECTION_NAME_AUDIT_PROXY = "audit_proxy";
    static final String SECTION_NAME_CONTENT_SERVERS = "content_servers";
    static final String SECTION_NAME_ACCESS_GROUPS = "access_groups";
    static final String SECTION_NAME_CRAWL_PROXY = "crawl_proxy";
    static final String SECTION_NAME_EXPERT = "expert";
    static final String SECTION_NAME_ALERT = "alert";
    static final String SECTION_NAME_CRONSTATE = "cronstate";
    static final String SECTION_NAME_MIGRATION = "migration";
    private static L4JLogger log = L4JLogger.getLogger();
    private static final Map<String, String> configWritableSectionMap = new HashMap<String, String>(){
        {
            this.put(ConfigApiServiceImpl.SECTION_NAME_UI_IP_ACCESS, "ui_ip_access.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_PROXY_IP_ACCESS, "proxy_ip_access.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_PLUGIN, "plugin.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_AU, "au.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_TITLE_DB, "titledb.xml");
            this.put(ConfigApiServiceImpl.SECTION_NAME_ICP_SERVER, "icp_server_config.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_AUDIT_PROXY, "audit_proxy_config.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_CONTENT_SERVERS, "content_servers_config.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_ACCESS_GROUPS, "access_groups_config.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_CRAWL_PROXY, "crawl_proxy.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_EXPERT, "expert_config.txt");
            this.put(ConfigApiServiceImpl.SECTION_NAME_ALERT, "alertconfig.xml");
            this.put(ConfigApiServiceImpl.SECTION_NAME_CRONSTATE, "cronstate.xml");
            this.put(ConfigApiServiceImpl.SECTION_NAME_MIGRATION, "v2_migration_config.txt");
        }
    };
    private static final String BUILD_TIMESTAMP_FORMAT = "dd-MMM-yy HH:mm:ss zzz";
    private Map<String, String> configReadOnlySectionMap = null;

    public ResponseEntity getSectionConfig(String sectionName, String ifMatch, String ifModifiedSince, String ifNoneMatch, String ifUnmodifiedSince) {
        String canonicalSectionName;
        HttpRequestPreconditions preconditions;
        log.debug2("sectionName = {}", new Supplier[]{() -> sectionName});
        log.debug2("ifMatch = {}", new Supplier[]{() -> ifMatch});
        log.debug2("ifModifiedSince = {}", new Supplier[]{() -> ifModifiedSince});
        log.debug2("ifNoneMatch = {}", new Supplier[]{() -> ifNoneMatch});
        log.debug2("ifUnmodifiedSince = {}", new Supplier[]{() -> ifUnmodifiedSince});
        String parsedRequest = String.format("sectionName: %s, ifMatch: %s, ifModifiedSince: %s, ifNoneMatch: %s, ifUnmodifiedSince: %s", sectionName, ifMatch, ifModifiedSince, ifNoneMatch, ifUnmodifiedSince);
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        if (!this.waitConfig()) {
            throw new LockssRestServiceException(HttpStatus.SERVICE_UNAVAILABLE, "Not ready", parsedRequest);
        }
        try {
            preconditions = new HttpRequestPreconditions((List)StringUtil.breakAt((String)ifMatch, (String)",", (boolean)true), ifModifiedSince, (List)StringUtil.breakAt((String)ifNoneMatch, (String)",", (boolean)true), ifUnmodifiedSince);
            log.trace("preconditions = {}", new Supplier[]{() -> preconditions});
        }
        catch (IllegalArgumentException iae) {
            throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, iae.getMessage(), parsedRequest);
        }
        try {
            canonicalSectionName = this.validateSectionName(sectionName, AccessType.READ);
            log.trace("canonicalSectionName = {}", new Supplier[]{() -> canonicalSectionName});
        }
        catch (MalformedParametersException mpe) {
            throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, mpe.getMessage(), parsedRequest);
        }
        ConfigManager configManager = ConfigManager.getConfigManager();
        String sectionUrl = this.getConfigReadOnlySectionMap().get(canonicalSectionName);
        if (log.isTraceEnabled()) {
            log.trace("Read-Only sectionUrl = {}", (Object)sectionUrl);
        }
        if (sectionUrl == null) {
            sectionUrl = new File(configManager.getCacheConfigDir(), configWritableSectionMap.get(canonicalSectionName)).toString();
            if (log.isTraceEnabled()) {
                log.trace("Writable sectionUrl = {}", (Object)sectionUrl);
            }
        }
        try {
            return this.buildGetUrlResponse(sectionUrl, preconditions, configManager.conditionallyReadCacheConfigFile(sectionUrl, preconditions));
        }
        catch (FileNotFoundException fnfe) {
            String message = "Can't get the content for sectionName '" + sectionName + "'";
            log.error(message, (Throwable)fnfe);
            throw new LockssRestServiceException(HttpStatus.NOT_FOUND, message, parsedRequest);
        }
        catch (IOException ioe) {
            String message = "Can't get the content for URL '" + sectionUrl + "'";
            log.error(message, (Throwable)ioe);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, message, parsedRequest);
        }
    }

    public ResponseEntity getUrlConfig(String url, String ifMatch, String ifModifiedSince, String ifNoneMatch, String ifUnmodifiedSince) {
        HttpRequestPreconditions preconditions;
        log.debug2("url = {}", new Supplier[]{() -> url});
        log.debug2("ifMatch = {}", new Supplier[]{() -> ifMatch});
        log.debug2("ifModifiedSince = {}", new Supplier[]{() -> ifModifiedSince});
        log.debug2("ifNoneMatch = {}", new Supplier[]{() -> ifNoneMatch});
        log.debug2("ifUnmodifiedSince = {}", new Supplier[]{() -> ifUnmodifiedSince});
        String parsedRequest = String.format("url: %s, ifMatch: %s, ifModifiedSince: %s, ifNoneMatch: %s, ifUnmodifiedSince: %s", url, ifMatch, ifModifiedSince, ifNoneMatch, ifUnmodifiedSince);
        log.debug2("Parsed request: {}", (Object)parsedRequest);
        if (!this.waitConfig()) {
            throw new LockssRestServiceException(HttpStatus.SERVICE_UNAVAILABLE, "Not ready", parsedRequest);
        }
        try {
            preconditions = new HttpRequestPreconditions((List)StringUtil.breakAt((String)ifMatch, (String)",", (boolean)true), ifModifiedSince, (List)StringUtil.breakAt((String)ifNoneMatch, (String)",", (boolean)true), ifUnmodifiedSince);
            log.trace("preconditions = {}", new Supplier[]{() -> preconditions});
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity((Object)iae.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        try {
            return this.buildGetUrlResponse(url, preconditions, ConfigManager.getConfigManager().conditionallyReadCacheConfigFile(url, preconditions));
        }
        catch (FileNotFoundException | ConnectException | UnknownHostException e) {
            String message = "Can't get the content for url '" + url + "'";
            log.debug(message + ": " + e);
            throw new LockssRestServiceException(HttpStatus.NOT_FOUND, message, parsedRequest);
        }
        catch (UnsupportedOperationException uoe) {
            String message = "Can't get the content for url '" + url + "'";
            log.error(message, (Throwable)uoe);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (IOException ioe) {
            String message = "Can't get the content for URL '" + url + "'";
            log.error(message, (Throwable)ioe);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<OffsetDateTime> getLastUpdateTime() {
        log.debug2("Invoked");
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            long millis = ConfigManager.getConfigManager().getLastUpdateTime();
            log.trace("millis = {}", new Supplier[]{() -> millis});
            Date result = new Date(millis);
            log.debug2("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot getLastUpdateTime()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)OffsetDateTime.ofInstant(null, null), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<List<String>> getLoadedUrlList() {
        log.debug2("Invoked");
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            List result = ConfigManager.getConfigManager().getLoadedUrlList();
            log.debug2("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot getLoadedUrlList()";
            log.error(message, (Throwable)e);
            throw new LockssRestServiceException(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public ResponseEntity putConfig(String sectionName, MultipartFile configFile, String ifMatch, String ifModifiedSince, String ifNoneMatch, String ifUnmodifiedSince) {
        String canonicalSectionName;
        HttpRequestPreconditions preconditions;
        log.debug2("sectionName = {}", new Supplier[]{() -> sectionName});
        log.debug2("configFile = {}", new Supplier[]{() -> configFile});
        log.debug2("ifMatch = {}", new Supplier[]{() -> ifMatch});
        log.debug2("ifModifiedSince = {}", new Supplier[]{() -> ifModifiedSince});
        log.debug2("ifNoneMatch = {}", new Supplier[]{() -> ifNoneMatch});
        log.debug2("ifUnmodifiedSince = {}", new Supplier[]{() -> ifUnmodifiedSince});
        if (!this.waitConfig(0L)) {
            return new ResponseEntity((Object)"Not Ready", (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"userAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            preconditions = new HttpRequestPreconditions((List)StringUtil.breakAt((String)ifMatch, (String)",", (boolean)true), ifModifiedSince, (List)StringUtil.breakAt((String)ifNoneMatch, (String)",", (boolean)true), ifUnmodifiedSince);
            log.trace("preconditions = {}", new Supplier[]{() -> preconditions});
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (configFile == null) {
            String message = "Invalid metadata modification specification: null";
            log.warn(message);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        try {
            canonicalSectionName = this.validateSectionName(sectionName, AccessType.WRITE);
            log.trace("canonicalSectionName = {}", new Supplier[]{() -> canonicalSectionName});
        }
        catch (MalformedParametersException mpe) {
            throw new LockssRestServiceException(HttpStatus.BAD_REQUEST, mpe.getMessage());
        }
        try {
            ConfigManager configManager = ConfigManager.getConfigManager();
            String sectionUrl = configWritableSectionMap.get(canonicalSectionName);
            log.trace("sectionUrl = {}", new Supplier[]{() -> sectionUrl});
            String filename = new File(configManager.getCacheConfigDir(), sectionUrl).toString();
            log.trace("filename = {}", new Supplier[]{() -> filename});
            ConfigFileReadWriteResult writeResult = configManager.conditionallyWriteCacheConfigFile(filename, preconditions, configFile.getInputStream());
            if (!writeResult.isPreconditionsMet()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
            }
            String lastModified = writeResult.getLastModified();
            log.trace("lastModified = {}", new Supplier[]{() -> lastModified});
            String etag = writeResult.getEtag();
            log.trace("etag = {}", new Supplier[]{() -> etag});
            HttpHeaders responseHeaders = new HttpHeaders();
            this.setLastModified(responseHeaders, lastModified);
            this.setETag(responseHeaders, etag);
            log.trace("responseHeaders = {}", new Supplier[]{() -> responseHeaders});
            return new ResponseEntity(null, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot putConfig() for sectionName = '" + sectionName + "', configFile = '" + configFile + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Void> putConfigReload() {
        log.debug2("Invoked");
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"userAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ConfigManager.getConfigManager().requestReload();
            log.debug2("Done");
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot requestReload()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getPlatformConfig() {
        log.debug2("Invoked.");
        if (!this.waitConfig()) {
            return new ResponseEntity((Object)"Not Ready", (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        PlatformConfigurationWsResult result = new PlatformConfigurationWsResult();
        try {
            LockssDaemon theDaemon = LockssDaemon.getLockssDaemon();
            Configuration config = ConfigManager.getCurrentConfig();
            result.setHostName(config.get("org.lockss.platform.fqdn"));
            result.setIpAddress(config.get("org.lockss.platform.localIPAddress"));
            result.setGroups(config.getPlatformGroupList());
            result.setProject(config.get("org.lockss.platform.project"));
            result.setV3Identity(config.get("org.lockss.platform.v3.identity"));
            String smtpHost = config.get("org.lockss.platform.smtphost");
            if (smtpHost != null) {
                int smtpPort = config.getInt("org.lockss.platform.smtpport", 25);
                result.setMailRelay(smtpHost + ":" + smtpPort);
            }
            result.setAdminEmail(config.get("org.lockss.platform.sysadminemail"));
            result.setDisks(config.getList("org.lockss.platform.diskSpacePaths"));
            result.setCurrentTime(TimeBase.nowMs());
            result.setUptime(TimeBase.msSince((long)theDaemon.getStartDate().getTime()));
            DaemonVersion daemonVersion = ConfigManager.getDaemonVersion();
            DaemonVersionWsResult daemonVersionResult = new DaemonVersionWsResult();
            daemonVersionResult.setFullVersion(daemonVersion.displayString());
            daemonVersionResult.setMajorVersion(daemonVersion.getMajorVersion());
            daemonVersionResult.setMinorVersion(daemonVersion.getMinorVersion());
            daemonVersionResult.setBuildVersion(daemonVersion.getBuildVersion());
            result.setDaemonVersion(daemonVersionResult);
            JavaVersionWsResult javaVersionResult = new JavaVersionWsResult();
            Properties sprops = System.getProperties();
            javaVersionResult.setVersion(sprops.getProperty("java.version"));
            javaVersionResult.setSpecificationVersion(sprops.getProperty("java.specification.version"));
            javaVersionResult.setRuntimeVersion(sprops.getProperty("java.runtime.version"));
            javaVersionResult.setRuntimeName(sprops.getProperty("java.runtime.name"));
            result.setJavaVersion(javaVersionResult);
            PlatformVersion platformVersion = Configuration.getPlatformVersion();
            PlatformWsResult platform = new PlatformWsResult();
            if (platformVersion != null) {
                platform.setName(platformVersion.getName());
                platform.setVersion(platformVersion.getVersion());
                platform.setSuffix(platformVersion.getSuffix());
                result.setPlatform(platform);
            }
            result.setCurrentWorkingDirectory(PlatformUtil.getCwd());
            result.setProperties(ConfigManager.getConfigManager().getConfigUrlList());
            result.setBuildHost(BuildInfo.getBuildProperty((String)"build.host"));
            result.setBuildTimestamp(this.getBuildTimestamp());
            log.debug2("result = {}", (Object)result);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot getPlatformConfig()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected String validateSectionName(String sectionName, AccessType access) throws MalformedParametersException {
        log.debug2("sectionName = {}", new Supplier[]{() -> sectionName});
        log.debug2("access = {}", new Supplier[]{() -> access});
        if (sectionName == null || sectionName.isEmpty()) {
            String message = "Invalid sectionName '" + sectionName + "'";
            log.warn(message);
            throw new MalformedParametersException(message);
        }
        String canonicalVersion = sectionName.toLowerCase();
        log.trace("canonicalVersion = {}", new Supplier[]{() -> canonicalVersion});
        if (!configWritableSectionMap.containsKey(canonicalVersion) && !this.getConfigReadOnlySectionMap().containsKey(canonicalVersion)) {
            String message = "Invalid sectionName '" + sectionName + "'";
            log.warn(message);
            throw new MalformedParametersException(message);
        }
        if (access == AccessType.WRITE && !configWritableSectionMap.containsKey(canonicalVersion)) {
            String message = "Invalid writing operation on sectionName '" + sectionName + "'";
            log.warn(message);
            throw new MalformedParametersException(message);
        }
        return canonicalVersion;
    }

    private Map<String, String> getConfigReadOnlySectionMap() {
        if (this.configReadOnlySectionMap == null) {
            HashMap<String, String> tmpmap = new HashMap<String, String>();
            tmpmap.put(SECTION_NAME_CLUSTER, "dyn:cluster.xml");
            tmpmap.put(SECTION_NAME_USER_CONFIG, "dyn:user-config.xml");
            this.configReadOnlySectionMap = tmpmap;
            log.trace("configReadOnlySectionMap = {}", new Supplier[]{() -> this.configReadOnlySectionMap});
        }
        return this.configReadOnlySectionMap;
    }

    private ResponseEntity<?> buildGetUrlResponse(String url, HttpRequestPreconditions preconditions, ConfigFileReadWriteResult readResult) {
        log.debug2("url = {}", new Supplier[]{() -> url});
        log.debug2("preconditions = {}", new Supplier[]{() -> preconditions});
        log.debug2("readResult = {}", new Supplier[]{() -> readResult});
        String lastModified = readResult.getLastModified();
        log.trace("lastModified = {}", new Supplier[]{() -> lastModified});
        String etag = readResult.getEtag();
        log.trace("etag = {}", new Supplier[]{() -> etag});
        if (!readResult.isPreconditionsMet()) {
            if (preconditions.getIfModifiedSince() != null && !preconditions.getIfModifiedSince().isEmpty() || preconditions.getIfNoneMatch() != null && !preconditions.getIfNoneMatch().isEmpty()) {
                HttpHeaders responseHeaders = new HttpHeaders();
                this.setLastModified(responseHeaders, lastModified);
                this.setETag(responseHeaders, etag);
                log.trace("responseHeaders = {}", new Supplier[]{() -> responseHeaders});
                HttpStatus status = HttpStatus.NOT_MODIFIED;
                log.trace("status = {}", new Supplier[]{() -> status});
                return new ResponseEntity(null, (MultiValueMap)responseHeaders, (HttpStatusCode)status);
            }
            HttpStatus status = HttpStatus.PRECONDITION_FAILED;
            log.trace("status = {}", new Supplier[]{() -> status});
            return new ResponseEntity(null, null, (HttpStatusCode)status);
        }
        HttpHeaders partHeaders = new HttpHeaders();
        this.setLastModified(partHeaders, lastModified);
        this.setETag(partHeaders, etag);
        MediaType contentType = readResult.getContentType();
        log.trace("contentType = {}", new Supplier[]{() -> contentType});
        partHeaders.setContentType(contentType);
        long contentLength = readResult.getContentLength();
        log.trace("contentLength = {}", new Supplier[]{() -> contentLength});
        partHeaders.setContentLength(contentLength);
        log.trace("partHeaders = {}", new Supplier[]{() -> partHeaders});
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        NamedInputStreamResource resource = new NamedInputStreamResource(RestConfigClient.CONFIG_PART_NAME, readResult.getInputStream());
        parts.add((Object)RestConfigClient.CONFIG_PART_NAME, (Object)new HttpEntity((Object)resource, (MultiValueMap)partHeaders));
        log.trace("parts = {}", new Supplier[]{() -> ConfigApiServiceImpl.lambda$buildGetUrlResponse$44((MultiValueMap)parts)});
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        log.trace("responseHeaders = {}", new Supplier[]{() -> responseHeaders});
        HttpStatus status = HttpStatus.OK;
        log.trace("status = {}", new Supplier[]{() -> status});
        return new ResponseEntity((Object)parts, (MultiValueMap)responseHeaders, (HttpStatusCode)status);
    }

    protected void setETag(HttpHeaders hdrs, String etag) {
        if (etag != null) {
            hdrs.setETag(etag);
        }
    }

    protected void setLastModified(HttpHeaders hdrs, String last) {
        if (last != null) {
            hdrs.set("Last-Modified", last);
        }
    }

    protected long getBuildTimestamp() throws ParseException {
        log.debug2("Invoked.");
        try {
            long timestamp = new SimpleDateFormat(BUILD_TIMESTAMP_FORMAT).parse(BuildInfo.getBuildProperty((String)"build.timestamp")).getTime();
            log.debug2("timestamp = {}", (Object)timestamp);
            return timestamp;
        }
        catch (ParseException pe) {
            log.error("Caught ParseException", (Throwable)pe);
            log.error("BuildInfo.getBuildProperty(BUILD_TIMESTAMP)) = '" + BuildInfo.getBuildProperty((String)"build.timestamp") + "'");
            throw pe;
        }
    }

    private static /* synthetic */ Object lambda$buildGetUrlResponse$44(MultiValueMap parts) {
        return parts;
    }
}

