/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.config.impl.PluginWsSource;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.util.Logger;
import org.lockss.ws.entities.PluginWsResult;

public class PluginHelper {
    static String SOURCE_FQCN = PluginWsSource.class.getCanonicalName();
    static String RESULT_FQCN = PluginWsResult.class.getCanonicalName();
    static String PLUGIN_ID = "pluginId";
    static String NAME = "name";
    static String VERSION = "version";
    static String TYPE = "type";
    static String DEFINITION = "definition";
    static String REGISTRY = "registry";
    static String URL = "url";
    static String AU_COUNT = "auCount";
    static String PUBLISHING_PLATFORM = "publishingPlatform";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(PLUGIN_ID);
            this.add(NAME);
            this.add(VERSION);
            this.add(TYPE);
            this.add(DEFINITION);
            this.add(REGISTRY);
            this.add(URL);
            this.add(AU_COUNT);
            this.add(PUBLISHING_PLATFORM);
        }
    };
    private static Logger log = Logger.getLogger();

    List<PluginWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        Collection allPlugins = ((PluginManager)LockssDaemon.getManager((String)LockssDaemon.PLUGIN_MANAGER)).getRegisteredPlugins();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): allPlugins.size() = " + allPlugins.size());
        }
        ArrayList<PluginWsSource> universe = new ArrayList<PluginWsSource>(allPlugins.size());
        for (Plugin plugin : allPlugins) {
            universe.add(new PluginWsSource(plugin));
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<PluginWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (PluginWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(PluginWsResult result) {
        StringBuilder builder = new StringBuilder("PluginWsResult [");
        boolean isFirst = true;
        if (result.getPluginId() != null) {
            builder.append("pluginId=").append(result.getPluginId());
            isFirst = false;
        }
        if (result.getName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("name=").append(result.getName());
        }
        if (result.getVersion() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("version=").append(result.getVersion());
        }
        if (result.getType() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("type=").append(result.getType());
        }
        if (result.getDefinition() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("definition=").append(result.getDefinition());
        }
        if (result.getRegistry() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("registry=").append(result.getRegistry());
        }
        if (result.getUrl() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("url=").append(result.getUrl());
        }
        if (result.getAuCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("auCount=").append(result.getAuCount());
        }
        if (result.getPublishingPlatform() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("publishingPlatform=").append(result.getPublishingPlatform());
        }
        return builder.append("]").toString();
    }
}

