/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.lockss.app.LockssDaemon;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.plugin.definable.DefinablePlugin;
import org.lockss.util.ExternalizableMap;
import org.lockss.ws.entities.PluginWsResult;

public class PluginWsSource
extends PluginWsResult {
    private Plugin plugin;
    private boolean pluginIdPopulated = false;
    private boolean namePopulated = false;
    private boolean versionPopulated = false;
    private boolean typePopulated = false;
    private boolean definitionPopulated = false;
    private boolean registryPopulated = false;
    private boolean urlPopulated = false;
    private boolean auCountPopulated = false;
    private boolean publishingPlatformPopulated = false;
    private LockssDaemon theDaemon = null;
    private PluginManager pluginMgr = null;
    private PluginManager.PluginInfo pluginInfo = null;

    public PluginWsSource(Plugin plugin) {
        this.plugin = plugin;
    }

    public String getPluginId() {
        if (!this.pluginIdPopulated) {
            this.setPluginId(this.plugin.getPluginId());
            this.pluginIdPopulated = true;
        }
        return super.getPluginId();
    }

    public String getName() {
        if (!this.namePopulated) {
            this.setName(this.plugin.getPluginName());
            this.namePopulated = true;
        }
        return super.getName();
    }

    public String getVersion() {
        if (!this.versionPopulated) {
            this.setVersion(this.plugin.getVersion());
            this.versionPopulated = true;
        }
        return super.getVersion();
    }

    public String getType() {
        if (!this.typePopulated) {
            this.setType(this.getPluginManager().getPluginType(this.plugin));
            this.typePopulated = true;
        }
        return super.getType();
    }

    public Map<String, String> getDefinition() {
        if (!this.definitionPopulated) {
            ExternalizableMap eMap;
            if (this.plugin instanceof DefinablePlugin && (eMap = ((DefinablePlugin)this.plugin).getDefinitionMap()).size() > 0) {
                HashMap<String, String> result = new HashMap<String, String>();
                for (Map.Entry entry : eMap.entrySet()) {
                    result.put((String)entry.getKey(), entry.getValue().toString());
                }
                this.setDefinition(result);
            }
            this.definitionPopulated = true;
        }
        return super.getDefinition();
    }

    public String getRegistry() {
        if (!this.registryPopulated) {
            ArchivalUnit au;
            if (this.getPluginInfo() != null && (au = this.pluginInfo.getRegistryAu()) != null) {
                this.setRegistry(au.getName());
            }
            this.registryPopulated = true;
        }
        return super.getRegistry();
    }

    public String getUrl() {
        if (!this.urlPopulated) {
            String infoCuUrl;
            if (this.getPluginInfo() != null && (infoCuUrl = this.pluginInfo.getCuUrl()) != null) {
                this.setUrl(infoCuUrl);
            }
            this.urlPopulated = true;
        }
        return super.getUrl();
    }

    public Integer getAuCount() {
        if (!this.auCountPopulated) {
            Collection allAus = this.plugin.getAllAus();
            if (allAus != null) {
                this.setAuCount(allAus.size());
            }
            this.auCountPopulated = true;
        }
        return super.getAuCount();
    }

    public String getPublishingPlatform() {
        if (!this.publishingPlatformPopulated) {
            this.setPublishingPlatform(this.plugin.getPublishingPlatform());
            this.publishingPlatformPopulated = true;
        }
        return super.getPublishingPlatform();
    }

    private PluginManager.PluginInfo getPluginInfo() {
        if (this.pluginInfo == null && this.getPluginManager().isLoadablePlugin(this.plugin)) {
            this.pluginInfo = this.pluginMgr.getLoadablePluginInfo(this.plugin);
        }
        return this.pluginInfo;
    }

    private PluginManager getPluginManager() {
        if (this.pluginMgr == null) {
            this.pluginMgr = this.getTheDaemon().getPluginManager();
        }
        return this.pluginMgr;
    }

    private LockssDaemon getTheDaemon() {
        if (this.theDaemon == null) {
            this.theDaemon = LockssDaemon.getLockssDaemon();
        }
        return this.theDaemon;
    }
}

