/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.config.TdbAu;
import org.lockss.config.TdbUtil;
import org.lockss.laaws.config.impl.TdbAuWsSource;
import org.lockss.util.Logger;
import org.lockss.ws.entities.TdbAuWsResult;

public class TdbAuHelper {
    static String SOURCE_FQCN = TdbAuWsSource.class.getCanonicalName();
    static String RESULT_FQCN = TdbAuWsResult.class.getCanonicalName();
    static String AU_ID = "auId";
    static String NAME = "name";
    static String PLUGIN_NAME = "pluginName";
    static String TDB_TITLE = "tdbTitle";
    static String TDB_PUBLISHER = "tdbPublisher";
    static String DOWN = "down";
    static String ACTIVE = "active";
    static String PARAMS = "params";
    static String ATTRS = "attrs";
    static String PROPS = "props";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(AU_ID);
            this.add(NAME);
            this.add(PLUGIN_NAME);
            this.add(TDB_TITLE);
            this.add(TDB_PUBLISHER);
            this.add(DOWN);
            this.add(ACTIVE);
            this.add(PARAMS);
            this.add(ATTRS);
            this.add(PROPS);
        }
    };
    private static Logger log = Logger.getLogger();

    List<TdbAuWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        Set allTdbAuIds = TdbUtil.getTdb().getAllTdbAuIds();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): allTdbAuIds.size() = " + allTdbAuIds.size());
        }
        ArrayList<TdbAuWsSource> universe = new ArrayList<TdbAuWsSource>(allTdbAuIds.size());
        for (TdbAu.Id tdbAuId : allTdbAuIds) {
            universe.add(new TdbAuWsSource(tdbAuId));
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<TdbAuWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (TdbAuWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(TdbAuWsResult result) {
        StringBuilder builder = new StringBuilder("TdbAuWsResult [");
        boolean isFirst = true;
        if (result.getAuId() != null) {
            builder.append("auId=").append(result.getAuId());
            isFirst = false;
        }
        if (result.getName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("name=").append(result.getName());
        }
        if (result.getPluginName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pluginName=").append(result.getPluginName());
        }
        if (result.getTdbTitle() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tdbTitle=").append(result.getTdbTitle());
        }
        if (result.getTdbPublisher() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tdbPublisher=").append(result.getTdbPublisher());
        }
        if (result.getDown() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("down=").append(result.getDown());
        }
        if (result.getActive() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("active=").append(result.getActive());
        }
        if (result.getParams() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("params=").append(result.getParams());
        }
        if (result.getAttrs() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("attrs=").append(result.getAttrs());
        }
        if (result.getProps() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("props=").append(result.getProps());
        }
        return builder.append("]").toString();
    }
}

