/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.config.TdbPublisher;
import org.lockss.config.TdbUtil;
import org.lockss.laaws.config.impl.TdbPublisherWsSource;
import org.lockss.util.Logger;
import org.lockss.ws.entities.TdbPublisherWsResult;

public class TdbPublisherHelper {
    static String SOURCE_FQCN = TdbPublisherWsSource.class.getCanonicalName();
    static String RESULT_FQCN = TdbPublisherWsResult.class.getCanonicalName();
    static String NAME = "name";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(NAME);
        }
    };
    private static Logger log = Logger.getLogger();

    List<TdbPublisherWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        Collection allTdbPublishers = TdbUtil.getTdb().getAllTdbPublishers().values();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): allTdbPublishers.size() = " + allTdbPublishers.size());
        }
        ArrayList<TdbPublisherWsSource> universe = new ArrayList<TdbPublisherWsSource>(allTdbPublishers.size());
        for (TdbPublisher tdbPublisher : allTdbPublishers) {
            universe.add(new TdbPublisherWsSource(tdbPublisher));
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<TdbPublisherWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (TdbPublisherWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(TdbPublisherWsResult result) {
        StringBuilder builder = new StringBuilder("TdbPublisherWsResult [");
        if (result.getName() != null) {
            builder.append("name=").append(result.getName());
        }
        return builder.append("]").toString();
    }
}

