/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.config.TdbTitle;
import org.lockss.config.TdbUtil;
import org.lockss.laaws.config.impl.TdbTitleWsSource;
import org.lockss.util.Logger;
import org.lockss.ws.entities.TdbTitleWsResult;

public class TdbTitleHelper {
    static String SOURCE_FQCN = TdbTitleWsSource.class.getCanonicalName();
    static String RESULT_FQCN = TdbTitleWsResult.class.getCanonicalName();
    static String NAME = "name";
    static String TDB_PUBLISHER = "tdbPublisher";
    static String ID = "id";
    static String PROPRIETARY_ID = "proprietaryId";
    static String PROPRIETARY_IDS = "proprietaryIds";
    static String PUBLICATION_TYPE = "publicationType";
    static String ISSN = "issn";
    static String ISSN_L = "issnL";
    static String E_ISSN = "eIssn";
    static String PRINT_ISSN = "printIssn";
    static String ISSNS = "issns";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(NAME);
            this.add(TDB_PUBLISHER);
            this.add(ID);
            this.add(PROPRIETARY_ID);
            this.add(PROPRIETARY_IDS);
            this.add(PUBLICATION_TYPE);
            this.add(ISSN);
            this.add(ISSN_L);
            this.add(E_ISSN);
            this.add(PRINT_ISSN);
            this.add(ISSNS);
        }
    };
    private static Logger log = Logger.getLogger();

    List<TdbTitleWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        List allTdbTitles = TdbUtil.getAllTdbTitles();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): allTdbTitles.size() = " + allTdbTitles.size());
        }
        ArrayList<TdbTitleWsSource> universe = new ArrayList<TdbTitleWsSource>(allTdbTitles.size());
        for (TdbTitle tdbTitle : allTdbTitles) {
            universe.add(new TdbTitleWsSource(tdbTitle));
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<TdbTitleWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (TdbTitleWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(TdbTitleWsResult result) {
        StringBuilder builder = new StringBuilder("TdbTitleWsResult [");
        boolean isFirst = true;
        if (result.getName() != null) {
            builder.append("name=").append(result.getName());
            isFirst = false;
        }
        if (result.getTdbPublisher() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("tdbPublisher=").append(result.getTdbPublisher());
        }
        if (result.getId() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("id=").append(result.getId());
        }
        if (result.getProprietaryId() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("proprietaryId=").append(result.getProprietaryId());
        }
        if (result.getProprietaryIds() != null && result.getProprietaryIds().size() > 0) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("proprietaryIds=").append(result.getProprietaryIds());
        }
        if (result.getPublicationType() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("publicationType=").append(result.getPublicationType());
        }
        if (result.getIssn() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("issn=").append(result.getIssn());
        }
        if (result.getIssnL() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("issnL=").append(result.getIssnL());
        }
        if (result.getEIssn() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("eIssn=").append(result.getEIssn());
        }
        if (result.getPrintIssn() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("printIssn=").append(result.getPrintIssn());
        }
        if (result.getIssns() != null && result.getIssns().size() > 0) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("issns=").append(result.getIssns());
        }
        return builder.append("]").toString();
    }
}

