/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.lockss.account.UserAccount;
import org.lockss.laaws.config.api.UsersApiDelegate;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UsersApiServiceImpl
extends BaseSpringApiServiceImpl
implements UsersApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    @Autowired
    private ObjectMapper objMapper;

    @Override
    public ResponseEntity<String> addUserAccounts(String userAccountsJson) {
        try {
            UserAccount[] userAccounts = (UserAccount[])UserAccount.getUserAccountObjectMapper().readerFor(UserAccount[].class).readValue(userAccountsJson);
            if (userAccounts == null) {
                log.error("User accounts missing from request");
                return ResponseEntity.badRequest().build();
            }
            ArrayList<UserAccount> successfullyAdded = new ArrayList<UserAccount>();
            for (UserAccount acct : userAccounts) {
                try {
                    this.getStateManager().storeUserAccount(acct);
                    successfullyAdded.add(acct);
                }
                catch (IOException e) {
                    log.error("Could not add user account: {}", (Object)acct);
                }
            }
            ObjectWriter objWriter = UserAccount.getUserAccountObjectWriter();
            return ResponseEntity.ok((Object)objWriter.writeValueAsString(successfullyAdded));
        }
        catch (JsonProcessingException e) {
            log.error("Error deserializing user account", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
    }

    @Override
    public ResponseEntity<String> getUserAccount(String username) {
        try {
            UserAccount acct = this.getStateManager().getUserAccount(username);
            if (acct == null) {
                log.warn("User not found");
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)acct.toJson());
        }
        catch (JsonProcessingException e) {
            log.error("Could not serialize user account", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        catch (IOException e) {
            log.error("Could not get user account", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Override
    public ResponseEntity<Void> removeUserAccount(String username) {
        try {
            UserAccount acct = this.getStateManager().getUserAccount(username);
            this.getStateManager().removeUserAccount(acct);
            return ResponseEntity.ok().build();
        }
        catch (IOException e) {
            log.error("Could not remove user account", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Override
    public ResponseEntity<String> updateUserAccount(String username, String userAccountUpdates, String cookie) {
        try {
            UserAccount result = this.getStateManager().updateUserAccountFromJson(username, userAccountUpdates, cookie);
            if (result == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)result.toJson());
        }
        catch (JsonProcessingException e) {
            log.error("Could not serialize user account", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
        catch (IOException e) {
            log.error("Could not update user account", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }
}

