/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.config.impl;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryResults;
import org.lockss.app.LockssDaemon;
import org.lockss.config.Configuration;
import org.lockss.daemon.TitleConfig;
import org.lockss.laaws.config.api.WsApiDelegate;
import org.lockss.laaws.config.impl.AuHelper;
import org.lockss.laaws.config.impl.PluginHelper;
import org.lockss.laaws.config.impl.TdbAuHelper;
import org.lockss.laaws.config.impl.TdbPublisherHelper;
import org.lockss.laaws.config.impl.TdbTitleHelper;
import org.lockss.log.L4JLogger;
import org.lockss.remote.RemoteApi;
import org.lockss.spring.auth.AuthUtil;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.StringUtil;
import org.lockss.util.josql.JosqlUtil;
import org.lockss.ws.entities.ContentConfigurationResult;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class WsApiServiceImpl
extends BaseSpringApiServiceImpl
implements WsApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();

    public ResponseEntity postAus(List<String> auIds) {
        log.debug2("auIds = " + auIds);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ArrayList<ContentConfigurationResult> results = new ArrayList<ContentConfigurationResult>(auIds.size());
            RemoteApi remoteApi = LockssDaemon.getLockssDaemon().getRemoteApi();
            LinkedList<String> auids = new LinkedList<String>();
            HashMap<String, Configuration> titleConfigs = new HashMap<String, Configuration>();
            for (String auId : auIds) {
                TitleConfig titleConfig = remoteApi.findTitleConfig(auId);
                if (titleConfig == null) continue;
                auids.add(auId);
                titleConfigs.put(auId, titleConfig.getConfig());
            }
            String[] auIdArray = auids.toArray(new String[0]);
            RemoteApi.BatchAuStatus status = remoteApi.batchAddAus(1, auIdArray, null, null, titleConfigs, new HashMap(), null);
            int index = 0;
            for (RemoteApi.BatchAuStatus.Entry entry : status.getUnsortedStatusList()) {
                RemoteApi.BatchAuStatus entryStatus = new RemoteApi.BatchAuStatus();
                entryStatus.add(entry);
                ContentConfigurationResult result = null;
                if (entry.isOk()) {
                    log.debug("Success configuring AU '" + entry.getName() + "': " + entry.getExplanation());
                    result = new ContentConfigurationResult(auIdArray[index++], entry.getName(), Boolean.TRUE, entry.getExplanation());
                } else {
                    log.error("Error configuring AU '" + entry.getName() + "': " + entry.getExplanation());
                    result = new ContentConfigurationResult(auIdArray[index++], entry.getName(), Boolean.FALSE, entry.getExplanation());
                }
                results.add(result);
            }
            log.debug2("results = " + results);
            return new ResponseEntity(results, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot postAus()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity putAusDeactivate(List<String> auIds) {
        log.debug2("auIds = " + auIds);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ArrayList<ContentConfigurationResult> results = new ArrayList<ContentConfigurationResult>(auIds.size());
            RemoteApi.BatchAuStatus status = LockssDaemon.getLockssDaemon().getRemoteApi().deactivateAus(auIds);
            for (int i = 0; i < status.getUnsortedStatusList().size(); ++i) {
                Object explanation;
                String auId = auIds.get(i);
                RemoteApi.BatchAuStatus.Entry statusEntry = (RemoteApi.BatchAuStatus.Entry)status.getUnsortedStatusList().get(i);
                if (statusEntry.isOk() || "Deactivated".equals(statusEntry.getStatus())) {
                    log.debug("Success deactivating AU '" + statusEntry.getName() + "': " + statusEntry.getExplanation());
                    explanation = statusEntry.getExplanation();
                    if (StringUtil.isNullString((String)explanation)) {
                        explanation = "Deactivated Archival Unit '" + auId + "'";
                    }
                    results.add(new ContentConfigurationResult(auId, statusEntry.getName(), Boolean.TRUE, statusEntry.getExplanation()));
                    continue;
                }
                log.error("Error deactivating AU '" + statusEntry.getName() + "': " + statusEntry.getExplanation());
                explanation = statusEntry.getExplanation();
                if (StringUtil.isNullString((String)explanation)) {
                    explanation = statusEntry.getStatus();
                }
                results.add(new ContentConfigurationResult(auId, statusEntry.getName(), Boolean.FALSE, (String)explanation));
            }
            log.debug2("results = " + results);
            return new ResponseEntity(results, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot putAusDeactivate()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity putAusReactivate(List<String> auIds) {
        log.debug2("auIds = " + auIds);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ArrayList<ContentConfigurationResult> results = new ArrayList<ContentConfigurationResult>(auIds.size());
            RemoteApi.BatchAuStatus status = null;
            status = LockssDaemon.getLockssDaemon().getRemoteApi().reactivateAus(auIds);
            for (int i = 0; i < status.getUnsortedStatusList().size(); ++i) {
                Object explanation;
                String auId = auIds.get(i);
                RemoteApi.BatchAuStatus.Entry statusEntry = (RemoteApi.BatchAuStatus.Entry)status.getUnsortedStatusList().get(i);
                if (statusEntry.isOk() || "Added".equals(statusEntry.getStatus())) {
                    log.debug("Success reactivating AU '" + statusEntry.getName() + "': " + statusEntry.getExplanation());
                    explanation = statusEntry.getExplanation();
                    if (StringUtil.isNullString((String)explanation)) {
                        explanation = "Reactivated Archival Unit '" + auId + "'";
                    }
                    results.add(new ContentConfigurationResult(auId, statusEntry.getName(), Boolean.TRUE, statusEntry.getExplanation()));
                    continue;
                }
                log.error("Error reactivating AU '" + statusEntry.getName() + "': " + statusEntry.getExplanation());
                explanation = statusEntry.getExplanation();
                if (StringUtil.isNullString((String)explanation)) {
                    explanation = statusEntry.getStatus();
                }
                results.add(new ContentConfigurationResult(auId, statusEntry.getName(), Boolean.FALSE, (String)explanation));
            }
            log.debug2("results = " + results);
            return new ResponseEntity(results, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot putAusReactivate()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity deleteAusDelete(List<String> auIds) {
        log.debug2("auIds = " + auIds);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"auAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ArrayList<ContentConfigurationResult> results = new ArrayList<ContentConfigurationResult>(auIds.size());
            RemoteApi.BatchAuStatus status = LockssDaemon.getLockssDaemon().getRemoteApi().deleteAus(auIds);
            for (int i = 0; i < status.getUnsortedStatusList().size(); ++i) {
                Object explanation;
                String auId = auIds.get(i);
                RemoteApi.BatchAuStatus.Entry statusEntry = (RemoteApi.BatchAuStatus.Entry)status.getUnsortedStatusList().get(i);
                if (statusEntry.isOk() || "Deleted".equals(statusEntry.getStatus())) {
                    if (log.isDebugEnabled()) {
                        log.debug("Success unconfiguring AU '" + statusEntry.getName() + "': " + statusEntry.getExplanation());
                    }
                    if (StringUtil.isNullString((String)(explanation = statusEntry.getExplanation()))) {
                        explanation = "Deleted Archival Unit '" + auId + "'";
                    }
                    results.add(new ContentConfigurationResult(auId, statusEntry.getName(), Boolean.TRUE, statusEntry.getExplanation()));
                    continue;
                }
                log.error("Error unconfiguring AU '" + statusEntry.getName() + "': " + statusEntry.getExplanation());
                explanation = statusEntry.getExplanation();
                if (StringUtil.isNullString((String)explanation)) {
                    explanation = statusEntry.getStatus();
                }
                results.add(new ContentConfigurationResult(auId, statusEntry.getName(), Boolean.FALSE, (String)explanation));
            }
            log.debug2("results = {}", results);
            return new ResponseEntity(results, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot putAusReactivate()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getAuqueries(String auQuery) {
        log.debug2("auQuery = {}", (Object)auQuery);
        AuHelper auHelper = new AuHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)auQuery, (String)AuHelper.SOURCE_FQCN, AuHelper.PROPERTY_NAMES, (String)AuHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(auHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}", (Object)results.size());
                log.trace("results = {}", (Object)auHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getAuqueries() for auQuery = '" + auQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getAuqueries() for auQuery = '" + auQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getPlugins(String pluginQuery) {
        log.debug2("pluginQuery = {}", (Object)pluginQuery);
        PluginHelper pluginHelper = new PluginHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)pluginQuery, (String)PluginHelper.SOURCE_FQCN, PluginHelper.PROPERTY_NAMES, (String)PluginHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(pluginHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}" + results.size());
                log.trace("results = {}", (Object)pluginHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getTdbTitles() for pluginQuery = '" + pluginQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getTdbTitles() for pluginQuery = '" + pluginQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getTdbAus(String tdbAuQuery) {
        log.debug2("tdbAuQuery = {}", (Object)tdbAuQuery);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        TdbAuHelper tdbAuHelper = new TdbAuHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)tdbAuQuery, (String)TdbAuHelper.SOURCE_FQCN, TdbAuHelper.PROPERTY_NAMES, (String)TdbAuHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(tdbAuHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}", (Object)results.size());
                log.trace("results = {}", (Object)tdbAuHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getTdbAus() for tdbAuQuery = '" + tdbAuQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getTdbAus() for tdbAuQuery = '" + tdbAuQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getTdbPublishers(String tdbPublisherQuery) {
        log.debug2("tdbPublisherQuery = {}", (Object)tdbPublisherQuery);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        TdbPublisherHelper tdbPublisherHelper = new TdbPublisherHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)tdbPublisherQuery, (String)TdbPublisherHelper.SOURCE_FQCN, TdbPublisherHelper.PROPERTY_NAMES, (String)TdbPublisherHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(tdbPublisherHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}" + results.size());
                log.trace("results = {}", (Object)tdbPublisherHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getTdbPublishers() for tdbPublisherQuery = '" + tdbPublisherQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getTdbPublishers() for tdbPublisherQuery = '" + tdbPublisherQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity getTdbTitles(String tdbTitleQuery) {
        log.debug2("tdbTitleQuery = {}", (Object)tdbTitleQuery);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        TdbTitleHelper tdbTitleHelper = new TdbTitleHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)tdbTitleQuery, (String)TdbTitleHelper.SOURCE_FQCN, TdbTitleHelper.PROPERTY_NAMES, (String)TdbTitleHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(tdbTitleHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}" + results.size());
                log.trace("results = {}", (Object)tdbTitleHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, (HttpStatusCode)HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getTdbTitles() for tdbTitleQuery = '" + tdbTitleQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getTdbTitles() for tdbTitleQuery = '" + tdbTitleQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

