/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.21).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.crawler.api;

import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.laaws.crawler.model.CrawlerStatuses;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Validated
@Api(value = "crawlers", description = "the crawlers API")
@RequestMapping(value = "")
public interface CrawlersApi {

    CrawlersApiDelegate getDelegate();

    @ApiOperation(value = "Return information about a crawler.", nickname = "getCrawlerConfig", notes = "Get information related to a installed crawler.", response = CrawlerConfig.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "crawlers", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Crawler Configuration Found", response = CrawlerConfig.class),
        @ApiResponse(code = 401, message = "Access Denied."),
        @ApiResponse(code = 404, message = "No Such Crawler"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/crawlers/{crawlerId}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<CrawlerConfig> getCrawlerConfig(@ApiParam(value = "Identifier for the crawler",required=true) @PathVariable("crawlerId") String crawlerId) {
        return getDelegate().getCrawlerConfig(crawlerId);
    }


    @ApiOperation(value = "Get the list of supported crawlers.", nickname = "getCrawlers", notes = "Return the list of supported crawlers.", response = CrawlerStatuses.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "crawlers", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The Status of supported Crawlers.", response = CrawlerStatuses.class),
        @ApiResponse(code = 404, message = "No Such Crawler") })
    @RequestMapping(value = "/crawlers",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<CrawlerStatuses> getCrawlers() {
        return getDelegate().getCrawlers();
    }

}
