package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * A counter for urls.
 */
@ApiModel(description = "A counter for urls.")
@Validated


public class Counter   {
  @JsonProperty("count")
  private Integer count = null;

  @JsonProperty("itemsLink")
  private String itemsLink = null;

  public Counter count(Integer count) {
    this.count = count;
    return this;
  }

  /**
   * The number of elements
   * @return count
  **/
  @ApiModelProperty(required = true, value = "The number of elements")
  @NotNull


  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public Counter itemsLink(String itemsLink) {
    this.itemsLink = itemsLink;
    return this;
  }

  /**
   * A link to the list of count items or to a pager with count\\ \\ items.
   * @return itemsLink
  **/
  @ApiModelProperty(required = true, value = "A link to the list of count items or to a pager with count\\ \\ items.")
  @NotNull


  public String getItemsLink() {
    return itemsLink;
  }

  public void setItemsLink(String itemsLink) {
    this.itemsLink = itemsLink;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Counter counter = (Counter) o;
    return Objects.equals(this.count, counter.count) &&
        Objects.equals(this.itemsLink, counter.itemsLink);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, itemsLink);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Counter {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    itemsLink: ").append(toIndentedString(itemsLink)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

