package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.PageInfo;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * A display page of crawl status
 */
@ApiModel(description = "A display page of crawl status")
@Validated


public class CrawlPager   {
  @JsonProperty("crawls")
  @Valid
  private List<CrawlStatus> crawls = new ArrayList<>();

  @JsonProperty("pageInfo")
  private PageInfo pageInfo = null;

  public CrawlPager crawls(List<CrawlStatus> crawls) {
    this.crawls = crawls;
    return this;
  }

  public CrawlPager addCrawlsItem(CrawlStatus crawlsItem) {
    this.crawls.add(crawlsItem);
    return this;
  }

  /**
   * The crawls displayed in the page
   * @return crawls
  **/
  @ApiModelProperty(required = true, value = "The crawls displayed in the page")
  @NotNull

  @Valid

  public List<CrawlStatus> getCrawls() {
    return crawls;
  }

  public void setCrawls(List<CrawlStatus> crawls) {
    this.crawls = crawls;
  }

  public CrawlPager pageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

  /**
   * Get pageInfo
   * @return pageInfo
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrawlPager crawlPager = (CrawlPager) o;
    return Objects.equals(this.crawls, crawlPager.crawls) &&
        Objects.equals(this.pageInfo, crawlPager.pageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(crawls, pageInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrawlPager {\n");
    
    sb.append("    crawls: ").append(toIndentedString(crawls)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

