package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.lockss.laaws.crawler.model.CrawlWsResultPagesWithErrors;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CrawlWsResult
 */
@Validated


public class CrawlWsResult   {
  @JsonProperty("auId")
  private String auId = null;

  @JsonProperty("auName")
  private String auName = null;

  @JsonProperty("priority")
  private Integer priority = null;

  @JsonProperty("crawlKey")
  private String crawlKey = null;

  @JsonProperty("crawlType")
  private String crawlType = null;

  @JsonProperty("startTime")
  private Integer startTime = null;

  @JsonProperty("duration")
  private Integer duration = null;

  @JsonProperty("crawlStatus")
  private String crawlStatus = null;

  @JsonProperty("bytesFetchedCount")
  private Integer bytesFetchedCount = null;

  @JsonProperty("pagesFetchedCount")
  private Integer pagesFetchedCount = null;

  @JsonProperty("pagesFetched")
  @Valid
  private List<String> pagesFetched = null;

  @JsonProperty("pagesParsedCount")
  private Integer pagesParsedCount = null;

  @JsonProperty("pagesParsed")
  @Valid
  private List<String> pagesParsed = null;

  @JsonProperty("pagesPendingCount")
  private Integer pagesPendingCount = null;

  @JsonProperty("pagesPending")
  @Valid
  private List<String> pagesPending = null;

  @JsonProperty("pagesExcludedCount")
  private Integer pagesExcludedCount = null;

  @JsonProperty("pagesExcluded")
  @Valid
  private List<String> pagesExcluded = null;

  @JsonProperty("offSiteUrlsExcludedCount")
  private Integer offSiteUrlsExcludedCount = null;

  @JsonProperty("pagesNotModifiedCount")
  private Integer pagesNotModifiedCount = null;

  @JsonProperty("pagesNotModified")
  @Valid
  private List<String> pagesNotModified = null;

  @JsonProperty("pagesWithErrorsCount")
  private Integer pagesWithErrorsCount = null;

  @JsonProperty("pagesWithErrors")
  @Valid
  private List<CrawlWsResultPagesWithErrors> pagesWithErrors = null;

  @JsonProperty("mimeTypeCount")
  private Integer mimeTypeCount = null;

  @JsonProperty("mimeTypes")
  @Valid
  private List<String> mimeTypes = null;

  @JsonProperty("sources")
  @Valid
  private List<String> sources = null;

  @JsonProperty("startingUrls")
  @Valid
  private List<String> startingUrls = null;

  @JsonProperty("refetchDepth")
  private Integer refetchDepth = null;

  @JsonProperty("linkDepth")
  private Integer linkDepth = null;

  public CrawlWsResult auId(String auId) {
    this.auId = auId;
    return this;
  }

  /**
   * Get auId
   * @return auId
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getAuId() {
    return auId;
  }

  public void setAuId(String auId) {
    this.auId = auId;
  }

  public CrawlWsResult auName(String auName) {
    this.auName = auName;
    return this;
  }

  /**
   * Get auName
   * @return auName
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getAuName() {
    return auName;
  }

  public void setAuName(String auName) {
    this.auName = auName;
  }

  public CrawlWsResult priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
  **/
  @ApiModelProperty(value = "")


  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  public CrawlWsResult crawlKey(String crawlKey) {
    this.crawlKey = crawlKey;
    return this;
  }

  /**
   * Get crawlKey
   * @return crawlKey
  **/
  @ApiModelProperty(value = "")


  public String getCrawlKey() {
    return crawlKey;
  }

  public void setCrawlKey(String crawlKey) {
    this.crawlKey = crawlKey;
  }

  public CrawlWsResult crawlType(String crawlType) {
    this.crawlType = crawlType;
    return this;
  }

  /**
   * Get crawlType
   * @return crawlType
  **/
  @ApiModelProperty(value = "")


  public String getCrawlType() {
    return crawlType;
  }

  public void setCrawlType(String crawlType) {
    this.crawlType = crawlType;
  }

  public CrawlWsResult startTime(Integer startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Get startTime
   * @return startTime
  **/
  @ApiModelProperty(value = "")


  public Integer getStartTime() {
    return startTime;
  }

  public void setStartTime(Integer startTime) {
    this.startTime = startTime;
  }

  public CrawlWsResult duration(Integer duration) {
    this.duration = duration;
    return this;
  }

  /**
   * Get duration
   * @return duration
  **/
  @ApiModelProperty(value = "")


  public Integer getDuration() {
    return duration;
  }

  public void setDuration(Integer duration) {
    this.duration = duration;
  }

  public CrawlWsResult crawlStatus(String crawlStatus) {
    this.crawlStatus = crawlStatus;
    return this;
  }

  /**
   * Get crawlStatus
   * @return crawlStatus
  **/
  @ApiModelProperty(value = "")


  public String getCrawlStatus() {
    return crawlStatus;
  }

  public void setCrawlStatus(String crawlStatus) {
    this.crawlStatus = crawlStatus;
  }

  public CrawlWsResult bytesFetchedCount(Integer bytesFetchedCount) {
    this.bytesFetchedCount = bytesFetchedCount;
    return this;
  }

  /**
   * Get bytesFetchedCount
   * @return bytesFetchedCount
  **/
  @ApiModelProperty(value = "")


  public Integer getBytesFetchedCount() {
    return bytesFetchedCount;
  }

  public void setBytesFetchedCount(Integer bytesFetchedCount) {
    this.bytesFetchedCount = bytesFetchedCount;
  }

  public CrawlWsResult pagesFetchedCount(Integer pagesFetchedCount) {
    this.pagesFetchedCount = pagesFetchedCount;
    return this;
  }

  /**
   * Get pagesFetchedCount
   * @return pagesFetchedCount
  **/
  @ApiModelProperty(value = "")


  public Integer getPagesFetchedCount() {
    return pagesFetchedCount;
  }

  public void setPagesFetchedCount(Integer pagesFetchedCount) {
    this.pagesFetchedCount = pagesFetchedCount;
  }

  public CrawlWsResult pagesFetched(List<String> pagesFetched) {
    this.pagesFetched = pagesFetched;
    return this;
  }

  public CrawlWsResult addPagesFetchedItem(String pagesFetchedItem) {
    if (this.pagesFetched == null) {
      this.pagesFetched = new ArrayList<>();
    }
    this.pagesFetched.add(pagesFetchedItem);
    return this;
  }

  /**
   * Get pagesFetched
   * @return pagesFetched
  **/
  @ApiModelProperty(value = "")


  public List<String> getPagesFetched() {
    return pagesFetched;
  }

  public void setPagesFetched(List<String> pagesFetched) {
    this.pagesFetched = pagesFetched;
  }

  public CrawlWsResult pagesParsedCount(Integer pagesParsedCount) {
    this.pagesParsedCount = pagesParsedCount;
    return this;
  }

  /**
   * Get pagesParsedCount
   * @return pagesParsedCount
  **/
  @ApiModelProperty(value = "")


  public Integer getPagesParsedCount() {
    return pagesParsedCount;
  }

  public void setPagesParsedCount(Integer pagesParsedCount) {
    this.pagesParsedCount = pagesParsedCount;
  }

  public CrawlWsResult pagesParsed(List<String> pagesParsed) {
    this.pagesParsed = pagesParsed;
    return this;
  }

  public CrawlWsResult addPagesParsedItem(String pagesParsedItem) {
    if (this.pagesParsed == null) {
      this.pagesParsed = new ArrayList<>();
    }
    this.pagesParsed.add(pagesParsedItem);
    return this;
  }

  /**
   * Get pagesParsed
   * @return pagesParsed
  **/
  @ApiModelProperty(value = "")


  public List<String> getPagesParsed() {
    return pagesParsed;
  }

  public void setPagesParsed(List<String> pagesParsed) {
    this.pagesParsed = pagesParsed;
  }

  public CrawlWsResult pagesPendingCount(Integer pagesPendingCount) {
    this.pagesPendingCount = pagesPendingCount;
    return this;
  }

  /**
   * Get pagesPendingCount
   * @return pagesPendingCount
  **/
  @ApiModelProperty(value = "")


  public Integer getPagesPendingCount() {
    return pagesPendingCount;
  }

  public void setPagesPendingCount(Integer pagesPendingCount) {
    this.pagesPendingCount = pagesPendingCount;
  }

  public CrawlWsResult pagesPending(List<String> pagesPending) {
    this.pagesPending = pagesPending;
    return this;
  }

  public CrawlWsResult addPagesPendingItem(String pagesPendingItem) {
    if (this.pagesPending == null) {
      this.pagesPending = new ArrayList<>();
    }
    this.pagesPending.add(pagesPendingItem);
    return this;
  }

  /**
   * Get pagesPending
   * @return pagesPending
  **/
  @ApiModelProperty(value = "")


  public List<String> getPagesPending() {
    return pagesPending;
  }

  public void setPagesPending(List<String> pagesPending) {
    this.pagesPending = pagesPending;
  }

  public CrawlWsResult pagesExcludedCount(Integer pagesExcludedCount) {
    this.pagesExcludedCount = pagesExcludedCount;
    return this;
  }

  /**
   * Get pagesExcludedCount
   * @return pagesExcludedCount
  **/
  @ApiModelProperty(value = "")


  public Integer getPagesExcludedCount() {
    return pagesExcludedCount;
  }

  public void setPagesExcludedCount(Integer pagesExcludedCount) {
    this.pagesExcludedCount = pagesExcludedCount;
  }

  public CrawlWsResult pagesExcluded(List<String> pagesExcluded) {
    this.pagesExcluded = pagesExcluded;
    return this;
  }

  public CrawlWsResult addPagesExcludedItem(String pagesExcludedItem) {
    if (this.pagesExcluded == null) {
      this.pagesExcluded = new ArrayList<>();
    }
    this.pagesExcluded.add(pagesExcludedItem);
    return this;
  }

  /**
   * Get pagesExcluded
   * @return pagesExcluded
  **/
  @ApiModelProperty(value = "")


  public List<String> getPagesExcluded() {
    return pagesExcluded;
  }

  public void setPagesExcluded(List<String> pagesExcluded) {
    this.pagesExcluded = pagesExcluded;
  }

  public CrawlWsResult offSiteUrlsExcludedCount(Integer offSiteUrlsExcludedCount) {
    this.offSiteUrlsExcludedCount = offSiteUrlsExcludedCount;
    return this;
  }

  /**
   * Get offSiteUrlsExcludedCount
   * @return offSiteUrlsExcludedCount
  **/
  @ApiModelProperty(value = "")


  public Integer getOffSiteUrlsExcludedCount() {
    return offSiteUrlsExcludedCount;
  }

  public void setOffSiteUrlsExcludedCount(Integer offSiteUrlsExcludedCount) {
    this.offSiteUrlsExcludedCount = offSiteUrlsExcludedCount;
  }

  public CrawlWsResult pagesNotModifiedCount(Integer pagesNotModifiedCount) {
    this.pagesNotModifiedCount = pagesNotModifiedCount;
    return this;
  }

  /**
   * Get pagesNotModifiedCount
   * @return pagesNotModifiedCount
  **/
  @ApiModelProperty(value = "")


  public Integer getPagesNotModifiedCount() {
    return pagesNotModifiedCount;
  }

  public void setPagesNotModifiedCount(Integer pagesNotModifiedCount) {
    this.pagesNotModifiedCount = pagesNotModifiedCount;
  }

  public CrawlWsResult pagesNotModified(List<String> pagesNotModified) {
    this.pagesNotModified = pagesNotModified;
    return this;
  }

  public CrawlWsResult addPagesNotModifiedItem(String pagesNotModifiedItem) {
    if (this.pagesNotModified == null) {
      this.pagesNotModified = new ArrayList<>();
    }
    this.pagesNotModified.add(pagesNotModifiedItem);
    return this;
  }

  /**
   * Get pagesNotModified
   * @return pagesNotModified
  **/
  @ApiModelProperty(value = "")


  public List<String> getPagesNotModified() {
    return pagesNotModified;
  }

  public void setPagesNotModified(List<String> pagesNotModified) {
    this.pagesNotModified = pagesNotModified;
  }

  public CrawlWsResult pagesWithErrorsCount(Integer pagesWithErrorsCount) {
    this.pagesWithErrorsCount = pagesWithErrorsCount;
    return this;
  }

  /**
   * Get pagesWithErrorsCount
   * @return pagesWithErrorsCount
  **/
  @ApiModelProperty(value = "")


  public Integer getPagesWithErrorsCount() {
    return pagesWithErrorsCount;
  }

  public void setPagesWithErrorsCount(Integer pagesWithErrorsCount) {
    this.pagesWithErrorsCount = pagesWithErrorsCount;
  }

  public CrawlWsResult pagesWithErrors(List<CrawlWsResultPagesWithErrors> pagesWithErrors) {
    this.pagesWithErrors = pagesWithErrors;
    return this;
  }

  public CrawlWsResult addPagesWithErrorsItem(CrawlWsResultPagesWithErrors pagesWithErrorsItem) {
    if (this.pagesWithErrors == null) {
      this.pagesWithErrors = new ArrayList<>();
    }
    this.pagesWithErrors.add(pagesWithErrorsItem);
    return this;
  }

  /**
   * Get pagesWithErrors
   * @return pagesWithErrors
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<CrawlWsResultPagesWithErrors> getPagesWithErrors() {
    return pagesWithErrors;
  }

  public void setPagesWithErrors(List<CrawlWsResultPagesWithErrors> pagesWithErrors) {
    this.pagesWithErrors = pagesWithErrors;
  }

  public CrawlWsResult mimeTypeCount(Integer mimeTypeCount) {
    this.mimeTypeCount = mimeTypeCount;
    return this;
  }

  /**
   * Get mimeTypeCount
   * @return mimeTypeCount
  **/
  @ApiModelProperty(value = "")


  public Integer getMimeTypeCount() {
    return mimeTypeCount;
  }

  public void setMimeTypeCount(Integer mimeTypeCount) {
    this.mimeTypeCount = mimeTypeCount;
  }

  public CrawlWsResult mimeTypes(List<String> mimeTypes) {
    this.mimeTypes = mimeTypes;
    return this;
  }

  public CrawlWsResult addMimeTypesItem(String mimeTypesItem) {
    if (this.mimeTypes == null) {
      this.mimeTypes = new ArrayList<>();
    }
    this.mimeTypes.add(mimeTypesItem);
    return this;
  }

  /**
   * Get mimeTypes
   * @return mimeTypes
  **/
  @ApiModelProperty(value = "")


  public List<String> getMimeTypes() {
    return mimeTypes;
  }

  public void setMimeTypes(List<String> mimeTypes) {
    this.mimeTypes = mimeTypes;
  }

  public CrawlWsResult sources(List<String> sources) {
    this.sources = sources;
    return this;
  }

  public CrawlWsResult addSourcesItem(String sourcesItem) {
    if (this.sources == null) {
      this.sources = new ArrayList<>();
    }
    this.sources.add(sourcesItem);
    return this;
  }

  /**
   * Get sources
   * @return sources
  **/
  @ApiModelProperty(value = "")


  public List<String> getSources() {
    return sources;
  }

  public void setSources(List<String> sources) {
    this.sources = sources;
  }

  public CrawlWsResult startingUrls(List<String> startingUrls) {
    this.startingUrls = startingUrls;
    return this;
  }

  public CrawlWsResult addStartingUrlsItem(String startingUrlsItem) {
    if (this.startingUrls == null) {
      this.startingUrls = new ArrayList<>();
    }
    this.startingUrls.add(startingUrlsItem);
    return this;
  }

  /**
   * Get startingUrls
   * @return startingUrls
  **/
  @ApiModelProperty(value = "")


  public List<String> getStartingUrls() {
    return startingUrls;
  }

  public void setStartingUrls(List<String> startingUrls) {
    this.startingUrls = startingUrls;
  }

  public CrawlWsResult refetchDepth(Integer refetchDepth) {
    this.refetchDepth = refetchDepth;
    return this;
  }

  /**
   * Get refetchDepth
   * @return refetchDepth
  **/
  @ApiModelProperty(value = "")


  public Integer getRefetchDepth() {
    return refetchDepth;
  }

  public void setRefetchDepth(Integer refetchDepth) {
    this.refetchDepth = refetchDepth;
  }

  public CrawlWsResult linkDepth(Integer linkDepth) {
    this.linkDepth = linkDepth;
    return this;
  }

  /**
   * Get linkDepth
   * @return linkDepth
  **/
  @ApiModelProperty(value = "")


  public Integer getLinkDepth() {
    return linkDepth;
  }

  public void setLinkDepth(Integer linkDepth) {
    this.linkDepth = linkDepth;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrawlWsResult crawlWsResult = (CrawlWsResult) o;
    return Objects.equals(this.auId, crawlWsResult.auId) &&
        Objects.equals(this.auName, crawlWsResult.auName) &&
        Objects.equals(this.priority, crawlWsResult.priority) &&
        Objects.equals(this.crawlKey, crawlWsResult.crawlKey) &&
        Objects.equals(this.crawlType, crawlWsResult.crawlType) &&
        Objects.equals(this.startTime, crawlWsResult.startTime) &&
        Objects.equals(this.duration, crawlWsResult.duration) &&
        Objects.equals(this.crawlStatus, crawlWsResult.crawlStatus) &&
        Objects.equals(this.bytesFetchedCount, crawlWsResult.bytesFetchedCount) &&
        Objects.equals(this.pagesFetchedCount, crawlWsResult.pagesFetchedCount) &&
        Objects.equals(this.pagesFetched, crawlWsResult.pagesFetched) &&
        Objects.equals(this.pagesParsedCount, crawlWsResult.pagesParsedCount) &&
        Objects.equals(this.pagesParsed, crawlWsResult.pagesParsed) &&
        Objects.equals(this.pagesPendingCount, crawlWsResult.pagesPendingCount) &&
        Objects.equals(this.pagesPending, crawlWsResult.pagesPending) &&
        Objects.equals(this.pagesExcludedCount, crawlWsResult.pagesExcludedCount) &&
        Objects.equals(this.pagesExcluded, crawlWsResult.pagesExcluded) &&
        Objects.equals(this.offSiteUrlsExcludedCount, crawlWsResult.offSiteUrlsExcludedCount) &&
        Objects.equals(this.pagesNotModifiedCount, crawlWsResult.pagesNotModifiedCount) &&
        Objects.equals(this.pagesNotModified, crawlWsResult.pagesNotModified) &&
        Objects.equals(this.pagesWithErrorsCount, crawlWsResult.pagesWithErrorsCount) &&
        Objects.equals(this.pagesWithErrors, crawlWsResult.pagesWithErrors) &&
        Objects.equals(this.mimeTypeCount, crawlWsResult.mimeTypeCount) &&
        Objects.equals(this.mimeTypes, crawlWsResult.mimeTypes) &&
        Objects.equals(this.sources, crawlWsResult.sources) &&
        Objects.equals(this.startingUrls, crawlWsResult.startingUrls) &&
        Objects.equals(this.refetchDepth, crawlWsResult.refetchDepth) &&
        Objects.equals(this.linkDepth, crawlWsResult.linkDepth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(auId, auName, priority, crawlKey, crawlType, startTime, duration, crawlStatus, bytesFetchedCount, pagesFetchedCount, pagesFetched, pagesParsedCount, pagesParsed, pagesPendingCount, pagesPending, pagesExcludedCount, pagesExcluded, offSiteUrlsExcludedCount, pagesNotModifiedCount, pagesNotModified, pagesWithErrorsCount, pagesWithErrors, mimeTypeCount, mimeTypes, sources, startingUrls, refetchDepth, linkDepth);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrawlWsResult {\n");
    
    sb.append("    auId: ").append(toIndentedString(auId)).append("\n");
    sb.append("    auName: ").append(toIndentedString(auName)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    crawlKey: ").append(toIndentedString(crawlKey)).append("\n");
    sb.append("    crawlType: ").append(toIndentedString(crawlType)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    crawlStatus: ").append(toIndentedString(crawlStatus)).append("\n");
    sb.append("    bytesFetchedCount: ").append(toIndentedString(bytesFetchedCount)).append("\n");
    sb.append("    pagesFetchedCount: ").append(toIndentedString(pagesFetchedCount)).append("\n");
    sb.append("    pagesFetched: ").append(toIndentedString(pagesFetched)).append("\n");
    sb.append("    pagesParsedCount: ").append(toIndentedString(pagesParsedCount)).append("\n");
    sb.append("    pagesParsed: ").append(toIndentedString(pagesParsed)).append("\n");
    sb.append("    pagesPendingCount: ").append(toIndentedString(pagesPendingCount)).append("\n");
    sb.append("    pagesPending: ").append(toIndentedString(pagesPending)).append("\n");
    sb.append("    pagesExcludedCount: ").append(toIndentedString(pagesExcludedCount)).append("\n");
    sb.append("    pagesExcluded: ").append(toIndentedString(pagesExcluded)).append("\n");
    sb.append("    offSiteUrlsExcludedCount: ").append(toIndentedString(offSiteUrlsExcludedCount)).append("\n");
    sb.append("    pagesNotModifiedCount: ").append(toIndentedString(pagesNotModifiedCount)).append("\n");
    sb.append("    pagesNotModified: ").append(toIndentedString(pagesNotModified)).append("\n");
    sb.append("    pagesWithErrorsCount: ").append(toIndentedString(pagesWithErrorsCount)).append("\n");
    sb.append("    pagesWithErrors: ").append(toIndentedString(pagesWithErrors)).append("\n");
    sb.append("    mimeTypeCount: ").append(toIndentedString(mimeTypeCount)).append("\n");
    sb.append("    mimeTypes: ").append(toIndentedString(mimeTypes)).append("\n");
    sb.append("    sources: ").append(toIndentedString(sources)).append("\n");
    sb.append("    startingUrls: ").append(toIndentedString(startingUrls)).append("\n");
    sb.append("    refetchDepth: ").append(toIndentedString(refetchDepth)).append("\n");
    sb.append("    linkDepth: ").append(toIndentedString(linkDepth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

