package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Configuration information about a specific crawler.
 */
@ApiModel(description = "Configuration information about a specific crawler.")
@Validated


public class CrawlerConfig   {
  @JsonProperty("crawlerId")
  private String crawlerId = null;

  @JsonProperty("attributes")
  @Valid
  private Map<String, String> attributes = new HashMap<>();

  public CrawlerConfig crawlerId(String crawlerId) {
    this.crawlerId = crawlerId;
    return this;
  }

  /**
   * The identifier for this crawler
   * @return crawlerId
  **/
  @ApiModelProperty(example = "classic", required = true, value = "The identifier for this crawler")
  @NotNull


  public String getCrawlerId() {
    return crawlerId;
  }

  public void setCrawlerId(String crawlerId) {
    this.crawlerId = crawlerId;
  }

  public CrawlerConfig attributes(Map<String, String> attributes) {
    this.attributes = attributes;
    return this;
  }

  public CrawlerConfig putAttributesItem(String key, String attributesItem) {
    this.attributes.put(key, attributesItem);
    return this;
  }

  /**
   * key value pairs specific providing attributes\\ \\ and configuration information.
   * @return attributes
  **/
  @ApiModelProperty(required = true, value = "key value pairs specific providing attributes\\ \\ and configuration information.")
  @NotNull


  public Map<String, String> getAttributes() {
    return attributes;
  }

  public void setAttributes(Map<String, String> attributes) {
    this.attributes = attributes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrawlerConfig crawlerConfig = (CrawlerConfig) o;
    return Objects.equals(this.crawlerId, crawlerConfig.crawlerId) &&
        Objects.equals(this.attributes, crawlerConfig.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(crawlerId, attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrawlerConfig {\n");
    
    sb.append("    crawlerId: ").append(toIndentedString(crawlerId)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

