package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lockss.laaws.crawler.model.CrawlerStatus;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * The metadata generated for a single item
 */
@ApiModel(description = "The metadata generated for a single item")
@Validated


public class CrawlerStatuses   {
  @JsonProperty("crawlerMap")
  @Valid
  private Map<String, CrawlerStatus> crawlerMap = null;

  public CrawlerStatuses crawlerMap(Map<String, CrawlerStatus> crawlerMap) {
    this.crawlerMap = crawlerMap;
    return this;
  }

  public CrawlerStatuses putCrawlerMapItem(String key, CrawlerStatus crawlerMapItem) {
    if (this.crawlerMap == null) {
      this.crawlerMap = new HashMap<>();
    }
    this.crawlerMap.put(key, crawlerMapItem);
    return this;
  }

  /**
   * An map of crawler status objects
   * @return crawlerMap
  **/
  @ApiModelProperty(value = "An map of crawler status objects")

  @Valid

  public Map<String, CrawlerStatus> getCrawlerMap() {
    return crawlerMap;
  }

  public void setCrawlerMap(Map<String, CrawlerStatus> crawlerMap) {
    this.crawlerMap = crawlerMap;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrawlerStatuses crawlerStatuses = (CrawlerStatuses) o;
    return Objects.equals(this.crawlerMap, crawlerStatuses.crawlerMap);
  }

  @Override
  public int hashCode() {
    return Objects.hash(crawlerMap);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrawlerStatuses {\n");
    
    sb.append("    crawlerMap: ").append(toIndentedString(crawlerMap)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

